/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.antiraidfarm;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.raid.RaidTriggerEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class AntiRaidFarm
extends JavaPlugin
implements Listener {
    private Cache<UUID, Long> lastRaidCache;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        int raidCooldownSeconds = this.getConfig().getInt("raid-cooldown-seconds", 180);
        this.lastRaidCache = CacheBuilder.newBuilder().expireAfterWrite((long)raidCooldownSeconds, TimeUnit.SECONDS).build();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    @EventHandler
    public void onRaidTrigger(RaidTriggerEvent event) {
        boolean hasCooldown;
        Player player = event.getPlayer();
        if (player.hasPermission("antiraidfarm.bypass")) {
            return;
        }
        boolean bl = hasCooldown = this.lastRaidCache.getIfPresent((Object)player.getUniqueId()) != null;
        if (hasCooldown) {
            event.setCancelled(true);
        } else {
            this.lastRaidCache.put((Object)player.getUniqueId(), (Object)System.currentTimeMillis());
        }
    }
}

