/*
 * Decompiled with CFR 0.152.
 */
package optic_fusion1.screamingtrees;

import de.slikey.effectlib.EffectManager;
import de.slikey.effectlib.effect.BleedEffect;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import optic_fusion1.screamingtrees.ScreamingTrees;
import optic_fusion1.screamingtrees.ThrowItemRunnable;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Tree {
    private EffectManager em;
    public static Map<Item, Tree> itemsBeingThrown = new HashMap<Item, Tree>();
    private Location treeLocation;
    private ScreamingTrees plugin;
    private Random rand;
    private List<Sound> sounds = new ArrayList<Sound>();

    public Tree(ScreamingTrees plugin, Block argTreeBlock) {
        this.em = new EffectManager((Plugin)plugin);
        this.treeLocation = argTreeBlock.getLocation();
        this.plugin = plugin;
        this.rand = plugin.getRandom();
        for (String string : plugin.getConfig().getStringList("TreeScream.Sounds")) {
            try {
                Sound sound = Sound.valueOf((String)string.toUpperCase());
                this.sounds.add(sound);
            }
            catch (Exception e) {
                plugin.getLogger().log(Level.WARNING, "{0} is not a valid sound", string.toUpperCase());
            }
        }
    }

    public void bleed() {
        boolean allowed = this.plugin.getBleedAllowed();
        int chance = this.plugin.getBleedChance();
        if (allowed && this.rand.nextInt(100) < chance) {
            BleedEffect effect = new BleedEffect(this.em);
            effect.setLocation(this.treeLocation);
            effect.iterations = 1;
            effect.start();
            this.em.disposeOnTermination();
        }
    }

    public void scream() {
        boolean allowed = this.plugin.getScreamAllowed();
        int chance = this.plugin.getScreamChance();
        if (allowed && this.rand.nextInt(100) < chance) {
            Sound sound = this.sounds.get(ThreadLocalRandom.current().nextInt(this.sounds.size()));
            this.treeLocation.getWorld().playSound(this.treeLocation, sound, 1.0f, 1.0f);
        }
    }

    public void speak(Player player) {
        boolean allowed = this.plugin.getSpeakAllowed();
        int chance = this.plugin.getSpeakChance();
        if (allowed && this.rand.nextInt(100) < chance) {
            player.sendMessage(this.getRandomSpeakMessage());
        }
    }

    public void throwItem(Player player) {
        boolean allowed = this.plugin.getThrowAllowed();
        int chance = this.plugin.getThrowChance();
        if (allowed && this.rand.nextInt(100) < chance) {
            Location throwLoc = this.treeLocation;
            throwLoc.add(0.0, 3.0, 0.0);
            Item item = player.getWorld().dropItemNaturally(throwLoc, new ItemStack(Material.APPLE));
            itemsBeingThrown.put(item, this);
            new ThrowItemRunnable(item, player).runTaskTimer((Plugin)this.plugin, 0L, 1L);
        }
    }

    public boolean isTreeInWorld() {
        return this.plugin.getAllWorlds() || this.plugin.getWorlds().stream().anyMatch(world -> this.treeLocation.getWorld().getName().equalsIgnoreCase((String)world));
    }

    public boolean isTreeInBiome() {
        return this.plugin.getAllBiomes() || this.plugin.getBiomes().stream().anyMatch(biome -> this.treeLocation.getBlock().getBiome().toString().equalsIgnoreCase((String)biome));
    }

    private String getRandomSpeakMessage() {
        List<String> messages = this.plugin.getSpeakMessages();
        return "<Tree> " + messages.get(this.rand.nextInt(messages.size()));
    }
}

