/*
 * Decompiled with CFR 0.152.
 */
package optic_fusion1.screamingtrees;

import java.util.List;
import java.util.Random;
import java.util.concurrent.ThreadLocalRandom;
import java.util.logging.Level;
import java.util.logging.Logger;
import optic_fusion1.screamingtrees.MetricsLite;
import optic_fusion1.screamingtrees.ScreamingTreesListener;
import optic_fusion1.screamingtrees.Updater;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ScreamingTrees
extends JavaPlugin {
    private static final Random RANDOM = ThreadLocalRandom.current();

    public void onEnable() {
        new MetricsLite((Plugin)this, 8685);
        this.checkForUpdate();
        Bukkit.getPluginManager().registerEvents((Listener)new ScreamingTreesListener(this), (Plugin)this);
        this.getConfig().options().copyDefaults(true);
        this.saveConfig();
    }

    private void checkForUpdate() {
        Logger logger = this.getLogger();
        FileConfiguration pluginConfig = this.getConfig();
        Updater updater = new Updater(this, 83235, false);
        Updater.UpdateResult result = updater.getResult();
        if (result == Updater.UpdateResult.UPDATE_AVAILABLE) {
            if (!pluginConfig.isSet("auto-update") || !pluginConfig.getBoolean("auto-update")) {
                logger.info("===== UPDATE AVAILABLE ====");
                logger.info("https://www.spigotmc.org/resources/screamingtrees.83235/");
                logger.log(Level.INFO, "Installed Version: {0} New Version:{1}", new Object[]{updater.getOldVersion(), updater.getVersion()});
                logger.info("===== UPDATE AVAILABLE ====");
            } else if (pluginConfig.getBoolean("auto-update")) {
                updater.downloadUpdate();
            }
        }
    }

    public Random getRandom() {
        return RANDOM;
    }

    public boolean getBleedAllowed() {
        return this.getConfig().getBoolean("TreeBleed.Allowed");
    }

    public int getBleedChance() {
        return this.getConfig().getInt("TreeBleed.Chance");
    }

    public boolean getScreamAllowed() {
        return this.getConfig().getBoolean("TreeScream.Allowed");
    }

    public int getScreamChance() {
        return this.getConfig().getInt("TreeScream.Chance");
    }

    public boolean getSpeakAllowed() {
        return this.getConfig().getBoolean("TreeSpeak.Allowed");
    }

    public int getSpeakChance() {
        return this.getConfig().getInt("TreeSpeak.Chance");
    }

    public List<String> getSpeakMessages() {
        return this.getConfig().getStringList("TreeSpeak.Messages");
    }

    public boolean getThrowAllowed() {
        return this.getConfig().getBoolean("TreeThrow.Allowed");
    }

    public int getThrowChance() {
        return this.getConfig().getInt("TreeThrow.Chance");
    }

    public int getThrowDamage() {
        return this.getConfig().getInt("TreeThrow.Damage");
    }

    public boolean getAllWorlds() {
        return this.getConfig().getBoolean("Worlds.AllWorlds");
    }

    public List<String> getWorlds() {
        return this.getConfig().getStringList("Worlds.Worlds");
    }

    public boolean getAllBiomes() {
        return this.getConfig().getBoolean("Biomes.AllBiomes");
    }

    public List<String> getBiomes() {
        return this.getConfig().getStringList("Biomes.Biomes");
    }
}

