/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.bossbar;

import java.util.Collection;
import java.util.Collections;
import java.util.Random;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitRunnable;
import org.inventivetalent.bossbar.BossBar;
import org.inventivetalent.bossbar.BossBarAPI;
import org.inventivetalent.bossbar.BossBarPlugin;
import org.inventivetalent.bossbar.reflection.ClassBuilder;
import org.inventivetalent.bossbar.reflection.NMSClass;
import org.inventivetalent.reflection.minecraft.DataWatcher;

public class EntityBossBar
extends BukkitRunnable
implements BossBar {
    protected static int ENTITY_DISTANCE = 32;
    protected final int ID = new Random().nextInt();
    protected final UUID uuid = UUID.randomUUID();
    protected final Player receiver;
    protected String message;
    protected float health;
    protected float healthMinus;
    protected float minHealth = 1.0f;
    protected Location location;
    protected World world;
    protected boolean visible = false;
    protected Object dataWatcher;

    protected EntityBossBar(Player player, String message, float percentage, int timeout, float minHealth) {
        this.receiver = player;
        this.message = message;
        this.health = percentage / 100.0f * this.getMaxHealth();
        this.minHealth = minHealth;
        this.world = player.getWorld();
        this.location = this.makeLocation(player.getLocation());
        if (percentage <= minHealth) {
            BossBarAPI.removeBar(player);
        }
        if (timeout > 0) {
            this.healthMinus = this.getMaxHealth() / (float)timeout;
            this.runTaskTimer(BossBarPlugin.instance, 20L, 20L);
        }
    }

    protected Location makeLocation(Location base) {
        return base.getDirection().multiply(ENTITY_DISTANCE).add(base.toVector()).toLocation(this.world);
    }

    @Override
    public Player getReceiver() {
        return this.receiver;
    }

    @Override
    public float getMaxHealth() {
        return 300.0f;
    }

    @Override
    public void setHealth(float percentage) {
        this.health = percentage / 100.0f * this.getMaxHealth();
        if (this.health <= this.minHealth) {
            BossBarAPI.removeBar(this.receiver);
        } else {
            this.sendMetadata();
        }
    }

    @Override
    public float getHealth() {
        return this.health;
    }

    @Override
    public void setMessage(String message) {
        this.message = message;
        if (this.isVisible()) {
            this.sendMetadata();
        }
    }

    @Override
    public Collection<? extends Player> getPlayers() {
        return Collections.singletonList(this.getReceiver());
    }

    @Override
    public void addPlayer(Player player) {
    }

    @Override
    public void removePlayer(Player player) {
        this.setVisible(false);
    }

    @Override
    public BossBarAPI.Color getColor() {
        return null;
    }

    @Override
    public void setColor(BossBarAPI.Color color) {
    }

    @Override
    public BossBarAPI.Style getStyle() {
        return null;
    }

    @Override
    public void setStyle(BossBarAPI.Style style) {
    }

    @Override
    public void setProperty(BossBarAPI.Property property, boolean flag) {
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    public void run() {
        this.health -= this.healthMinus;
        if (this.health <= this.minHealth) {
            BossBarAPI.removeBar(this.receiver);
        } else {
            this.sendMetadata();
        }
    }

    @Override
    public void setVisible(boolean flag) {
        if (flag == this.visible) {
            return;
        }
        if (flag) {
            this.spawn();
        } else {
            this.destroy();
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setProgress(float progress) {
        this.setHealth(progress * 100.0f);
    }

    @Override
    public float getProgress() {
        return this.getHealth() / 100.0f;
    }

    @Override
    public void updateMovement() {
        if (!this.visible) {
            return;
        }
        this.location = this.makeLocation(this.receiver.getLocation());
        try {
            Object packet = ClassBuilder.buildTeleportPacket(this.ID, this.getLocation(), false, false);
            BossBarAPI.sendPacket(this.receiver, packet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateDataWatcher() {
        if (this.dataWatcher == null) {
            try {
                this.dataWatcher = DataWatcher.newDataWatcher(null);
                DataWatcher.setValue(this.dataWatcher, 17, DataWatcher.V1_9.ValueType.ENTITY_WITHER_a, (Object)new Integer(0));
                DataWatcher.setValue(this.dataWatcher, 18, DataWatcher.V1_9.ValueType.ENTITY_WIHER_b, (Object)new Integer(0));
                DataWatcher.setValue(this.dataWatcher, 19, DataWatcher.V1_9.ValueType.ENTITY_WITHER_c, (Object)new Integer(0));
                DataWatcher.setValue(this.dataWatcher, 20, DataWatcher.V1_9.ValueType.ENTITY_WITHER_bw, (Object)new Integer(1000));
                DataWatcher.setValue(this.dataWatcher, 0, DataWatcher.V1_9.ValueType.ENTITY_FLAG, (Object)32);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            DataWatcher.setValue(this.dataWatcher, 6, DataWatcher.V1_9.ValueType.ENTITY_LIVING_HEALTH, (Object)Float.valueOf(this.health));
            DataWatcher.setValue(this.dataWatcher, 10, DataWatcher.V1_9.ValueType.ENTITY_NAME, (Object)this.message);
            DataWatcher.setValue(this.dataWatcher, 2, DataWatcher.V1_9.ValueType.ENTITY_NAME, (Object)this.message);
            DataWatcher.setValue(this.dataWatcher, 11, DataWatcher.V1_9.ValueType.ENTITY_NAME_VISIBLE, (Object)1);
            DataWatcher.setValue(this.dataWatcher, 3, DataWatcher.V1_9.ValueType.ENTITY_NAME_VISIBLE, (Object)1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void sendMetadata() {
        this.updateDataWatcher();
        try {
            Object metaPacket = ClassBuilder.buildNameMetadataPacket(this.ID, this.dataWatcher, 2, 3, this.message);
            BossBarAPI.sendPacket(this.receiver, metaPacket);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void spawn() {
        try {
            this.updateMovement();
            this.updateDataWatcher();
            Object packet = ClassBuilder.buildWitherSpawnPacket(this.ID, this.uuid, this.getLocation(), this.dataWatcher);
            BossBarAPI.sendPacket(this.receiver, packet);
            this.visible = true;
            this.sendMetadata();
            this.updateMovement();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void destroy() {
        try {
            this.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            Object packet = NMSClass.PacketPlayOutEntityDestroy.getConstructor(int[].class).newInstance(new Object[]{new int[]{this.ID}});
            BossBarAPI.sendPacket(this.receiver, packet);
            this.visible = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

