/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.socket;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.commands.PlayCommands;
import me.cubixor.sheepquest.spigot.commands.StaffCommands;
import me.cubixor.sheepquest.spigot.config.StatsUtils;
import me.cubixor.sheepquest.spigot.game.Signs;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.socket.JoinRunnable;
import me.cubixor.sheepquest.spigot.socket.SocketClient;
import me.cubixor.sheepquest.utils.packets.Packet;
import me.cubixor.sheepquest.utils.packets.classes.ArenaPacket;
import me.cubixor.sheepquest.utils.packets.classes.ArenaPlayerPacket;
import me.cubixor.sheepquest.utils.packets.classes.ArenasPacket;
import me.cubixor.sheepquest.utils.packets.classes.JoinPacket;
import me.cubixor.sheepquest.utils.packets.classes.KickPacket;
import me.cubixor.sheepquest.utils.packets.classes.ServerArenasPacket;
import me.cubixor.sheepquest.utils.packets.classes.StringPacket;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SocketClientReceiver {
    private final SheepQuest plugin = SheepQuest.getInstance();

    public void clientMessageReader(ObjectInputStream in) {
        while (true) {
            Object object;
            try {
                object = in.readObject();
            }
            catch (IOException e) {
                if (!this.plugin.getBungeeSocket().getSocket().isClosed()) {
                    new SocketClient().clientSetup(this.plugin.getConnectionConfig().getString("host"), this.plugin.getConnectionConfig().getInt("port"), this.plugin.getConnectionConfig().getString("server-name"));
                    this.plugin.getLogger().warning(ChatColor.YELLOW + "Lost connection with bungeecord server. Trying to reconnect...");
                }
                return;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                return;
            }
            final Packet packet = (Packet)object;
            new BukkitRunnable(){

                public void run() {
                    block0 : switch (packet.getPacketType()) {
                        case ARENA_UPDATE: {
                            ArenaPacket arenaPacket = (ArenaPacket)object;
                            Arena arena = arenaPacket.getArena();
                            Arena oldArena = SocketClientReceiver.this.plugin.getArenas().get(arena.getName());
                            if (oldArena == null) {
                                SocketClientReceiver.this.plugin.getSigns().put(arena.getName(), new ArrayList());
                            } else if (oldArena.getState().equals(GameState.ENDING) && !arena.getState().equals(GameState.ENDING)) {
                                StatsUtils.updateRankingOrdered();
                            }
                            SocketClientReceiver.this.plugin.getArenas().put(arena.getName(), arena);
                            new Signs().updateSigns(arena.getName());
                            break;
                        }
                        case ARENA_REMOVE: {
                            ArenaPacket arenaPacket = (ArenaPacket)object;
                            SocketClientReceiver.this.plugin.getArenas().remove(arenaPacket.getArena().getName());
                            new Signs().removeSigns(arenaPacket.getArena().getName());
                            break;
                        }
                        case SERVER_ARENAS_ADD: {
                            ServerArenasPacket serverArenasPacket = (ServerArenasPacket)object;
                            SocketClientReceiver.this.addArenas(serverArenasPacket.getArenas());
                            break;
                        }
                        case SERVER_ARENAS_REMOVE: {
                            StringPacket stringPacket = (StringPacket)object;
                            for (String arena : SocketClientReceiver.this.plugin.getArenas().keySet()) {
                                if (!SocketClientReceiver.this.plugin.getArenas().get(arena).getServer().equals(stringPacket.getString())) continue;
                                SocketClientReceiver.this.plugin.getArenas().remove(arena);
                                new Signs().updateSigns(arena);
                                break block0;
                            }
                            break;
                        }
                        case ARENA_JOIN: {
                            JoinPacket joinPacket = (JoinPacket)object;
                            new JoinRunnable().runTask(joinPacket.getPlayer(), joinPacket.getArena());
                            break;
                        }
                        case ARENA_LEAVE: {
                            ArenaPlayerPacket arenaPlayerPacket = (ArenaPlayerPacket)object;
                            new PlayCommands().kickFromLocalArena(Bukkit.getPlayerExact((String)arenaPlayerPacket.getPlayer()), SocketClientReceiver.this.plugin.getLocalArenas().get(arenaPlayerPacket.getArena().getName()), false, false);
                            break;
                        }
                        case ARENAS_ADD: {
                            ArenasPacket arenasPacket = (ArenasPacket)object;
                            SocketClientReceiver.this.addArenas(arenasPacket.getArenas());
                            break;
                        }
                        case FORCE_START: {
                            ArenaPlayerPacket arenaPlayerPacket = (ArenaPlayerPacket)object;
                            new StaffCommands().forceLocalArenaStart(arenaPlayerPacket.getPlayer(), arenaPlayerPacket.getArena().getName());
                            break;
                        }
                        case FORCE_STOP: {
                            ArenaPlayerPacket arenaPlayerPacket = (ArenaPlayerPacket)object;
                            new StaffCommands().forceLocalArenaStop(arenaPlayerPacket.getPlayer(), arenaPlayerPacket.getArena().getName());
                            break;
                        }
                        case KICK: {
                            KickPacket kickPacket = (KickPacket)object;
                            new StaffCommands().kickFromLocalArena(kickPacket.getPlayer(), kickPacket.getTarget(), kickPacket.getArena().getName());
                            break;
                        }
                    }
                }
            }.runTask((Plugin)this.plugin);
        }
    }

    private void addArenas(List<Arena> arenas) {
        for (Arena arena : arenas) {
            this.plugin.getArenas().put(arena.getName(), arena);
            new Signs().updateSigns(arena.getName());
        }
    }
}

