/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.socket;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.ArrayList;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.socket.SocketClientReceiver;
import me.cubixor.sheepquest.spigot.socket.SocketClientSender;
import me.cubixor.sheepquest.utils.SocketConnection;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SocketClient {
    private final SheepQuest plugin = SheepQuest.getInstance();

    public void clientSetup(final String host, final int port, final String server) {
        final boolean msgSent = this.plugin.getBungeeSocket() != null;
        this.plugin.setBungeeSocket(null);
        new BukkitRunnable(){

            public void run() {
                boolean done = false;
                boolean msg = msgSent;
                while (!done && SocketClient.this.plugin.isEnabled()) {
                    done = SocketClient.this.clientConnect(host, port, server);
                    if (msg || done) continue;
                    msg = true;
                    SocketClient.this.plugin.getLogger().warning(ChatColor.YELLOW + "Couldn't connect to the bungeecord server. Plugin will try to connect until it succeeds.");
                }
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }

    private boolean clientConnect(String host, int port, String server) {
        try {
            Socket sock = new Socket(host, port);
            ObjectInputStream objectInputStream = new ObjectInputStream(sock.getInputStream());
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(sock.getOutputStream());
            objectOutputStream.writeUTF(server);
            objectOutputStream.flush();
            SocketConnection socketConnectionSpigot = new SocketConnection(sock, objectInputStream, objectOutputStream);
            this.plugin.setBungeeSocket(socketConnectionSpigot);
            ArrayList<Arena> arenas = new ArrayList<Arena>();
            for (String arenaStr : this.plugin.getLocalArenas().keySet()) {
                LocalArena localArena = this.plugin.getLocalArenas().get(arenaStr);
                Arena arena = new Arena(localArena.getName(), localArena.getServer(), localArena.getState(), localArena.getPlayers());
                arenas.add(arena);
            }
            new SocketClientSender().sendArenasPacket(this.plugin.getServerName(), arenas);
            this.clientReceive();
            this.plugin.getLogger().info(ChatColor.GREEN + "Successfully connected to a bungeecord server!");
            return true;
        }
        catch (IOException ignored) {
            return false;
        }
    }

    private void clientReceive() {
        new BukkitRunnable(){

            public void run() {
                new SocketClientReceiver().clientMessageReader(SocketClient.this.plugin.getBungeeSocket().getInputStream());
            }
        }.runTaskAsynchronously((Plugin)this.plugin);
    }
}

