/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.gameInfo;

import me.cubixor.sheepquest.spigot.config.ConfigField;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;

public class TeamRegion {
    World world;
    double bxMin;
    double byMin;
    double bzMin;
    double bxMax;
    double byMax;
    double bzMax;
    Location loc;

    public TeamRegion(String arena, Team team) {
        if (team.equals((Object)Team.NONE)) {
            this.loc = ConfigUtils.getLocation(arena, ConfigField.SHEEP_SPAWN);
            return;
        }
        Location[] area = ConfigUtils.getArea(arena, team);
        Location min = area[0];
        Location max = area[1];
        this.world = min.getWorld();
        double b1x = min.getX();
        double b2x = max.getX();
        double b1y = min.getY();
        double b2y = max.getY();
        double b1z = min.getZ();
        double b2z = max.getZ();
        if (b1x < b2x) {
            this.bxMin = b1x - 1.0;
            this.bxMax = b2x + 1.0;
        } else {
            this.bxMin = b2x - 1.0;
            this.bxMax = b1x + 1.0;
        }
        if (b1y < b2y) {
            this.byMin = b1y - 1.0;
            this.byMax = b2y + 1.0;
        } else {
            this.byMin = b2y - 1.0;
            this.byMax = b1y + 1.0;
        }
        if (b1z < b2z) {
            this.bzMin = b1z - 1.0;
            this.bzMax = b2z + 1.0;
        } else {
            this.bzMin = b2z - 1.0;
            this.bzMax = b1z + 1.0;
        }
    }

    public boolean isInRegion(Entity entity) {
        Location loc = entity.getLocation();
        double x = loc.getX();
        double y = loc.getY();
        double z = loc.getZ();
        if (!entity.getWorld().equals(this.world)) {
            return false;
        }
        if (!(x >= this.bxMin && x <= this.bxMax && entity.getWorld().equals(this.world))) {
            return false;
        }
        if (!(y >= this.byMin && y <= this.byMax && entity.getWorld().equals(this.world))) {
            return false;
        }
        return z >= this.bzMin && z <= this.bzMax && entity.getWorld().equals(this.world);
    }

    public Location getLoc() {
        return this.loc;
    }
}

