/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game.kits;

import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.Particles;
import me.cubixor.sheepquest.spigot.api.Sounds;
import me.cubixor.sheepquest.spigot.game.events.BonusEntity;
import me.cubixor.sheepquest.spigot.game.kits.Kit;
import me.cubixor.sheepquest.spigot.game.kits.KitType;
import me.cubixor.sheepquest.spigot.game.kits.Kits;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class KitStandard
extends Kit
implements Listener {
    public KitStandard() {
        super(KitType.STANDARD);
    }

    public static void addCooldown(Player player) {
        SheepQuest plugin = SheepQuest.getInstance();
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            if (Utils.getLocalArena(player) != null) {
                player.setAllowFlight(true);
            }
        }, Math.round(plugin.getConfig().getDouble("kits.standard.dash-cooldown") * 20.0));
    }

    @Override
    public void giveKit(Player player) {
        this.giveItems(player);
        if (this.plugin.getConfig().getBoolean("kits.standard.dash")) {
            player.setAllowFlight(true);
        }
    }

    @EventHandler
    public void onDoubleJump(PlayerToggleFlightEvent evt) {
        Player player = evt.getPlayer();
        LocalArena localArena = Utils.getLocalArena(player);
        if (localArena != null && this.plugin.getConfig().getBoolean("kits.standard.dash") && Kits.getPlayerKit(player).getKitType().equals((Object)KitType.STANDARD) && !localArena.getRespawnTimer().containsKey(player) && localArena.getState().equals(GameState.GAME)) {
            evt.setCancelled(true);
            player.setFlying(false);
            player.setAllowFlight(false);
            if (player.getPassenger() == null || !BonusEntity.isCarrying((LivingEntity)player.getPassenger())) {
                this.useDash(player, localArena);
            }
        }
    }

    private void useDash(Player player, LocalArena localArena) {
        Sounds.playSound(localArena, player.getLocation(), "dash");
        Particles.spawnParticle(localArena, player.getLocation().add(0.0, 1.5, 0.0), "dash");
        KitStandard.addCooldown(player);
        player.setVelocity(player.getLocation().getDirection().add(new Vector(0.0, this.plugin.getConfig().getDouble("kits.standard.dash-power-y"), 0.0)).multiply(this.plugin.getConfig().getDouble("kits.standard.dash-power")));
    }
}

