/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game.kits;

import java.util.ArrayList;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.game.kits.Kit;
import me.cubixor.sheepquest.spigot.game.kits.KitType;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ProjectileHitEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class KitArcher
extends Kit
implements Listener {
    private ItemStack arrow;

    public KitArcher() {
        super(KitType.ARCHER);
    }

    public void loadArrows() {
        this.arrow = Utils.setItemStack("kits.archer.arrow-type", "kits.arrow-name", "kits.arrow-lore");
    }

    @Override
    public void giveKit(Player player) {
        if (this.arrow == null) {
            this.loadArrows();
        }
        this.giveItems(player);
    }

    public void addArrow(Player player) {
        ItemStack itemStack = new ItemStack(this.arrow);
        int amount = 1;
        if (player.getInventory().getItem(7) != null) {
            amount = player.getInventory().getItem(7).getAmount() + 1;
        }
        itemStack.setAmount(amount);
        player.getInventory().setItem(7, itemStack);
    }

    public void arrowTimer(final String arena) {
        LocalArena localArena = this.plugin.getLocalArenas().get(arena);
        final ArrayList<Player> archers = new ArrayList<Player>();
        for (Player player : localArena.getPlayerKit().keySet()) {
            if (!localArena.getPlayerKit().get(player).equals((Object)KitType.ARCHER)) continue;
            archers.add(player);
        }
        if (archers.isEmpty()) {
            return;
        }
        new BukkitRunnable(){

            public void run() {
                LocalArena localArena = KitArcher.this.plugin.getLocalArenas().get(arena);
                if (!localArena.getState().equals(GameState.GAME)) {
                    this.cancel();
                    return;
                }
                for (Player player : archers) {
                    if (localArena.getRespawnTimer().get(player) != null && localArena.getRespawnTimer().get(player) != 0) continue;
                    KitArcher.this.addArrow(player);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, Math.round(this.plugin.getConfig().getDouble("kits.archer.arrow-interval") * 20.0));
    }

    @EventHandler
    public void onArrowHit(ProjectileHitEvent evt) {
        if (!(evt.getEntity().getShooter() instanceof Player) || Utils.getLocalArena((Player)evt.getEntity().getShooter()) == null) {
            return;
        }
        evt.getEntity().remove();
    }
}

