/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game.kits;

import com.cryptomorin.xseries.XMaterial;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.VersionUtils;
import me.cubixor.sheepquest.spigot.game.kits.KitType;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.inventory.ItemStack;

public abstract class Kit
implements Listener {
    protected final SheepQuest plugin = SheepQuest.getInstance();
    private final KitType kitType;
    private ItemStack primaryWeapon;
    private ItemStack secondaryWeapon;
    private ItemStack shield;

    public Kit(KitType kitType) {
        this.kitType = kitType;
    }

    public void loadItems() {
        this.primaryWeapon = Utils.setItemStack("kits." + this.kitType.getCode() + ".primary-weapon", "kits." + this.kitType.getCode() + "-primary-weapon-name", "kits." + this.kitType.getCode() + "-primary-weapon-lore");
        if (this.plugin.getConfig().getString("kits." + this.kitType.getCode() + ".secondary-weapon") != null) {
            this.secondaryWeapon = Utils.setItemStack("kits." + this.kitType.getCode() + ".secondary-weapon", "kits." + this.kitType.getCode() + "-secondary-weapon-name", "kits." + this.kitType.getCode() + "-secondary-weapon-lore");
        }
        if (this.plugin.getConfig().getBoolean("kits." + this.kitType.getCode() + ".shield") && !VersionUtils.is1_8()) {
            this.shield = Utils.setItemStack(XMaterial.SHIELD.parseMaterial(), "kits.shield-name", "kits.shield-lore");
        }
    }

    public abstract void giveKit(Player var1);

    protected void giveItems(Player player) {
        player.getInventory().setItem(0, this.getPrimaryWeapon());
        int sheepItemSlot = 1;
        if (this.getSecondaryWeapon() != null) {
            player.getInventory().setItem(1, this.getSecondaryWeapon());
            sheepItemSlot = 2;
        }
        player.getInventory().setItem(sheepItemSlot, this.plugin.getItems().getSheepItem());
        if (this.getShield() != null) {
            player.getInventory().setItemInOffHand(this.getShield());
        }
    }

    public KitType getKitType() {
        return this.kitType;
    }

    public ItemStack getPrimaryWeapon() {
        return this.primaryWeapon;
    }

    public ItemStack getSecondaryWeapon() {
        return this.secondaryWeapon;
    }

    public ItemStack getShield() {
        return this.shield;
    }
}

