/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game.events;

import java.util.LinkedList;
import java.util.Random;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.game.events.SpecialEvent;
import me.cubixor.sheepquest.spigot.game.events.SpecialEventsData;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SpecialEvents {
    private final SheepQuest plugin = SheepQuest.getInstance();

    public void setupSpecialEvents(String arenaString) {
        if (this.plugin.getConfig().getBoolean("special-events.enabled")) {
            boolean cancel = true;
            for (SpecialEvent evt : SpecialEvent.values()) {
                if (!evt.isEnabled()) continue;
                cancel = false;
                break;
            }
            if (cancel) {
                return;
            }
            LocalArena localArena = this.plugin.getLocalArenas().get(arenaString);
            localArena.setSpecialEventsData(new SpecialEventsData());
            localArena.getSpecialEventsData().setSpecialEventsTimer(this.setRate());
            this.runEventTimer(arenaString);
        }
    }

    public void reset(LocalArena localArena) {
        for (SpecialEvent event : SpecialEvent.values()) {
            if (!event.isEnabled()) continue;
            event.runReset(localArena);
        }
    }

    private int setRate() {
        String[] rateString = this.plugin.getConfig().getString("special-events.rate").split("-");
        int rate1 = Integer.parseInt(rateString[0]);
        int rate2 = Integer.parseInt(rateString[1]);
        Random random = new Random();
        return random.nextInt(rate2 - rate1 + 1) + rate1;
    }

    private void runEventTimer(final String arenaString) {
        new BukkitRunnable(){

            public void run() {
                LocalArena localArena = SpecialEvents.this.plugin.getLocalArenas().get(arenaString);
                if (localArena == null || !localArena.getState().equals(GameState.GAME)) {
                    this.cancel();
                    return;
                }
                if (localArena.getSpecialEventsData().getSpecialEventsTimer() == 0) {
                    Random random = new Random();
                    LinkedList<SpecialEvent> specialEvents = new LinkedList<SpecialEvent>();
                    for (SpecialEvent evt : SpecialEvent.values()) {
                        if (!evt.isEnabled()) continue;
                        specialEvents.add(evt);
                    }
                    int evtId = random.nextInt(specialEvents.size());
                    SpecialEvent event = (SpecialEvent)((Object)specialEvents.get(evtId));
                    event.runEvent(localArena);
                    localArena.getSpecialEventsData().setSpecialEventsTimer(SpecialEvents.this.setRate());
                } else {
                    localArena.getSpecialEventsData().setSpecialEventsTimer(localArena.getSpecialEventsData().getSpecialEventsTimer() - 1);
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }
}

