/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game;

import com.cryptomorin.xseries.XMaterial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.Sounds;
import me.cubixor.sheepquest.spigot.api.VersionUtils;
import me.cubixor.sheepquest.spigot.commands.PlayCommands;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.game.Scoreboards;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class Teams
implements Listener {
    private final SheepQuest plugin = SheepQuest.getInstance();

    @EventHandler
    public void onClick(PlayerInteractEvent evt) {
        LocalArena localArena = Utils.getLocalArena(evt.getPlayer());
        if (localArena != null && evt.getItem() != null) {
            if (!(VersionUtils.is1_8() || evt.getHand() != null && evt.getHand().equals((Object)EquipmentSlot.HAND))) {
                return;
            }
            if (evt.getItem().equals((Object)this.plugin.getItems().getTeamItem())) {
                if (localArena.getTeamChooseInv().getItem(0) == null || localArena.getTeamChooseInv().getItem(0).getType().equals((Object)Material.AIR)) {
                    this.menuUpdate(localArena);
                }
                evt.getPlayer().openInventory(localArena.getTeamChooseInv());
                evt.setCancelled(true);
            } else if (evt.getItem().equals((Object)this.plugin.getItems().getLeaveItem())) {
                PlayCommands playCommands = new PlayCommands();
                playCommands.sendKickMessage(evt.getPlayer(), localArena);
                playCommands.kickFromLocalArena(evt.getPlayer(), localArena, false, false);
                evt.setCancelled(true);
            } else if (evt.getItem().equals((Object)this.plugin.getItems().getKitsItem())) {
                evt.getPlayer().openInventory(this.plugin.getItems().getKitsInventory());
                evt.setCancelled(true);
            }
        }
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent evt) {
        LocalArena localArena = Utils.getLocalArena((Player)evt.getWhoClicked());
        if (localArena != null && evt.getClickedInventory() != null && evt.getClickedInventory().equals(localArena.getTeamChooseInv()) && evt.getCurrentItem() != null && !evt.getCurrentItem().getType().equals((Object)Material.AIR)) {
            evt.setCancelled(true);
            Player player = (Player)evt.getWhoClicked();
            Team team = Utils.getTeamByWool(evt.getCurrentItem());
            String arenaString = localArena.getName();
            if (team.equals((Object)Team.NONE)) {
                Utils.removeFromScoreboard(localArena, localArena.getPlayerTeam().get(player).getCode(), player.getName());
                localArena.getPlayerTeam().replace(player, Team.NONE);
                player.sendMessage(this.plugin.getMessage("game.team-join-random"));
                Utils.removeTeamBossBars(player, localArena);
                localArena.getTeamBossBars().get((Object)Team.NONE).addPlayer(player);
                player.getInventory().setHelmet(new ItemStack(Material.AIR));
            } else {
                HashMap<Team, Integer> teamPlayers = new HashMap<Team, Integer>(Utils.getTeamPlayers(localArena));
                String teamMessage = team.getName();
                if ((float)teamPlayers.get((Object)team).intValue() < (float)localArena.getPlayers().size() / (float)ConfigUtils.getTeamList(arenaString).size()) {
                    if (!localArena.getPlayerTeam().get(player).equals((Object)team)) {
                        Utils.removeFromScoreboard(localArena, localArena.getPlayerTeam().get(player).getCode(), player.getName());
                        localArena.getPlayerTeam().replace(player, team);
                        Utils.removeTeamBossBars(player, localArena);
                        localArena.getTeamBossBars().get((Object)team).addPlayer(player);
                        player.getInventory().setHelmet(team.getBanner());
                        Utils.addToScoreboard(localArena, team.getCode(), player.getName());
                        if (localArena.getState().equals(GameState.WAITING)) {
                            player.setScoreboard(new Scoreboards().getWaitingScoreboard(localArena, player));
                        }
                        player.sendMessage(this.plugin.getMessage("game.team-join-success").replace("%team%", teamMessage));
                    } else {
                        player.sendMessage(this.plugin.getMessage("game.already-in-this-team").replace("%team%", teamMessage));
                    }
                } else {
                    player.sendMessage(this.plugin.getMessage("game.team-full").replace("%team%", teamMessage));
                }
            }
            this.menuUpdate(localArena);
            Sounds.playSound(player, player.getLocation(), "click");
            player.getOpenInventory().close();
        }
    }

    public void menuUpdate(LocalArena localArena) {
        HashMap<Object, List<Object>> lore = new HashMap<Object, List<Object>>();
        ArrayList<String> lorePlayers = new ArrayList<String>(this.plugin.getMessageList("game.team-menu-players"));
        ArrayList<Team> arenaTeams = new ArrayList<Team>(ConfigUtils.getTeamList(localArena.getName()));
        HashMap<Object, Integer> players = new HashMap<Object, Integer>();
        for (Team team : arenaTeams) {
            lore.put((Object)team, (List<Object>)lorePlayers);
            players.put((Object)team, 0);
        }
        for (Player p : localArena.getPlayerTeam().keySet()) {
            Object team = localArena.getPlayerTeam().get(p);
            if (team.equals((Object)Team.NONE)) continue;
            ArrayList<String> newLore = new ArrayList<String>((Collection)lore.get(team));
            newLore.add(this.plugin.getMessage("game.team-menu-players-format").replace("%player%", p.getName()));
            lore.replace(team, (List<Object>)newLore);
            players.replace(team, (Integer)players.get(team) + 1);
        }
        for (Team team : arenaTeams) {
            if ((Integer)players.get((Object)team) != 0) continue;
            lore.replace((Object)team, (List<Object>)this.plugin.getMessageList("game.team-menu-no-players"));
        }
        HashMap<Team, ItemStack> teamItems = new HashMap<Team, ItemStack>(this.plugin.getItems().getTeamItems());
        HashMap<Team, ItemStack> arenaTeamItems = new HashMap<Team, ItemStack>();
        for (Team team : teamItems.keySet()) {
            if (!arenaTeams.contains((Object)team)) continue;
            arenaTeamItems.put(team, teamItems.get((Object)team));
        }
        for (Team team : arenaTeamItems.keySet()) {
            ItemStack itemStack = (ItemStack)arenaTeamItems.get((Object)team);
            ItemMeta itemMeta = itemStack.getItemMeta();
            itemMeta.setLore((List)lore.get((Object)team));
            itemStack.setItemMeta(itemMeta);
            if ((Integer)players.get((Object)team) <= 1) {
                itemStack.setAmount(1);
            } else {
                itemStack.setAmount(((Integer)players.get((Object)team)).intValue());
            }
            arenaTeamItems.replace(team, itemStack);
        }
        int slot = 0;
        for (Team team : arenaTeams) {
            localArena.getTeamChooseInv().setItem(slot, (ItemStack)arenaTeamItems.get((Object)team));
            ++slot;
        }
        localArena.getTeamChooseInv().setItem(localArena.getTeamChooseInv().getSize() == 9 ? 8 : 17, Utils.setItemStack(XMaterial.QUARTZ.parseMaterial(), "game.team-menu-team-random", "game.team-menu-team-random-lore"));
    }
}

