/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.LinkedList;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.api.VersionUtils;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.scoreboard.DisplaySlot;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.scoreboard.Scoreboard;

public class Scoreboards {
    private static final String[] lineNames = new String[]{ChatColor.BLACK.toString(), ChatColor.BLACK.toString() + ChatColor.WHITE, ChatColor.DARK_BLUE.toString(), ChatColor.DARK_BLUE.toString() + ChatColor.WHITE, ChatColor.DARK_GREEN.toString(), ChatColor.DARK_GREEN.toString() + ChatColor.WHITE, ChatColor.DARK_AQUA.toString(), ChatColor.DARK_AQUA.toString() + ChatColor.WHITE, ChatColor.DARK_RED.toString(), ChatColor.DARK_RED.toString() + ChatColor.WHITE, ChatColor.DARK_PURPLE.toString(), ChatColor.DARK_PURPLE.toString() + ChatColor.WHITE, ChatColor.GOLD.toString(), ChatColor.GOLD.toString() + ChatColor.WHITE, ChatColor.GRAY.toString(), ChatColor.GRAY.toString() + ChatColor.WHITE, ChatColor.DARK_GRAY.toString(), ChatColor.DARK_GRAY.toString() + ChatColor.WHITE, ChatColor.BLUE.toString(), ChatColor.BLUE.toString() + ChatColor.WHITE, ChatColor.GREEN.toString(), ChatColor.GREEN.toString() + ChatColor.WHITE, ChatColor.AQUA.toString(), ChatColor.AQUA.toString() + ChatColor.WHITE, ChatColor.RED.toString(), ChatColor.RED.toString() + ChatColor.WHITE, ChatColor.LIGHT_PURPLE.toString(), ChatColor.LIGHT_PURPLE.toString() + ChatColor.WHITE, ChatColor.YELLOW.toString(), ChatColor.YELLOW.toString() + ChatColor.WHITE, ChatColor.WHITE.toString(), ChatColor.WHITE.toString() + ChatColor.BLACK};
    private final SheepQuest plugin = SheepQuest.getInstance();

    public Scoreboard getWaitingScoreboard(LocalArena localArena, Player player) {
        Scoreboard scoreboard = localArena.getPlayerScoreboards().get(player);
        String arenaString = localArena.getName();
        int count = localArena.getPlayerTeam().keySet().size();
        LinkedList<String> message = new LinkedList<String>(this.plugin.getMessageList("game.scoreboard-new-waiting"));
        String countString = Integer.toString(count);
        String teamName = localArena.getPlayerTeam().get(player).getName();
        String kitName = localArena.getPlayerKit().get(player).getName();
        String date = this.getDate();
        String[] msg = new String[message.size()];
        for (int i = 0; i < message.size(); ++i) {
            msg[i] = message.get(i).replace("%arena%", arenaString).replace("%players%", countString).replace("%team%", teamName).replace("%kit%", kitName).replace("%date%", date);
        }
        this.setMsg(scoreboard, msg);
        return scoreboard;
    }

    public Scoreboard getStartingScoreboard(LocalArena localArena, Player player) {
        Scoreboard scoreboard = localArena.getPlayerScoreboards().get(player);
        String arenaString = localArena.getName();
        int count = localArena.getPlayerTeam().keySet().size();
        int time = localArena.getTimer();
        LinkedList<String> message = new LinkedList<String>(this.plugin.getMessageList("game.scoreboard-new-starting"));
        String countString = Integer.toString(count);
        String teamName = localArena.getPlayerTeam().get(player).getName();
        String kitName = localArena.getPlayerKit().get(player).getName();
        String timeLongTime = this.getTimeLong(time);
        String timeShortTime = Integer.toString(time);
        String date = this.getDate();
        String[] msg = new String[message.size()];
        for (int i = 0; i < message.size(); ++i) {
            msg[i] = message.get(i).replace("%arena%", arenaString).replace("%players%", countString).replace("%team%", teamName).replace("%kit%", kitName).replace("%time-long%", timeLongTime).replace("%time-short%", timeShortTime).replace("%date%", date);
        }
        this.setMsg(scoreboard, msg);
        return scoreboard;
    }

    public Scoreboard getGameScoreboard(LocalArena localArena, Player player) {
        Scoreboard scoreboard = localArena.getPlayerScoreboards().get(player);
        String arenaString = localArena.getName();
        int count = localArena.getPlayerTeam().keySet().size();
        int sheepTime = localArena.getSheepTimer();
        int time = localArena.getTimer();
        ArrayList<String> teamPoints = new ArrayList<String>();
        for (Team team : ConfigUtils.getTeamList(arenaString)) {
            teamPoints.add(this.plugin.getMessage("game.scoreboard-team").replace("%team%", team.getName()).replace("%points%", Integer.toString(localArena.getPoints().get((Object)team))));
        }
        ArrayList<String> message = new ArrayList<String>(this.plugin.getMessageList("game.scoreboard-new-game"));
        for (int i = 0; i < message.size(); ++i) {
            String line = (String)message.get(i);
            if (!line.contains("%teams%")) continue;
            message.remove(line);
            message.addAll(i, teamPoints);
            break;
        }
        String countString = Integer.toString(count);
        String teamName = localArena.getPlayerTeam().get(player).getName();
        String kitName = localArena.getPlayerKit().get(player).getName();
        String timeLongSheep = this.getTimeLong(sheepTime);
        String timeShortSheep = Integer.toString(sheepTime);
        String timeLongTime = this.getTimeLong(time);
        String timeShortTime = Integer.toString(time);
        String date = this.getDate();
        String[] msg = new String[message.size()];
        for (int i = 0; i < message.size(); ++i) {
            msg[i] = ((String)message.get(i)).replace("%arena%", arenaString).replace("%players%", countString).replace("%team%", teamName).replace("%kit%", kitName).replace("%sheep-long%", timeLongSheep).replace("%sheep-short%", timeShortSheep).replace("%time-long%", timeLongTime).replace("%time-short%", timeShortTime).replace("%date%", date);
        }
        this.setMsg(scoreboard, msg);
        return scoreboard;
    }

    public Scoreboard getEndingScoreboard(LocalArena localArena, Player player) {
        Scoreboard scoreboard = localArena.getPlayerScoreboards().get(player);
        String arenaString = localArena.getName();
        int count = localArena.getPlayerTeam().keySet().size();
        int time = localArena.getTimer();
        ArrayList<String> teamPoints = new ArrayList<String>();
        for (Team team : ConfigUtils.getTeamList(arenaString)) {
            teamPoints.add(this.plugin.getMessage("game.scoreboard-team").replace("%team%", team.getName()).replace("%points%", Integer.toString(localArena.getPoints().get((Object)team))));
        }
        ArrayList<String> message = new ArrayList<String>(this.plugin.getMessageList("game.scoreboard-new-ending"));
        for (int i = 0; i < message.size(); ++i) {
            String line = (String)message.get(i);
            if (!line.contains("%teams%")) continue;
            message.remove(line);
            message.addAll(i, teamPoints);
            break;
        }
        String countString = Integer.toString(count);
        String teamName = localArena.getPlayerTeam().get(player).getName();
        String kitName = localArena.getPlayerKit().get(player).getName();
        String timeLongTime = this.getTimeLong(time);
        String timeShortTime = Integer.toString(time);
        String date = this.getDate();
        String[] msg = new String[message.size()];
        for (int i = 0; i < message.size(); ++i) {
            msg[i] = ((String)message.get(i)).replace("%arena%", arenaString).replace("%players%", countString).replace("%team%", teamName).replace("%kit%", kitName).replace("%time-long%", timeLongTime).replace("%time-short%", timeShortTime).replace("%date%", date);
        }
        this.setMsg(scoreboard, msg);
        return scoreboard;
    }

    private String getTimeLong(int time) {
        int timeParsed;
        String timeLeft = time > 60 ? ((timeParsed = time / 60) == 1 ? this.plugin.getMessage("game.scoreboard-minute").replace("%count%", Integer.toString(timeParsed)) : this.plugin.getMessage("game.scoreboard-minutes").replace("%count%", Integer.toString(timeParsed))) : (time == 1 ? this.plugin.getMessage("game.scoreboard-second").replace("%count%", Integer.toString(time)) : this.plugin.getMessage("game.scoreboard-seconds").replace("%count%", Integer.toString(time)));
        return timeLeft;
    }

    private String getDate() {
        LocalDateTime localDateTime = LocalDateTime.now();
        DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(this.plugin.getConfig().getString("date-format"));
        return localDateTime.format(dateTimeFormatter);
    }

    private void setMsg(Scoreboard scoreboard, String[] text) {
        for (int j = 0; j < text.length; ++j) {
            org.bukkit.scoreboard.Team team = scoreboard.getTeam(Integer.toString(j));
            int i = text.length - 1 - j;
            if (!VersionUtils.isBefore13() || text[i].length() <= 16) {
                team.setPrefix(text[i]);
                continue;
            }
            if (text[i].length() > 32) {
                text[i] = text[i].substring(0, 32);
            }
            String str1 = text[i].substring(0, 16);
            String str2 = text[i].substring(16);
            team.setPrefix(str1);
            team.setSuffix(ChatColor.RESET + ChatColor.getLastColors((String)str1) + str2);
        }
    }

    public void createScoreboard(LocalArena localArena, Player player) {
        Scoreboard scoreboard = Bukkit.getScoreboardManager().getNewScoreboard();
        Objective objective = scoreboard.registerNewObjective(player.getName(), "");
        objective.setDisplayName(this.plugin.getMessage("game.scoreboard-title"));
        objective.setDisplaySlot(DisplaySlot.SIDEBAR);
        for (Team team : ConfigUtils.getTeamList(localArena.getName())) {
            org.bukkit.scoreboard.Team scoreboardTeam = scoreboard.registerNewTeam(team.getCode());
            scoreboardTeam.setPrefix(team.getChatColor().toString());
            if (VersionUtils.isBefore12()) continue;
            scoreboardTeam.setColor(team.getChatColor());
        }
        localArena.getPlayerScoreboards().put(player, scoreboard);
        this.copyTeams(localArena, player);
        this.setSizeForPlayer(player, localArena);
    }

    private void copyTeams(LocalArena localArena, Player player) {
        if (localArena.getPlayers().size() < 2) {
            return;
        }
        Scoreboard otherScoreboard = null;
        Scoreboard scoreboard = localArena.getPlayerScoreboards().get(player);
        for (Player p : localArena.getPlayerScoreboards().keySet()) {
            if (p.equals(player)) continue;
            otherScoreboard = localArena.getPlayerScoreboards().get(p);
            break;
        }
        for (Team team : ConfigUtils.getTeamList(localArena.getName())) {
            for (String entry : otherScoreboard.getTeam(team.getCode()).getEntries()) {
                scoreboard.getTeam(team.getCode()).addEntry(entry);
            }
        }
    }

    public void changeScoreboardSize(LocalArena localArena) {
        for (Player p : localArena.getPlayerScoreboards().keySet()) {
            this.setSizeForPlayer(p, localArena);
        }
    }

    private void setSizeForPlayer(Player p, LocalArena localArena) {
        Scoreboard scoreboard = localArena.getPlayerScoreboards().get(p);
        Objective objective = scoreboard.getObjective(p.getName());
        int size = this.plugin.getMessageList("game.scoreboard-new-" + localArena.getState().getCode()).size();
        if (localArena.getState().equals(GameState.GAME) || localArena.getState().equals(GameState.ENDING)) {
            size = size + localArena.getTeamRegions().size() - 2;
        }
        int j = 0;
        for (org.bukkit.scoreboard.Team team : scoreboard.getTeams()) {
            try {
                Integer.parseInt(team.getName());
            }
            catch (NumberFormatException e) {
                continue;
            }
            scoreboard.resetScores(lineNames[j]);
            team.unregister();
            ++j;
        }
        for (int i = 0; i < size; ++i) {
            org.bukkit.scoreboard.Team team;
            team = scoreboard.registerNewTeam(Integer.toString(i));
            team.addEntry(lineNames[i]);
            Score score = objective.getScore(lineNames[i]);
            score.setScore(i);
        }
    }
}

