/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game;

import com.cryptomorin.xseries.ReflectionUtils;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.VersionUtils;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Pathfinding {
    public static Object getEntityInsentient(Entity entity) {
        try {
            Class<?> craftLivingEntityClass = ReflectionUtils.getCraftClass("entity.CraftLivingEntity");
            Object craftLivingEntity = craftLivingEntityClass.cast(entity);
            Object entityLiving = craftLivingEntityClass.getMethod("getHandle", new Class[0]).invoke(craftLivingEntity, new Object[0]);
            return ReflectionUtils.getNMSClass("world.entity", "EntityInsentient").cast(entityLiving);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void clearGoals(Object entityInsentient) {
        try {
            Class<?> pathfinderGoalSelectorClass = ReflectionUtils.getNMSClass("world.entity.ai.goal", "PathfinderGoalSelector");
            Class<?> entityInsentientClass = ReflectionUtils.getNMSClass("world.entity", "EntityInsentient");
            Field f3 = pathfinderGoalSelectorClass.getDeclaredField("d");
            f3.setAccessible(true);
            if (!VersionUtils.isBefore19()) {
                f3.set(entityInsentientClass.getField("bS").get(entityInsentient), Sets.newLinkedHashSet());
            } else if (!VersionUtils.isBefore18()) {
                f3.set(entityInsentientClass.getField("bR").get(entityInsentient), Sets.newLinkedHashSet());
            } else if (VersionUtils.isBefore17()) {
                Field f1 = pathfinderGoalSelectorClass.getDeclaredField("b");
                Field f2 = pathfinderGoalSelectorClass.getDeclaredField("c");
                f1.setAccessible(true);
                f2.setAccessible(true);
                if (VersionUtils.is1_8()) {
                    Class<?> unsafeListClass = ReflectionUtils.getCraftClass("util.UnsafeList");
                    Method m = unsafeListClass.getMethod("clear", new Class[0]);
                    m.invoke(f1.get(entityInsentientClass.getField("goalSelector").get(entityInsentient)), new Object[0]);
                    m.invoke(f2.get(entityInsentientClass.getField("goalSelector").get(entityInsentient)), new Object[0]);
                    m.invoke(f2.get(entityInsentientClass.getField("targetSelector").get(entityInsentient)), new Object[0]);
                    m.invoke(f1.get(entityInsentientClass.getField("targetSelector").get(entityInsentient)), new Object[0]);
                } else if (VersionUtils.is1416()) {
                    f3.set(entityInsentientClass.getField("goalSelector").get(entityInsentient), Sets.newLinkedHashSet());
                    f3.set(entityInsentientClass.getField("targetSelector").get(entityInsentient), Sets.newLinkedHashSet());
                } else {
                    f1.set(entityInsentientClass.getField("goalSelector").get(entityInsentient), Sets.newLinkedHashSet());
                    f2.set(entityInsentientClass.getField("targetSelector").get(entityInsentient), Sets.newLinkedHashSet());
                }
            } else {
                f3.set(entityInsentientClass.getField("bP").get(entityInsentient), Sets.newLinkedHashSet());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void changeFollowRange(Object entityInsentient) {
        try {
            Field f = VersionUtils.isBefore17() ? ReflectionUtils.getNMSClass("GenericAttributes").getField("FOLLOW_RANGE") : ReflectionUtils.getNMSClass("world.entity.ai.attributes", "GenericAttributes").getField("b");
            Class<?> c = VersionUtils.isBefore16() ? ReflectionUtils.getNMSClass("IAttribute") : ReflectionUtils.getNMSClass("world.entity.ai.attributes", "AttributeBase");
            Method m = VersionUtils.isBefore18() ? ReflectionUtils.getNMSClass("world.entity", "EntityInsentient").getMethod("getAttributeInstance", c) : ReflectionUtils.getNMSClass("world.entity", "EntityInsentient").getMethod("a", c);
            Object ai = m.invoke(entityInsentient, f.get(null));
            Method m2 = VersionUtils.isBefore18() ? ReflectionUtils.getNMSClass("world.entity.ai.attributes", "AttributeModifiable").getMethod("setValue", Double.TYPE) : ReflectionUtils.getNMSClass("world.entity.ai.attributes", "AttributeModifiable").getMethod("a", Double.TYPE);
            m2.invoke(ai, 1000);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addWalkToLocationGoal(Object entityInsentient, Location loc, double speed) {
        try {
            Object a = VersionUtils.isBefore18() ? ReflectionUtils.getNMSClass("world.entity", "EntityInsentient").getMethod("getNavigation", new Class[0]).invoke(entityInsentient, new Object[0]) : ReflectionUtils.getNMSClass("world.entity", "EntityInsentient").getMethod("D", new Class[0]).invoke(entityInsentient, new Object[0]);
            Method method = ReflectionUtils.getNMSClass("world.entity.ai.navigation", "NavigationAbstract").getMethod("a", Double.TYPE, Double.TYPE, Double.TYPE, Double.TYPE);
            method.invoke(a, loc.getX(), loc.getY(), loc.getZ(), speed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addOtherGoals(Object entityInsentient) {
        try {
            Pathfinding.clearGoals(entityInsentient);
            Class<?> entityInsentientClass = ReflectionUtils.getNMSClass("world.entity", "EntityInsentient");
            Class<?> entityCreatureClass = ReflectionUtils.getNMSClass("world.entity", "EntityCreature");
            Field f = !VersionUtils.isBefore19() ? entityInsentientClass.getField("bS") : (!VersionUtils.isBefore18() ? entityInsentientClass.getField("bR") : (!VersionUtils.isBefore17() ? entityInsentientClass.getField("bP") : entityInsentientClass.getField("goalSelector")));
            Object a = f.get(entityInsentient);
            Object goal1 = ReflectionUtils.getNMSClass("world.entity.ai.goal", "PathfinderGoalRandomLookaround").getConstructor(entityInsentientClass).newInstance(entityInsentient);
            Object goal2 = ReflectionUtils.getNMSClass("world.entity.ai.goal", "PathfinderGoalRandomStroll").getConstructor(entityCreatureClass, Double.TYPE).newInstance(entityInsentient, 1);
            Object goal3 = ReflectionUtils.getNMSClass("world.entity.ai.goal", "PathfinderGoalFloat").getConstructor(entityInsentientClass).newInstance(entityInsentient);
            Method method = ReflectionUtils.getNMSClass("world.entity.ai.goal", "PathfinderGoalSelector").getMethod("a", Integer.TYPE, ReflectionUtils.getNMSClass("world.entity.ai.goal", "PathfinderGoal"));
            method.invoke(a, 0, goal3);
            method.invoke(a, 1, goal2);
            method.invoke(a, 2, goal1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Location getMiddleArea(String arena, Team team) {
        Location[] loc = ConfigUtils.getArea(arena, team);
        double x = (loc[0].getX() + loc[1].getX()) / 2.0;
        double y = (loc[0].getY() + loc[1].getY()) / 2.0;
        double z = (loc[0].getZ() + loc[1].getZ()) / 2.0;
        return new Location(loc[0].getWorld(), x, y, z);
    }

    public static void walkToLocation(final LivingEntity entity, final Location location, final double speed, final LocalArena localArena, final Team team) {
        if (localArena.getSheep().containsKey(entity)) {
            localArena.getSheep().get(entity).cancel();
        }
        final Object e = Pathfinding.getEntityInsentient((Entity)entity);
        Pathfinding.clearGoals(e);
        Pathfinding.changeFollowRange(e);
        Pathfinding.addOtherGoals(e);
        localArena.getSheep().put((Entity)entity, new BukkitRunnable(){
            boolean wasInRegion = true;

            public void run() {
                if (!entity.isOnGround()) {
                    return;
                }
                boolean inRegion = Utils.isInRegion((Entity)entity, localArena, team);
                if (!inRegion && this.wasInRegion) {
                    Pathfinding.clearGoals(e);
                    Pathfinding.addWalkToLocationGoal(e, location, speed);
                    this.wasInRegion = false;
                } else if (inRegion && !this.wasInRegion) {
                    Pathfinding.addOtherGoals(e);
                    this.wasInRegion = true;
                }
            }
        }.runTaskTimer((Plugin)SheepQuest.getInstance(), 0L, 10L));
    }
}

