/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game;

import java.util.ArrayList;
import java.util.List;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.api.VersionUtils;
import me.cubixor.sheepquest.spigot.commands.PlayCommands;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;

public class JoinSheep
implements Listener {
    private final SheepQuest plugin = SheepQuest.getInstance();

    @EventHandler
    public void sheepClickEvent(PlayerInteractEntityEvent evt) {
        if (!VersionUtils.is1_8() && !evt.getHand().equals((Object)EquipmentSlot.HAND)) {
            return;
        }
        if (!evt.getRightClicked().getType().equals((Object)EntityType.SHEEP)) {
            return;
        }
        Sheep sheep = (Sheep)evt.getRightClicked();
        this.clickSheep(sheep, evt.getPlayer());
    }

    @EventHandler
    public void sheepDamageEvent(EntityDamageByEntityEvent evt) {
        if (!evt.getDamager().getType().equals((Object)EntityType.PLAYER) || !evt.getEntityType().equals((Object)EntityType.SHEEP)) {
            return;
        }
        Sheep sheep = (Sheep)evt.getEntity();
        if (this.clickSheep(sheep, (Player)evt.getDamager())) {
            evt.setCancelled(true);
        }
    }

    private boolean clickSheep(Sheep sheep, Player player) {
        List configSheep = this.plugin.getArenasConfig().getStringList("join-sheep");
        ArrayList<Block> sheepLocation = new ArrayList<Block>();
        for (String loc : configSheep) {
            sheepLocation.add(ConfigUtils.stringToLocation(loc).getBlock());
        }
        if (!sheepLocation.contains(sheep.getLocation().getBlock())) {
            return false;
        }
        new PlayCommands().quickJoin(player);
        return true;
    }

    public void spawnSheep(Player player) {
        if (VersionUtils.is1_8()) {
            player.sendMessage(this.plugin.getMessage("general.version-not-supported"));
            return;
        }
        Location location = player.getLocation();
        Sheep sheep = (Sheep)location.getWorld().spawnEntity(location, EntityType.SHEEP);
        sheep.setAI(false);
        sheep.setInvulnerable(true);
        sheep.setCollidable(false);
        sheep.setColor(DyeColor.valueOf((String)this.plugin.getConfig().getString("join-sheep-color")));
        sheep.setSilent(true);
        sheep.setRemoveWhenFarAway(false);
        sheep.setCustomName(this.plugin.getMessage("other.join-sheep-name"));
        sheep.setCustomNameVisible(true);
        List configSheep = this.plugin.getArenasConfig().getStringList("join-sheep");
        configSheep.add(ConfigUtils.locationToString(location));
        this.plugin.getArenasConfig().set("join-sheep", (Object)configSheep);
        this.plugin.saveArenas();
        player.sendMessage(this.plugin.getMessage("arena-setup.spawn-join-sheep"));
    }
}

