/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game;

import com.cryptomorin.xseries.messages.ActionBar;
import java.util.ArrayList;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.api.Particles;
import me.cubixor.sheepquest.spigot.api.Sounds;
import me.cubixor.sheepquest.spigot.config.ConfigField;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.game.End;
import me.cubixor.sheepquest.spigot.game.Pathfinding;
import me.cubixor.sheepquest.spigot.game.Scoreboards;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class GameTimer {
    private final SheepQuest plugin = SheepQuest.getInstance();

    GameTimer() {
    }

    public void gameTime(final String arenaString) {
        final ArrayList<Integer> timePoints = new ArrayList<Integer>(){
            {
                this.add(30);
                this.add(10);
                this.add(5);
                this.add(4);
                this.add(3);
                this.add(2);
                this.add(1);
            }
        };
        new BukkitRunnable(){

            public void run() {
                LocalArena localArena = GameTimer.this.plugin.getLocalArenas().get(arenaString);
                if (localArena == null) {
                    this.cancel();
                    return;
                }
                if (!localArena.getState().equals(GameState.GAME)) {
                    this.cancel();
                    return;
                }
                if (localArena.getTimer() > 0) {
                    if (localArena.getSheepTimer() == 0) {
                        localArena.setSheepTimer(GameTimer.this.plugin.getConfig().getInt("sheep-time"));
                        GameTimer.this.spawnSheep(localArena);
                    }
                    for (Player p : localArena.getPlayerTeam().keySet()) {
                        p.setScoreboard(new Scoreboards().getGameScoreboard(localArena, p));
                    }
                    if (timePoints.contains(localArena.getTimer())) {
                        for (Player p : localArena.getPlayerTeam().keySet()) {
                            ActionBar.sendActionBar(p, GameTimer.this.plugin.getMessage("game.time-left").replace("%time%", Integer.toString(localArena.getTimer())));
                            Sounds.playSound(p, p.getLocation(), "ending-countdown");
                        }
                    }
                    localArena.setTimer(localArena.getTimer() - 1);
                    localArena.setSheepTimer(localArena.getSheepTimer() - 1);
                } else {
                    new End().gameEnd(localArena);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void spawnSheep(LocalArena localArena) {
        String arenaString = localArena.getName();
        Location loc = ConfigUtils.getLocation(arenaString, ConfigField.SHEEP_SPAWN);
        Sheep sheep = (Sheep)loc.getWorld().spawn(loc, Sheep.class);
        sheep.setColor(DyeColor.WHITE);
        Sounds.playSound(localArena, loc, "sheep-spawn");
        Particles.spawnParticle(localArena, loc.add(0.0, 1.0, 0.0), "sheep-spawn");
        Pathfinding.walkToLocation((LivingEntity)sheep, loc, this.plugin.getConfig().getDouble("sheep-speed"), localArena, Team.NONE);
    }
}

