/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game;

import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.messages.Titles;
import java.util.ArrayList;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.game.Scoreboards;
import me.cubixor.sheepquest.spigot.game.Start;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Countdown {
    private final SheepQuest plugin = SheepQuest.getInstance();

    public void time(final String arenaString) {
        for (Player p : this.plugin.getLocalArenas().get(arenaString).getPlayerTeam().keySet()) {
            p.sendMessage(this.plugin.getMessage("game.countdown-started"));
        }
        final ArrayList<Integer> t1 = new ArrayList<Integer>(){
            {
                this.add(60);
                this.add(30);
                this.add(10);
            }
        };
        final ArrayList<Integer> t2 = new ArrayList<Integer>(){
            {
                this.add(5);
                this.add(4);
                this.add(3);
                this.add(2);
                this.add(1);
            }
        };
        new BukkitRunnable(){

            public void run() {
                LocalArena localArena = Countdown.this.plugin.getLocalArenas().get(arenaString);
                if (localArena == null) {
                    this.cancel();
                    return;
                }
                if (!localArena.getState().equals(GameState.STARTING)) {
                    this.cancel();
                    return;
                }
                int time = localArena.getTimer();
                if (time > 0) {
                    float pitch = 0.0f;
                    if (t1.contains(time)) {
                        pitch = 0.5f;
                        for (Player p : localArena.getPlayerTeam().keySet()) {
                            Titles.sendTitle(p, 10, 50, 10, Countdown.this.plugin.getMessage("game.countdown-" + time + "s-title"), Countdown.this.plugin.getMessage("game.countdown-" + time + "s-subtitle"));
                            p.sendMessage(Countdown.this.plugin.getMessage("game.countdown-chat").replace("%time%", Integer.toString(time)));
                        }
                    } else if (t2.contains(time)) {
                        pitch = 1.0f;
                        for (Player p : localArena.getPlayerTeam().keySet()) {
                            Titles.sendTitle(p, 0, 50, 0, Countdown.this.plugin.getMessage("game.countdown-" + time + "s-title"), Countdown.this.plugin.getMessage("game.countdown-" + time + "s-subtitle"));
                            p.sendMessage(Countdown.this.plugin.getMessage("game.countdown-chat").replace("%time%", Integer.toString(time)));
                        }
                        if (time == 1) {
                            pitch = 2.0f;
                        }
                    }
                    for (Player p : localArena.getPlayerTeam().keySet()) {
                        p.setScoreboard(new Scoreboards().getStartingScoreboard(localArena, p));
                        p.setLevel(localArena.getTimer());
                        if (pitch == 0.0f || !Countdown.this.plugin.getConfig().getBoolean("sounds.countdown.enabled")) continue;
                        Sound sound = XSound.matchXSound(Countdown.this.plugin.getConfig().getString("sounds.countdown.sound")).get().parseSound();
                        float volume = (float)Countdown.this.plugin.getConfig().getDouble("sounds.countdown.volume");
                        p.playSound(p.getLocation(), sound, volume, pitch);
                    }
                    localArena.setTimer(localArena.getTimer() - 1);
                } else {
                    new Start().start(localArena);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
        new BukkitRunnable(){

            public void run() {
                LocalArena localArena = Countdown.this.plugin.getLocalArenas().get(arenaString);
                if (localArena == null) {
                    this.cancel();
                    return;
                }
                if (!localArena.getState().equals(GameState.STARTING)) {
                    this.cancel();
                    return;
                }
                if (localArena.getPlayerTeam().size() == 0) {
                    this.cancel();
                    return;
                }
                if (localArena.getTimer() >= 0) {
                    float exp = new ArrayList<Player>(localArena.getPlayerTeam().keySet()).get(0).getExp();
                    exp = exp <= 0.0f ? 0.94f : (exp -= 0.05f);
                    if (exp < 0.0f) {
                        exp = 0.0f;
                    }
                    for (Player p : localArena.getPlayerTeam().keySet()) {
                        p.setExp(exp);
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
    }
}

