/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.config;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.config.ConfigField;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import me.cubixor.sheepquest.spigot.mysql.MysqlConnection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class ConfigUtils {
    public static boolean mysqlEnabled() {
        return SheepQuest.getInstance().getConfig().getBoolean("database.enabled-arenas");
    }

    public static Location stringToLocation(String locStr) {
        String[] split = locStr.split(";");
        String worldStr = split[0];
        String xStr = split[1];
        String yStr = split[2];
        String zStr = split[3];
        String yawStr = split[4];
        String pitchStr = split[5];
        World world = Bukkit.getWorld((String)worldStr);
        float x = Float.parseFloat(xStr);
        float y = Float.parseFloat(yStr);
        float z = Float.parseFloat(zStr);
        float yaw = Float.parseFloat(yawStr);
        float pitch = Float.parseFloat(pitchStr);
        return new Location(world, (double)x, (double)y, (double)z, yaw, pitch);
    }

    public static String locationToString(Location loc) {
        String world = loc.getWorld().getName();
        String x = String.valueOf(loc.getX());
        String y = String.valueOf(loc.getY());
        String z = String.valueOf(loc.getZ());
        String yaw = String.valueOf(loc.getYaw());
        String pitch = String.valueOf(loc.getPitch());
        CharSequence[] locArray = new String[]{world, x, y, z, yaw, pitch};
        return String.join((CharSequence)";", locArray);
    }

    public static String joinLocations(Location loc1, Location loc2) {
        String loc1Str = ConfigUtils.locationToString(loc1);
        String loc2Str = ConfigUtils.locationToString(loc2);
        return String.join((CharSequence)":", loc1Str, loc2Str);
    }

    public static String[] splitLocations(String locString) {
        return locString.split(":");
    }

    public static String getString(String arena, ConfigField configField) {
        if (ConfigUtils.mysqlEnabled()) {
            try {
                ResultSet results = ConfigUtils.executeStatement(arena, configField);
                if (results == null) {
                    return null;
                }
                if (results.next()) {
                    return results.getString(configField.getCode());
                }
                return null;
            }
            catch (SQLException e) {
                ConfigUtils.sendErrorMessage(e);
                return null;
            }
        }
        SheepQuest plugin = SheepQuest.getInstance();
        return plugin.getArenasConfig().getString("arenas." + arena + "." + configField.getCode());
    }

    public static List<Team> getTeamList(String arena) {
        SheepQuest plugin = SheepQuest.getInstance();
        ArrayList stringTeams = new ArrayList(plugin.getArenasConfig().getStringList("arenas." + arena + "." + ConfigField.TEAMS.getCode()));
        ArrayList<Team> teams = new ArrayList<Team>();
        for (Team t : Utils.getTeams()) {
            if (!stringTeams.contains(t.getCode())) continue;
            teams.add(t);
        }
        return teams;
    }

    public static List<String> getArenas() {
        SheepQuest plugin = SheepQuest.getInstance();
        if (ConfigUtils.mysqlEnabled()) {
            MysqlConnection mysqlConnection = plugin.getMysqlConnection();
            try {
                Connection connection = mysqlConnection.getConnection();
                PreparedStatement statement = connection.prepareStatement("SELECT `name` FROM " + mysqlConnection.getDatabase() + "." + mysqlConnection.getTableArenas());
                ResultSet results = statement.executeQuery();
                ArrayList<String> arenas = new ArrayList<String>();
                while (results.next()) {
                    arenas.add(results.getString("name"));
                }
                return arenas;
            }
            catch (SQLException e) {
                ConfigUtils.sendErrorMessage(e);
                return new ArrayList<String>();
            }
        }
        if (plugin.getArenasConfig().getConfigurationSection("arenas") != null) {
            return new ArrayList<String>(plugin.getArenasConfig().getConfigurationSection("arenas").getKeys(false));
        }
        return new ArrayList<String>();
    }

    public static boolean getBoolean(String arena, ConfigField configField) {
        if (ConfigUtils.mysqlEnabled()) {
            try {
                ResultSet results = ConfigUtils.executeStatement(arena, configField);
                if (results == null) {
                    return false;
                }
                if (results.next()) {
                    return results.getBoolean(configField.getCode());
                }
                return false;
            }
            catch (SQLException e) {
                ConfigUtils.sendErrorMessage(e);
                return false;
            }
        }
        SheepQuest plugin = SheepQuest.getInstance();
        return plugin.getArenasConfig().getBoolean("arenas." + arena + "." + configField.getCode());
    }

    public static Location getLocation(String arena, ConfigField configField) {
        SheepQuest plugin = SheepQuest.getInstance();
        String locString = plugin.getArenasConfig().getString("arenas." + arena + "." + configField.getCode());
        if (locString == null) {
            return null;
        }
        return ConfigUtils.stringToLocation(locString);
    }

    public static Location getSpawn(String arena, Team team) {
        SheepQuest plugin = SheepQuest.getInstance();
        String locString = plugin.getArenasConfig().getString("arenas." + arena + ".spawn." + team.getCode());
        if (locString == null) {
            return null;
        }
        return ConfigUtils.stringToLocation(locString);
    }

    public static Location[] getArea(String arena, Team team) {
        SheepQuest plugin = SheepQuest.getInstance();
        String locString = plugin.getArenasConfig().getString("arenas." + arena + ".area." + team.getCode());
        if (locString == null) {
            return null;
        }
        String[] splitLoc = ConfigUtils.splitLocations(locString);
        Location[] locations = new Location[]{ConfigUtils.stringToLocation(splitLoc[0]), ConfigUtils.stringToLocation(splitLoc[1])};
        return locations;
    }

    public static int getInt(String arena, ConfigField configField) {
        if (ConfigUtils.mysqlEnabled()) {
            try {
                ResultSet results = ConfigUtils.executeStatement(arena, configField);
                if (results == null) {
                    return 0;
                }
                if (results.next()) {
                    return results.getInt(configField.getCode());
                }
                return 0;
            }
            catch (SQLException e) {
                ConfigUtils.sendErrorMessage(e);
                return 0;
            }
        }
        SheepQuest plugin = SheepQuest.getInstance();
        return plugin.getArenasConfig().getInt("arenas." + arena + "." + configField.getCode());
    }

    private static ResultSet executeStatement(String arena, ConfigField configField) throws SQLException {
        SheepQuest plugin = SheepQuest.getInstance();
        MysqlConnection mysqlConnection = plugin.getMysqlConnection();
        Connection connection = mysqlConnection.getConnection();
        PreparedStatement statement = connection.prepareStatement("SELECT `" + configField.getCode() + "` FROM " + mysqlConnection.getDatabase() + "." + mysqlConnection.getTableArenas() + " WHERE `name`='" + arena + "'");
        ResultSet results = statement.executeQuery();
        if (Bukkit.isPrimaryThread() && plugin.isEnabled()) {
            try {
                throw new Exception("Synchronized database access");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return results;
    }

    public static void insertArena(String arena) {
        SheepQuest plugin = SheepQuest.getInstance();
        if (ConfigUtils.mysqlEnabled()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try {
                    MysqlConnection mysqlConnection = plugin.getMysqlConnection();
                    Connection connection = mysqlConnection.getConnection();
                    PreparedStatement statement = connection.prepareStatement("INSERT INTO " + mysqlConnection.getDatabase() + "." + mysqlConnection.getTableArenas() + " (`name`, `server`) VALUES ('" + arena + "', '" + plugin.getServerName() + "')");
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    ConfigUtils.sendErrorMessage(e);
                }
            });
        } else {
            plugin.getArenasConfig().set("arenas." + arena + ".server", (Object)plugin.getServerName());
            plugin.getArenasConfig().set("arenas." + arena + ".active", (Object)false);
            plugin.getArenasConfig().set("arenas." + arena + ".vip", (Object)false);
            plugin.getArenasConfig().set("arenas." + arena + ".min-players", (Object)0);
            plugin.getArenasConfig().set("arenas." + arena + ".max-players", (Object)0);
            plugin.saveArenas();
        }
    }

    public static void removeArena(String arena) {
        SheepQuest plugin = SheepQuest.getInstance();
        if (ConfigUtils.mysqlEnabled()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try {
                    MysqlConnection mysqlConnection = plugin.getMysqlConnection();
                    Connection connection = mysqlConnection.getConnection();
                    PreparedStatement statement = connection.prepareStatement("DELETE FROM " + mysqlConnection.getDatabase() + "." + mysqlConnection.getTableArenas() + " WHERE `name` = '" + arena + "'");
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    ConfigUtils.sendErrorMessage(e);
                }
            });
        }
        plugin.getArenasConfig().set("arenas." + arena, null);
        plugin.saveArenas();
    }

    private static void updateField(String arena, ConfigField configField, String fieldCode, Object value) {
        SheepQuest plugin = SheepQuest.getInstance();
        if (ConfigUtils.mysqlEnabled() && configField.savedInDatabase()) {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
                try {
                    String str = value.toString();
                    if (value instanceof Boolean) {
                        boolean bool = (Boolean)value;
                        str = bool ? "1" : "0";
                    }
                    MysqlConnection mysqlConnection = plugin.getMysqlConnection();
                    Connection connection = mysqlConnection.getConnection();
                    PreparedStatement statement = connection.prepareStatement("UPDATE " + mysqlConnection.getDatabase() + "." + mysqlConnection.getTableArenas() + " SET `" + fieldCode + "` = '" + str + "' WHERE `name` = '" + arena + "'");
                    statement.executeUpdate();
                }
                catch (SQLException e) {
                    ConfigUtils.sendErrorMessage(e);
                }
            });
        } else {
            plugin.getArenasConfig().set("arenas." + arena + "." + fieldCode, value);
            plugin.saveArenas();
        }
    }

    public static void updateField(String arena, ConfigField configField, Object value) {
        ConfigUtils.updateField(arena, configField, configField.getCode(), value);
    }

    public static void updateField(String arena, ConfigField configField, Team team, Object value) {
        ConfigUtils.updateField(arena, configField, configField.getCode() + team.getCode(), value);
    }

    private static void sendErrorMessage(SQLException e) {
        SheepQuest plugin = SheepQuest.getInstance();
        plugin.getLogger().severe(ChatColor.RED + "Lost connection with mysql server. Restart spigot server to reconnect.");
        e.printStackTrace();
    }
}

