/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.commands;

import java.util.ArrayList;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.commands.PlayCommands;
import me.cubixor.sheepquest.spigot.config.ConfigField;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.game.End;
import me.cubixor.sheepquest.spigot.game.Signs;
import me.cubixor.sheepquest.spigot.game.Start;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.socket.SocketClientSender;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class StaffCommands {
    private final SheepQuest plugin = SheepQuest.getInstance();

    public void kick(Player player, String[] args) {
        if (!player.hasPermission("sheepquest.staff.kick")) {
            player.sendMessage(this.plugin.getMessage("general.no-permission"));
            return;
        }
        if (args.length != 2) {
            player.sendMessage(this.plugin.getMessage("arena-moderate.kick-usage"));
            return;
        }
        String target = args[1];
        if (player.getName().equals(target)) {
            new PlayCommands().leave(player);
            return;
        }
        ArrayList<String> localPlayers = new ArrayList<String>();
        for (Arena arena : this.plugin.getLocalArenas().values()) {
            localPlayers.addAll(arena.getPlayers());
        }
        ArrayList<String> bungeePlayers = new ArrayList<String>();
        for (Arena arena3 : this.plugin.getArenas().values()) {
            bungeePlayers.addAll(arena3.getPlayers());
        }
        Arena arena = Utils.getArena(target);
        if (localPlayers.contains(target)) {
            this.kickFromLocalArena(player.getName(), target, arena.getName());
        } else if (bungeePlayers.contains(target)) {
            new SocketClientSender().sendKickPacket(player.getName(), target, arena);
        } else {
            player.sendMessage(this.plugin.getMessage("arena-moderate.kick-player-not-playing").replace("%player%", target));
            return;
        }
        player.sendMessage(this.plugin.getMessage("arena-moderate.kick-success").replace("%arena%", arena.getName()).replace("%player%", target));
    }

    public void kickFromLocalArena(String playerName, String targetName, String arena) {
        Player targetPlayer = Bukkit.getPlayerExact((String)targetName);
        LocalArena localArena = this.plugin.getLocalArenas().get(arena);
        new PlayCommands().kickFromLocalArena(targetPlayer, localArena, false, false);
        targetPlayer.sendMessage(this.plugin.getMessage("arena-moderate.kick-player").replace("%kicker%", playerName));
        for (Player p : localArena.getPlayerTeam().keySet()) {
            if (p.getName().equals(targetName) || p.getName().equals(playerName)) continue;
            p.sendMessage(this.plugin.getMessage("arena-moderate.kick-players").replace("%kicker%", playerName).replace("%player%", targetName));
        }
    }

    public void forceStart(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.staff.start", "arena-moderate.force-start", 2, false)) {
                return;
            }
            Arena arena = this.plugin.getArena(args[1]);
            if (arena.getState().equals(GameState.GAME) || arena.getState().equals(GameState.ENDING)) {
                player.sendMessage(this.plugin.getMessage("arena-moderate.force-start-already-started").replace("%arena%", args[1]));
                return;
            }
            if (arena.getPlayers().size() == 0) {
                player.sendMessage(this.plugin.getMessage("arena-moderate.force-start-no-players").replace("%arena%", args[1]));
                return;
            }
            if (!arena.getPlayers().contains(player.getName())) {
                player.sendMessage(this.plugin.getMessage("arena-moderate.force-start-success").replace("%player%", player.getName()));
            }
            if (this.plugin.getLocalArenas().containsKey(args[1])) {
                this.forceLocalArenaStart(player.getName(), args[1]);
            } else {
                new SocketClientSender().sendForceStartPacket(player.getName(), arena);
            }
        });
    }

    public void forceLocalArenaStart(String playerName, String arena) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            LocalArena localArena = this.plugin.getLocalArenas().get(arena);
            for (Player p : localArena.getPlayerTeam().keySet()) {
                p.sendMessage(this.plugin.getMessage("arena-moderate.force-start-success").replace("%player%", playerName));
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> new Start().start(localArena));
        });
    }

    public void forceStop(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.staff.stop", "arena-moderate.force-stop", 2, false)) {
                return;
            }
            Arena arena = this.plugin.getArena(args[1]);
            if (arena.getState().equals(GameState.WAITING) || arena.getState().equals(GameState.STARTING)) {
                player.sendMessage(this.plugin.getMessage("arena-moderate.force-stop-not-started").replace("%arena%", args[1]));
                return;
            }
            if (!arena.getPlayers().contains(player.getName())) {
                player.sendMessage(this.plugin.getMessage("arena-moderate.force-stop-success").replace("%player%", player.getName()));
            }
            if (this.plugin.getLocalArenas().containsKey(args[1])) {
                this.forceLocalArenaStop(player.getName(), args[1]);
            } else {
                new SocketClientSender().sendForceStopPacket(player.getName(), arena);
            }
        });
    }

    public void forceLocalArenaStop(String playerName, String arena) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            LocalArena localArena = this.plugin.getLocalArenas().get(arena);
            for (Player p : localArena.getPlayerTeam().keySet()) {
                p.sendMessage(this.plugin.getMessage("arena-moderate.force-stop-success").replace("%player%", playerName));
            }
            new End().resetArena(localArena, false);
        });
    }

    public void setActive(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.staff.active", "arena-moderate.active", 3, true)) {
                return;
            }
            if (!args[2].equalsIgnoreCase("true") && !args[2].equalsIgnoreCase("false")) {
                player.sendMessage(this.plugin.getMessage("arena-moderate.active-usage"));
                return;
            }
            boolean cmdActive = Boolean.parseBoolean(args[2]);
            boolean active = ConfigUtils.getBoolean(args[1], ConfigField.ACTIVE);
            if (Utils.checkIfReady(args[1]).containsValue(false)) {
                player.sendMessage(this.plugin.getMessage("arena-moderate.active-not-ready").replace("%arena%", args[1]));
                return;
            }
            if (cmdActive && active) {
                player.sendMessage(this.plugin.getMessage("arena-moderate.active-arena-active").replace("%arena%", args[1]));
            } else if (!cmdActive && !active) {
                player.sendMessage(this.plugin.getMessage("arena-moderate.active-arena-not-active").replace("%arena%", args[1]));
            } else {
                ConfigUtils.updateField(args[1], ConfigField.ACTIVE, cmdActive);
                new Signs().updateSigns(args[1]);
                if (cmdActive) {
                    player.sendMessage(this.plugin.getMessage("arena-moderate.active-activate").replace("%arena%", args[1]));
                } else {
                    this.forceLocalArenaStop(player.getName(), args[1]);
                    player.sendMessage(this.plugin.getMessage("arena-moderate.active-deactivate").replace("%arena%", args[1]));
                }
            }
        });
    }
}

