/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.bungee.socket;

import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import me.cubixor.sheepquest.bungee.SheepQuestBungee;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.utils.packets.PacketType;
import me.cubixor.sheepquest.utils.packets.classes.ArenaPacket;
import me.cubixor.sheepquest.utils.packets.classes.ArenaPlayerPacket;
import me.cubixor.sheepquest.utils.packets.classes.ArenasPacket;
import me.cubixor.sheepquest.utils.packets.classes.JoinPacket;
import me.cubixor.sheepquest.utils.packets.classes.KickPacket;
import me.cubixor.sheepquest.utils.packets.classes.ServerArenasPacket;
import me.cubixor.sheepquest.utils.packets.classes.StringPacket;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class SocketServerSender {
    private final SheepQuestBungee plugin = SheepQuestBungee.getInstance();

    private ObjectOutputStream getOutputStream(String server) {
        try {
            return this.plugin.getSpigotSocket().get(server).getOutputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void joinArena(JoinPacket joinPacket) {
        try {
            ObjectOutputStream out = this.getOutputStream(joinPacket.getArena().getServer());
            if (out == null) {
                return;
            }
            ProxiedPlayer proxiedPlayer = this.plugin.getProxy().getPlayer(joinPacket.getPlayer());
            proxiedPlayer.connect(this.plugin.getProxy().getServerInfo(joinPacket.getArena().getServer()));
            out.writeObject(joinPacket);
            out.flush();
            out.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void leaveArena(ArenaPlayerPacket arenaPlayerPacket) {
        try {
            ObjectOutputStream out = this.getOutputStream(arenaPlayerPacket.getArena().getServer());
            if (out == null) {
                return;
            }
            out.writeObject(arenaPlayerPacket);
            out.flush();
            out.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendArena(ArenaPacket arenaPacket) {
        try {
            ArrayList<String> servers = new ArrayList<String>(this.getServersToSend(arenaPacket.getArena().getServer()));
            for (String server : servers) {
                ObjectOutputStream out = this.getOutputStream(server);
                if (out == null) {
                    return;
                }
                out.writeObject(arenaPacket);
                out.flush();
                out.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeArena(ArenaPacket arenaPacket) {
        try {
            ArrayList<String> servers = new ArrayList<String>(this.getServersToSend(arenaPacket.getArena().getServer()));
            for (String server : servers) {
                ObjectOutputStream out = this.getOutputStream(server);
                if (out == null) {
                    return;
                }
                out.writeObject(arenaPacket);
                out.flush();
                out.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendAllArenas(String server, List<Arena> arenas) {
        try {
            ObjectOutputStream out = this.getOutputStream(server);
            if (out == null) {
                return;
            }
            ArenasPacket arenasPacket = new ArenasPacket(PacketType.ARENAS_ADD, arenas);
            out.writeObject(arenasPacket);
            out.flush();
            out.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendServerArenas(ServerArenasPacket serverArenasPacket) {
        try {
            ArrayList<String> servers = new ArrayList<String>(this.getServersToSend(serverArenasPacket.getServer()));
            for (String serverToSend : servers) {
                ObjectOutputStream out = this.getOutputStream(serverToSend);
                if (out == null) {
                    return;
                }
                out.writeObject(serverArenasPacket);
                out.flush();
                out.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void removeServerArenas(String server) {
        try {
            ArrayList<String> arenas = new ArrayList<String>(this.plugin.getArenas().keySet());
            for (String arena : arenas) {
                if (!this.plugin.getArenas().get(arena).getServer().equals(server)) continue;
                this.plugin.getArenas().remove(arena);
            }
            ArrayList<String> servers = new ArrayList<String>(this.getServersToSend(server));
            for (String serverToSend : servers) {
                ObjectOutputStream out = this.getOutputStream(serverToSend);
                if (out == null) {
                    return;
                }
                StringPacket stringPacket = new StringPacket(PacketType.SERVER_ARENAS_REMOVE, server);
                out.writeObject(stringPacket);
                out.flush();
                out.reset();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void forceStart(ArenaPlayerPacket arenaPlayerPacket) {
        try {
            ObjectOutputStream out = this.getOutputStream(arenaPlayerPacket.getArena().getServer());
            if (out == null) {
                return;
            }
            out.writeObject(arenaPlayerPacket);
            out.flush();
            out.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void forceStop(ArenaPlayerPacket arenaPlayerPacket) {
        try {
            ObjectOutputStream out = this.getOutputStream(arenaPlayerPacket.getArena().getServer());
            if (out == null) {
                return;
            }
            out.writeObject(arenaPlayerPacket);
            out.flush();
            out.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void kick(KickPacket kickPacket) {
        try {
            ObjectOutputStream out = this.getOutputStream(kickPacket.getArena().getServer());
            if (out == null) {
                return;
            }
            out.writeObject(kickPacket);
            out.flush();
            out.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private List<String> getServersToSend(String server) {
        ArrayList<String> servers = new ArrayList<String>();
        for (String srv : this.plugin.getSpigotSocket().keySet()) {
            if (srv.equals(server)) continue;
            servers.add(srv);
        }
        return servers;
    }
}

