/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.reflection.minecraft;

import java.util.regex.Matcher;
import org.bukkit.Bukkit;
import org.inventivetalent.reflection.minecraft.Minecraft;

public class MinecraftVersion {
    public static final MinecraftVersion VERSION;
    private final String packageName;
    private final int version;

    MinecraftVersion(String packageName, int version) {
        this.packageName = packageName;
        this.version = version;
    }

    MinecraftVersion(Minecraft.Version version) {
        this(version.name(), version.version());
    }

    public int version() {
        return this.version;
    }

    public String packageName() {
        return this.packageName;
    }

    public boolean olderThan(Minecraft.Version version) {
        return this.version() < version.version();
    }

    public boolean equal(Minecraft.Version version) {
        return this.version() < version.version();
    }

    public boolean newerThan(Minecraft.Version version) {
        return this.version() >= version.version();
    }

    public boolean inRange(Minecraft.Version oldVersion, Minecraft.Version newVersion) {
        return this.newerThan(oldVersion) && this.olderThan(newVersion);
    }

    public boolean matchesPackageName(String packageName) {
        return this.packageName.toLowerCase().contains(packageName.toLowerCase());
    }

    public String toString() {
        return this.packageName + " (" + this.version() + ")";
    }

    public static MinecraftVersion getVersion() {
        String name = Bukkit.getServer().getClass().getPackage().getName();
        String versionPackage = name.substring(name.lastIndexOf(46) + 1);
        for (Minecraft.Version version : Minecraft.Version.values()) {
            MinecraftVersion minecraftVersion = version.minecraft();
            if (!minecraftVersion.matchesPackageName(versionPackage)) continue;
            return minecraftVersion;
        }
        System.err.println("[ReflectionHelper/MinecraftVersion] Failed to find version enum for '" + name + "'/'" + versionPackage + "'");
        System.out.println("[ReflectionHelper/MinecraftVersion] Generating dynamic constant...");
        Matcher matcher = Minecraft.NUMERIC_VERSION_PATTERN.matcher(versionPackage);
        while (matcher.find()) {
            String patchString;
            if (matcher.groupCount() < 3) continue;
            String majorString = matcher.group(1);
            String minorString = matcher.group(2);
            if (minorString.length() == 1) {
                minorString = "0" + minorString;
            }
            if ((patchString = matcher.group(3)).length() == 1) {
                patchString = "0" + patchString;
            }
            String numVersionString = majorString + minorString + patchString;
            int numVersion = Integer.parseInt(numVersionString);
            String packageName = "v" + versionPackage.substring(1).toUpperCase();
            System.out.println("[ReflectionHelper/MinecraftVersion] Injected dynamic version " + packageName + " (#" + numVersion + ").");
            System.out.println("[ReflectionHelper/MinecraftVersion] Please inform inventivetalent about the outdated version, as this is not guaranteed to work.");
            return new MinecraftVersion(packageName, numVersion);
        }
        System.err.println("[ReflectionHelper/MinecraftVersion] Failed to create dynamic version for " + versionPackage);
        return new MinecraftVersion("UNKNOWN", -1);
    }

    static {
        System.out.println("[ReflectionHelper/MinecraftVersion] I am loaded from package " + Minecraft.class.getPackage().getName());
        try {
            VERSION = MinecraftVersion.getVersion();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to get version", e);
        }
        System.out.println("[ReflectionHelper/MinecraftVersion] Version is " + VERSION);
    }
}

