/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.particle;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.inventivetalent.particle.ParticleException;
import org.inventivetalent.reflection.minecraft.Minecraft;
import org.inventivetalent.reflection.resolver.ConstructorResolver;
import org.inventivetalent.reflection.resolver.FieldResolver;
import org.inventivetalent.reflection.resolver.MethodResolver;
import org.inventivetalent.reflection.resolver.minecraft.NMSClassResolver;

public enum ParticleEffect {
    EXPLOSION_NORMAL("explode"),
    EXPLOSION_LARGE("largeexplode"),
    EXPLOSION_HUGE("hugeexplosion"),
    FIREWORKS_SPARK("fireworksSpark"),
    WATER_BUBBLE("bubble"),
    WATER_SPLASH("splash"),
    WATER_WAKE("wake"),
    SUSPENDED("suspended"),
    SUSPENDED_DEPTH("depthsuspend"),
    CRIT("crit"),
    CRIT_MAGIC("magicCrit"),
    SMOKE_NORMAL("smoke"),
    SMOKE_LARGE("largesmoke"),
    SPELL("spell"),
    SPELL_INSTANT("instantSpell"),
    SPELL_MOB("mobSpell", Minecraft.Version.v1_7_R1, Feature.COLOR),
    SPELL_MOB_AMBIENT("mobSpellAmbient"),
    SPELL_WITCH("witchMagic"),
    DRIP_WATER("dripWater"),
    DRIP_LAVA("dripLava"),
    VILLAGER_ANGRY("angryVillager"),
    VILLAGER_HAPPY("happyVillager"),
    TOWN_AURA("townaura"),
    NOTE("note", Minecraft.Version.v1_7_R1, Feature.COLOR),
    PORTAL("portal"),
    ENCHANTMENT_TABLE("enchantmenttable"),
    FLAME("flame"),
    LAVA("lava"),
    FOOTSTEP("footstep"),
    CLOUD("cloud"),
    REDSTONE("reddust", Minecraft.Version.v1_7_R1, Feature.COLOR),
    SNOWBALL("snowballpoof"),
    SNOW_SHOVEL("snowshovel"),
    SLIME("slime"),
    HEART("heart"),
    BARRIER("barrier", Minecraft.Version.v1_8_R1),
    ITEM_CRACK("iconcrack_", Minecraft.Version.v1_7_R1, Feature.DATA){

        @Override
        public void send(Collection<? extends Player> receivers, Location location, double offsetX, double offsetY, double offsetZ, double speed, int count) {
            throw new ParticleException("Cannot use default send() for ITEM_CRACK");
        }

        @Override
        public void send(Collection<? extends Player> receivers, Location location, double offsetX, double offsetY, double offsetZ, double speed, int count, double range) {
            throw new ParticleException("Cannot use default send() for ITEM_CRACK");
        }

        @Override
        public void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, double range) {
            throw new ParticleException("Cannot use default send() for ITEM_CRACK");
        }

        @Override
        public void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count) {
            throw new ParticleException("Cannot use default send() for ITEM_CRACK");
        }
    }
    ,
    BLOCK_CRACK("blockcrack_", Minecraft.Version.v1_7_R1, Feature.DATA){

        @Override
        public void send(Collection<? extends Player> receivers, Location location, double offsetX, double offsetY, double offsetZ, double speed, int count) {
            throw new ParticleException("Cannot use default send() for BLOCK_CRACK");
        }

        @Override
        public void send(Collection<? extends Player> receivers, Location location, double offsetX, double offsetY, double offsetZ, double speed, int count, double range) {
            throw new ParticleException("Cannot use default send() for BLOCK_CRACK");
        }

        @Override
        public void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, double range) {
            throw new ParticleException("Cannot use default send() for BLOCK_CRACK");
        }

        @Override
        public void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count) {
            throw new ParticleException("Cannot use default send() for BLOCK_CRACK");
        }
    }
    ,
    BLOCK_DUST("blockdust_", Minecraft.Version.v1_7_R1, Feature.DATA){

        @Override
        public void sendData(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, int itemId, byte data) {
            data = (byte)-1;
            super.sendData(receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count, itemId, data);
        }

        @Override
        public void send(Collection<? extends Player> receivers, Location location, double offsetX, double offsetY, double offsetZ, double speed, int count) {
            throw new ParticleException("Cannot use default send() for BLOCK_DUST");
        }

        @Override
        public void send(Collection<? extends Player> receivers, Location location, double offsetX, double offsetY, double offsetZ, double speed, int count, double range) {
            throw new ParticleException("Cannot use default send() for BLOCK_DUST");
        }

        @Override
        public void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, double range) {
            throw new ParticleException("Cannot use default send() for BLOCK_DUST");
        }

        @Override
        public void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count) {
            throw new ParticleException("Cannot use default send() for BLOCK_DUST");
        }
    }
    ,
    WATER_DROP("droplet", Minecraft.Version.v1_8_R1),
    ITEM_TAKE("take", Minecraft.Version.v1_8_R1),
    MOB_APPEARANCE("mobappearance", Minecraft.Version.v1_8_R1),
    DRAGON_BREATH("dragonbreath", Minecraft.Version.v1_9_R1),
    END_ROD("endRod", Minecraft.Version.v1_9_R1),
    DAMAGE_INDICATOR("damageIndicator", Minecraft.Version.v1_9_R1),
    SWEEP_ATTACK("sweepAttack", Minecraft.Version.v1_9_R1),
    FALLING_DUST("fallingDust", Minecraft.Version.v1_10_R1),
    SPIT("spit", Minecraft.Version.v1_11_R1),
    TOTEM("totem", Minecraft.Version.v1_11_R1);

    private String name;
    private Minecraft.Version minVersion;
    private Feature feature;
    protected Particle particle;

    private ParticleEffect(String name, Minecraft.Version minVersion, Feature feature) {
        this.name = name;
        this.minVersion = minVersion;
        this.feature = feature;
        this.particle = feature != null ? feature.particle(this) : new Particle(this);
    }

    private ParticleEffect(String name, Minecraft.Version minVersion) {
        this(name, minVersion, null);
    }

    private ParticleEffect(String name) {
        this(name, Minecraft.Version.v1_7_R1);
    }

    public String getName() {
        return this.name;
    }

    public Minecraft.Version getMinVersion() {
        return this.minVersion;
    }

    public boolean isCompatible() {
        return Minecraft.VERSION.newerThan(this.getMinVersion());
    }

    public boolean hasFeature(Feature feature) {
        return this.feature == feature;
    }

    public boolean hasNoFeatures() {
        return this.feature == null;
    }

    public void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, double range) {
        double squareRange = range * range;
        ArrayList<Player> inRange = new ArrayList<Player>();
        for (Player player : receivers) {
            Location location = new Location(player.getWorld(), x, y, z);
            if (!(player.getLocation().distanceSquared(location) <= squareRange)) continue;
            inRange.add(player);
        }
        this.send(inRange, x, y, z, offsetX, offsetY, offsetZ, speed, count);
    }

    public void send(Collection<? extends Player> receivers, Location location, double offsetX, double offsetY, double offsetZ, double speed, int count, double range) {
        receivers = new ArrayList<Player>(receivers);
        Iterator<? extends Player> iterator = receivers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getWorld().getName().equals(location.getWorld().getName())) continue;
            iterator.remove();
        }
        this.send(receivers, location.getX(), location.getY(), location.getZ(), offsetX, offsetY, offsetZ, speed, count, range);
    }

    public void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count) {
        this.particle.send(receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count, new int[0]);
    }

    public void send(Collection<? extends Player> receivers, Location location, double offsetX, double offsetY, double offsetZ, double speed, int count) {
        receivers = new ArrayList<Player>(receivers);
        Iterator<? extends Player> iterator = receivers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getWorld().getName().equals(location.getWorld().getName())) continue;
            iterator.remove();
        }
        this.particle.send(receivers, location.getX(), location.getY(), location.getZ(), offsetX, offsetY, offsetZ, speed, count, new int[0]);
    }

    public void sendColor(Collection<? extends Player> receivers, double x, double y, double z, org.bukkit.Color color) {
        if (!this.hasFeature(Feature.COLOR)) {
            throw new ParticleException("This particle cannot be colored");
        }
        ((ColoredParticle)this.particle).send(receivers, x, y, z, color);
    }

    public void sendColor(Collection<? extends Player> receivers, double x, double y, double z, Color color) {
        if (!this.hasFeature(Feature.COLOR)) {
            throw new ParticleException("This particle cannot be colored");
        }
        ((ColoredParticle)this.particle).send(receivers, x, y, z, color);
    }

    public void sendColor(Collection<? extends Player> receivers, Location location, org.bukkit.Color color) {
        receivers = new ArrayList<Player>(receivers);
        Iterator<? extends Player> iterator = receivers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getWorld().getName().equals(location.getWorld().getName())) continue;
            iterator.remove();
        }
        this.sendColor(receivers, location.getX(), location.getY(), location.getZ(), color);
    }

    public void sendColor(Collection<? extends Player> receivers, Location location, Color color) {
        receivers = new ArrayList<Player>(receivers);
        Iterator<? extends Player> iterator = receivers.iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getWorld().getName().equals(location.getWorld().getName())) continue;
            iterator.remove();
        }
        this.sendColor(receivers, location.getX(), location.getY(), location.getZ(), color);
    }

    public void sendData(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, int itemId, byte data) {
        if (!this.hasFeature(Feature.DATA)) {
            throw new ParticleException("This particle cannot have block/item data");
        }
        ((DataParticle)this.particle).send(receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count, itemId, data);
    }

    public void sendData(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, ItemStack itemStack) {
        this.sendData(receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count, itemStack.getTypeId(), itemStack.getData().getData());
    }

    static Enum<?> getEnum(String enumFullName) {
        String[] x = enumFullName.split("\\.(?=[^\\.]+$)");
        if (x.length == 2) {
            String enumClassName = x[0];
            String enumName = x[1];
            try {
                Class<?> cl = Class.forName(enumClassName);
                return Enum.valueOf(cl, enumName);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected static void sendPacket(Object packet, Player p) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, NoSuchFieldException, NoSuchMethodException {
        if (Reflection.EntityPlayerFieldResolver == null) {
            Reflection.EntityPlayerFieldResolver = new FieldResolver(Reflection.NMS_CLASS_RESOLVER.resolve("EntityPlayer"));
        }
        if (Reflection.PlayerConnectionMethodResolver == null) {
            Reflection.PlayerConnectionMethodResolver = new MethodResolver(Reflection.NMS_CLASS_RESOLVER.resolve("PlayerConnection"));
        }
        try {
            Object handle = Minecraft.getHandle(p);
            Object connection = Reflection.EntityPlayerFieldResolver.resolve("playerConnection").get(handle);
            Reflection.PlayerConnectionMethodResolver.resolve("sendPacket").invoke(connection, packet);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    static class Reflection {
        static final NMSClassResolver NMS_CLASS_RESOLVER = new NMSClassResolver();
        private static FieldResolver EntityPlayerFieldResolver;
        private static MethodResolver PlayerConnectionMethodResolver;

        Reflection() {
        }
    }

    static class DataParticle
    extends Particle {
        DataParticle(ParticleEffect particleEffect) {
            super(particleEffect);
        }

        void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, int id, byte data) {
            try {
                if (Minecraft.VERSION.newerThan(Minecraft.Version.v1_8_R1)) {
                    this.send_1_8(receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count, id, id | data << 12);
                } else {
                    this.send_1_7(this.effect.name + id + (data >= 0 ? "_" + data : ""), receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count);
                }
            }
            catch (Exception e) {
                throw new ParticleException("Failed to send particle " + (Object)((Object)this.effect) + " to " + receivers.toString(), e);
            }
        }

        @Override
        void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, int ... extra) {
            super.send(receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count, extra);
        }
    }

    static class ColoredParticle
    extends Particle {
        ColoredParticle(ParticleEffect particleEffect) {
            super(particleEffect);
        }

        void send(Collection<? extends Player> receivers, double x, double y, double z, org.bukkit.Color color) {
            this.send(receivers, x, y, z, this.getColor(color.getRed()), this.getColor(color.getGreen()), this.getColor(color.getBlue()), 1.0, 0, new int[0]);
        }

        void send(Collection<? extends Player> receivers, double x, double y, double z, Color color) {
            this.send(receivers, x, y, z, this.getColor(color.getRed()), this.getColor(color.getGreen()), this.getColor(color.getBlue()), 1.0, 0, new int[0]);
        }

        @Override
        void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, int ... extra) {
            super.send(receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count, extra);
        }

        double getColor(double value) {
            if (value <= 0.0) {
                value = -1.0;
            }
            return value / 255.0;
        }
    }

    static class Particle {
        final Class<?> PacketParticle = Reflection.NMS_CLASS_RESOLVER.resolveSilent("PacketPlayOutWorldParticles");
        final Class<?> EnumParticle = Reflection.NMS_CLASS_RESOLVER.resolveSilent("EnumParticle");
        final ConstructorResolver PacketParticleConstructorResolver = new ConstructorResolver(this.PacketParticle);
        ParticleEffect effect;

        Particle(ParticleEffect particleEffect) {
            this.effect = particleEffect;
        }

        void send(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, int ... extra) {
            if (!this.effect.isCompatible()) {
                throw new ParticleException("Particle " + (Object)((Object)this.effect) + " is not compatible with the server version (" + (Object)((Object)Minecraft.VERSION) + " < " + (Object)((Object)this.effect.getMinVersion()) + ")");
            }
            try {
                if (Minecraft.VERSION.newerThan(Minecraft.Version.v1_8_R1)) {
                    this.send_1_8(receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count, extra);
                } else {
                    this.send_1_7(this.effect.name, receivers, x, y, z, offsetX, offsetY, offsetZ, speed, count);
                }
            }
            catch (Exception e) {
                throw new ParticleException("Failed to send particle " + (Object)((Object)this.effect) + " to " + receivers.toString(), e);
            }
        }

        void send_1_8(Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count, int ... extra) throws Exception {
            Object packet = this.PacketParticleConstructorResolver.resolve(new Class[][]{{this.EnumParticle, Boolean.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE, int[].class}}).newInstance(ParticleEffect.getEnum(this.EnumParticle.getName() + "." + this.effect.name()), true, Float.valueOf((float)x), Float.valueOf((float)y), Float.valueOf((float)z), Float.valueOf((float)offsetX), Float.valueOf((float)offsetY), Float.valueOf((float)offsetZ), Float.valueOf((float)speed), count, extra);
            for (Player player : receivers) {
                ParticleEffect.sendPacket(packet, player);
            }
        }

        void send_1_7(String name, Collection<? extends Player> receivers, double x, double y, double z, double offsetX, double offsetY, double offsetZ, double speed, int count) throws Exception {
            Object packet = this.PacketParticleConstructorResolver.resolve(new Class[][]{{String.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Integer.TYPE}}).newInstance(name, Float.valueOf((float)x), Float.valueOf((float)y), Float.valueOf((float)z), Float.valueOf((float)offsetX), Float.valueOf((float)offsetY), Float.valueOf((float)offsetZ), Float.valueOf((float)speed), count);
            for (Player player : receivers) {
                ParticleEffect.sendPacket(packet, player);
            }
        }
    }

    public static enum Feature {
        COLOR{

            @Override
            Particle particle(ParticleEffect effect) {
                return new ColoredParticle(effect);
            }
        }
        ,
        DATA{

            @Override
            Particle particle(ParticleEffect effect) {
                return new DataParticle(effect);
            }
        };


        public boolean applies(ParticleEffect particleEffect) {
            return particleEffect.hasFeature(this);
        }

        Particle particle(ParticleEffect effect) {
            return new Particle(effect);
        }
    }
}

