/*
 * Decompiled with CFR 0.152.
 */
package org.inventivetalent.bossbar;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.inventivetalent.apihelper.API;
import org.inventivetalent.apihelper.APIManager;
import org.inventivetalent.bossbar.BossBar;
import org.inventivetalent.bossbar.BossBarPlugin;
import org.inventivetalent.bossbar.BossBarTimer;
import org.inventivetalent.bossbar.EntityBossBar;
import org.inventivetalent.bossbar.PacketBossBar;
import org.inventivetalent.bossbar.reflection.Reflection;
import org.inventivetalent.reflection.minecraft.Minecraft;

public class BossBarAPI
implements API,
Listener {
    protected static final Map<UUID, Collection<BossBar>> barMap = new ConcurrentHashMap<UUID, Collection<BossBar>>();
    public static boolean is1_9 = Minecraft.VERSION.newerThan(Minecraft.Version.v1_9_R1);
    Logger logger = Logger.getLogger("BossBarAPI");

    public static BossBar addBar(Collection<Player> players, String message, Color color, Style style, float progress, Property ... properties) {
        BossBarAPI.validate1_9();
        PacketBossBar bossBar = new PacketBossBar(message, color, style, progress, properties);
        for (Player player : players) {
            BossBarAPI.addBarForPlayer(player, bossBar);
        }
        return bossBar;
    }

    public static BossBar addBar(Collection<Player> players, BaseComponent component, Color color, Style style, float progress, Property ... properties) {
        BossBarAPI.validate1_9();
        PacketBossBar bossBar = new PacketBossBar(component, color, style, progress, properties);
        for (Player player : players) {
            BossBarAPI.addBarForPlayer(player, bossBar);
        }
        return bossBar;
    }

    public static BossBar addBar(Collection<Player> players, BaseComponent component, Color color, Style style, float progress, int timeout, long interval, Property ... properties) {
        BossBarAPI.validate1_9();
        BossBar bossBar = BossBarAPI.addBar(players, component, color, style, progress, properties);
        new BossBarTimer((PacketBossBar)bossBar, progress, timeout).runTaskTimer(BossBarPlugin.instance, interval, interval);
        return bossBar;
    }

    public static BossBar addBar(Player player, BaseComponent component, Color color, Style style, float progress, Property ... properties) {
        if (is1_9) {
            PacketBossBar bossBar = new PacketBossBar(component, color, style, progress, properties);
            BossBarAPI.addBarForPlayer(player, bossBar);
            return bossBar;
        }
        BossBarAPI.setMessage(player, component.toLegacyText(), progress * 100.0f);
        return BossBarAPI.getBossBar(player);
    }

    public static BossBar addBar(Player player, BaseComponent component, Color color, Style style, float progress, int timeout, long interval, Property ... properties) {
        if (is1_9) {
            BossBar bossBar = BossBarAPI.addBar(player, component, color, style, progress, properties);
            new BossBarTimer((PacketBossBar)bossBar, progress, timeout).runTaskTimer(BossBarPlugin.instance, interval, interval);
            return bossBar;
        }
        BossBarAPI.setMessage(player, component.toLegacyText(), progress * 100.0f, timeout);
        return BossBarAPI.getBossBar(player);
    }

    public static BossBar addBar(BaseComponent component, Color color, Style style, float progress, Property ... properties) {
        BossBarAPI.validate1_9();
        return new PacketBossBar(component, color, style, progress, properties);
    }

    public static Collection<BossBar> getBossBars(Player player) {
        if (!barMap.containsKey(player.getUniqueId())) {
            return new ArrayList<BossBar>();
        }
        return new ArrayList<BossBar>(barMap.get(player.getUniqueId()));
    }

    protected static void addBarForPlayer(Player player, BossBar bossBar) {
        bossBar.addPlayer(player);
        Collection<BossBar> collection = barMap.get(player.getUniqueId());
        if (collection == null) {
            collection = new ArrayList<BossBar>();
        }
        collection.add(bossBar);
        barMap.put(player.getUniqueId(), collection);
    }

    protected static void removeBarForPlayer(Player player, BossBar bossBar) {
        bossBar.removePlayer(player);
        Collection<BossBar> collection = barMap.get(player.getUniqueId());
        if (collection != null) {
            collection.remove(bossBar);
            if (!collection.isEmpty()) {
                barMap.put(player.getUniqueId(), collection);
            } else {
                barMap.remove(player.getUniqueId());
            }
        }
    }

    public static void removeAllBars(Player player) {
        for (BossBar bossBar : BossBarAPI.getBossBars(player)) {
            BossBarAPI.removeBarForPlayer(player, bossBar);
        }
    }

    @Deprecated
    public static void setMessage(Player player, String message) {
        BossBarAPI.setMessage(player, message, 100.0f);
    }

    @Deprecated
    public static void setMessage(Player player, String message, float percentage) {
        BossBarAPI.setMessage(player, message, percentage, 0);
    }

    @Deprecated
    public static void setMessage(Player player, String message, float percentage, int timeout) {
        BossBarAPI.setMessage(player, message, percentage, timeout, 100.0f);
    }

    @Deprecated
    public static void setMessage(Player player, String message, float percentage, int timeout, float minHealth) {
        if (is1_9) {
            BossBarAPI.removeAllBars(player);
            BossBarAPI.addBar(player, (BaseComponent)new TextComponent(message), Color.PURPLE, Style.PROGRESS, percentage / 100.0f, new Property[0]);
        } else {
            BossBar bar;
            if (!barMap.containsKey(player.getUniqueId())) {
                ArrayList<EntityBossBar> list = new ArrayList<EntityBossBar>();
                list.add(new EntityBossBar(player, message, percentage, timeout, minHealth));
                barMap.put(player.getUniqueId(), list);
            }
            if (!(bar = (BossBar)((List)barMap.get(player.getUniqueId())).get(0)).getMessage().equals(message)) {
                bar.setMessage(message);
            }
            float newHealth = percentage / 100.0f * bar.getMaxHealth();
            if (bar.getHealth() != newHealth) {
                bar.setHealth(percentage);
            }
            if (!bar.isVisible()) {
                bar.setVisible(true);
            }
        }
    }

    @Deprecated
    public static String getMessage(Player player) {
        BossBar bar = BossBarAPI.getBossBar(player);
        if (bar == null) {
            return null;
        }
        return bar.getMessage();
    }

    @Deprecated
    public static boolean hasBar(Player player) {
        return barMap.containsKey(player.getUniqueId());
    }

    @Deprecated
    public static void removeBar(Player player) {
        BossBar bar = BossBarAPI.getBossBar(player);
        if (bar != null) {
            bar.setVisible(false);
        }
        BossBarAPI.removeAllBars(player);
    }

    @Deprecated
    public static void setHealth(Player player, float percentage) {
        BossBar bar = BossBarAPI.getBossBar(player);
        if (bar == null) {
            return;
        }
        bar.setHealth(percentage);
    }

    @Deprecated
    public static float getHealth(Player player) {
        BossBar bar = BossBarAPI.getBossBar(player);
        if (bar == null) {
            return -1.0f;
        }
        return bar.getHealth();
    }

    @Deprecated
    public static BossBar getBossBar(Player player) {
        if (player == null) {
            return null;
        }
        List list = (List)barMap.get(player.getUniqueId());
        if (list != null && list.size() > 0) {
            return (BossBar)list.get(0);
        }
        return null;
    }

    @Deprecated
    public static Collection<BossBar> getBossBars() {
        ArrayList<BossBar> list = new ArrayList<BossBar>();
        for (Collection<BossBar> collection : barMap.values()) {
            list.add((BossBar)((List)collection).get(0));
        }
        return list;
    }

    protected static void sendPacket(Player p, Object packet) {
        if (p == null || packet == null) {
            throw new IllegalArgumentException("player and packet cannot be null");
        }
        try {
            Object handle = Reflection.getHandle(p);
            Object connection = Reflection.getField(handle.getClass(), "playerConnection").get(handle);
            Reflection.getMethod(connection.getClass(), "sendPacket", Reflection.getNMSClass("Packet")).invoke(connection, packet);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void validate1_9() {
        if (!is1_9) {
            throw new RuntimeException(new UnsupportedOperationException("This method is not compatible with versions < 1.9"));
        }
    }

    @Override
    public void load() {
    }

    @Override
    public void init(Plugin plugin) {
        APIManager.registerEvents(this, this);
        BossBarPlugin.instance = APIManager.getAPIHost(this);
        for (Player player : Bukkit.getOnlinePlayers()) {
            BossBarAPI.removeAllBars(player);
        }
    }

    @Override
    public void disable(Plugin plugin) {
    }

    @EventHandler
    public void onPluginEnable(PluginEnableEvent e) {
        if ("BarAPI".equals(e.getPlugin().getName()) && Bukkit.getPluginManager().isPluginEnabled("BarAPI")) {
            try {
                Class<?> barAPI = Class.forName("me.confuser.barapi.BarAPI");
                Method method = barAPI.getDeclaredMethod("enabled", new Class[0]);
                method.setAccessible(true);
                if (((Boolean)method.invoke(null, new Object[0])).booleanValue()) {
                    this.logger.info("Successfully replaced BarAPI.");
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.logger.warning("Failed to replace BarAPI.");
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onQuit(PlayerQuitEvent e) {
        BossBarAPI.removeBar(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onKick(PlayerKickEvent e) {
        BossBarAPI.removeBar(e.getPlayer());
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onTeleport(PlayerTeleportEvent e) {
        if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_9_R1)) {
            this.handlePlayerTeleport(e.getPlayer(), e.getFrom(), e.getTo());
        }
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onRespawn(PlayerRespawnEvent e) {
        if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_9_R1)) {
            this.handlePlayerTeleport(e.getPlayer(), e.getPlayer().getLocation(), e.getRespawnLocation());
        }
    }

    protected void handlePlayerTeleport(Player player, Location from, Location to) {
        if (!BossBarAPI.hasBar(player)) {
            return;
        }
        final BossBar bar = BossBarAPI.getBossBar(player);
        bar.setVisible(false);
        new BukkitRunnable(){

            public void run() {
                bar.setVisible(true);
            }
        }.runTaskLater(APIManager.getAPIHost(this), 2L);
    }

    @EventHandler
    public void onMove(final PlayerMoveEvent e) {
        BossBar bar;
        if (Minecraft.VERSION.olderThan(Minecraft.Version.v1_9_R1) && (bar = BossBarAPI.getBossBar(e.getPlayer())) != null) {
            new BukkitRunnable(){

                public void run() {
                    if (!e.getPlayer().isOnline()) {
                        return;
                    }
                    bar.updateMovement();
                }
            }.runTaskLater(APIManager.getAPIHost(this), 0L);
        }
    }

    public static enum Property {
        DARKEN_SKY,
        PLAY_MUSIC,
        CREATE_FOG;

    }

    public static enum Style {
        PROGRESS,
        NOTCHED_6,
        NOTCHED_10,
        NOTCHED_12,
        NOTCHED_20;

    }

    public static enum Color {
        PINK,
        BLUE,
        RED,
        GREEN,
        YELLOW,
        PURPLE,
        WHITE;

    }
}

