/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.socket;

import java.io.ObjectOutputStream;
import java.util.List;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.utils.packets.PacketType;
import me.cubixor.sheepquest.utils.packets.classes.ArenaPacket;
import me.cubixor.sheepquest.utils.packets.classes.ArenaPlayerPacket;
import me.cubixor.sheepquest.utils.packets.classes.BackToServerPacket;
import me.cubixor.sheepquest.utils.packets.classes.JoinPacket;
import me.cubixor.sheepquest.utils.packets.classes.KickPacket;
import me.cubixor.sheepquest.utils.packets.classes.ServerArenasPacket;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SocketClientSender {
    private final SheepQuest plugin = SheepQuest.getInstance();

    private ObjectOutputStream getOutputStream() {
        try {
            return this.plugin.getBungeeSocket().getOutputStream();
        }
        catch (Exception e) {
            return null;
        }
    }

    public void sendJoinPacket(Arena arena, String player, boolean joinServer, boolean localJoin) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                ObjectOutputStream out = this.getOutputStream();
                if (out == null) {
                    return;
                }
                JoinPacket joinPacket = new JoinPacket(arena, player, joinServer, localJoin);
                out.writeObject(joinPacket);
                out.flush();
                out.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void sendArenasPacket(String server, List<Arena> arenas) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                ObjectOutputStream out = this.getOutputStream();
                if (out == null) {
                    return;
                }
                ServerArenasPacket serverArenasPacket = new ServerArenasPacket(PacketType.SERVER_ARENAS_ADD, server, arenas);
                out.writeObject(serverArenasPacket);
                out.flush();
                out.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void sendUpdateArenaPacket(Arena arena) {
        try {
            ObjectOutputStream out = this.getOutputStream();
            if (out == null) {
                return;
            }
            ArenaPacket arenaPacket = new ArenaPacket(PacketType.ARENA_UPDATE, arena);
            out.writeObject(arenaPacket);
            out.flush();
            out.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendRemoveArenaPacket(Arena arena) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                ObjectOutputStream out = this.getOutputStream();
                if (out == null) {
                    return;
                }
                ArenaPacket arenaPacket = new ArenaPacket(PacketType.ARENA_REMOVE, arena);
                out.writeObject(arenaPacket);
                out.flush();
                out.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void sendBackToServerPacket(BackToServerPacket.ServerPriority serverPriority, String player, String lobby) {
        try {
            ObjectOutputStream out = this.getOutputStream();
            if (out == null) {
                return;
            }
            BackToServerPacket backToServerPacket = new BackToServerPacket(serverPriority, player, lobby);
            out.writeObject(backToServerPacket);
            out.flush();
            out.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendForceStartPacket(String player, Arena arena) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                ObjectOutputStream out = this.getOutputStream();
                if (out == null) {
                    return;
                }
                ArenaPlayerPacket arenaPlayerPacket = new ArenaPlayerPacket(PacketType.FORCE_START, arena, player);
                out.writeObject(arenaPlayerPacket);
                out.flush();
                out.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void sendForceStopPacket(String player, Arena arena) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                ObjectOutputStream out = this.getOutputStream();
                if (out == null) {
                    return;
                }
                ArenaPlayerPacket arenaPlayerPacket = new ArenaPlayerPacket(PacketType.FORCE_STOP, arena, player);
                out.writeObject(arenaPlayerPacket);
                out.flush();
                out.reset();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    public void sendKickPacket(String player, String target, Arena arena) {
        try {
            ObjectOutputStream out = this.getOutputStream();
            if (out == null) {
                return;
            }
            KickPacket kickPacket = new KickPacket(player, target, arena);
            out.writeObject(kickPacket);
            out.flush();
            out.reset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

