/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.mysql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.mysql.MysqlConnection;
import org.bukkit.ChatColor;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ConnectionSetup {
    private final SheepQuest plugin = SheepQuest.getInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectToDatabase(MysqlConnection mysqlConnection) {
        try {
            Connection connection = mysqlConnection.getConnection();
            if (this.plugin.getMysqlConnection() != null && connection != null && !connection.isClosed()) {
                connection.close();
            }
            ConnectionSetup connectionSetup = this;
            synchronized (connectionSetup) {
                PreparedStatement statement2;
                PreparedStatement statement1;
                try {
                    Class.forName("com.mysql.cj.jdbc.Driver");
                }
                catch (ClassNotFoundException e) {
                    try {
                        Class.forName("com.mysql.jdbc.Driver");
                    }
                    catch (ClassNotFoundException e2) {
                        e2.printStackTrace();
                    }
                }
                mysqlConnection.setConnection(DriverManager.getConnection("jdbc:mysql://" + mysqlConnection.getHost() + ":" + mysqlConnection.getPort() + "/" + mysqlConnection.getDatabase() + "?autoReconnect=true&useSSL=false", mysqlConnection.getUsername(), mysqlConnection.getPassword()));
                this.plugin.setMysqlConnection(mysqlConnection);
                if (this.plugin.getConfig().getBoolean("database.enabled-stats")) {
                    statement1 = mysqlConnection.getConnection().prepareStatement("CREATE DATABASE IF NOT EXISTS " + mysqlConnection.getDatabase());
                    statement1.executeUpdate();
                    statement2 = mysqlConnection.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS " + mysqlConnection.getDatabase() + "." + mysqlConnection.getTableStats() + "( `player` VARCHAR(14) NOT NULL ,  `kills` INT NOT NULL DEFAULT '0' ,  `deaths` INT NOT NULL DEFAULT '0' ,  `wins` INT NOT NULL DEFAULT '0' ,  `looses` INT NOT NULL DEFAULT '0' ,  `games-played` INT NOT NULL DEFAULT '0' ,  `sheep-taken` INT NOT NULL DEFAULT '0' ,  `bonus-sheep-taken` INT NOT NULL DEFAULT '0' , `playtime` INT NOT NULL DEFAULT '0' , PRIMARY KEY  (`player`)) ENGINE = InnoDB;");
                    statement2.executeUpdate();
                }
                if (this.plugin.getConfig().getBoolean("database.enabled-arenas")) {
                    statement1 = mysqlConnection.getConnection().prepareStatement("CREATE DATABASE IF NOT EXISTS " + mysqlConnection.getDatabase());
                    statement1.executeUpdate();
                    statement2 = mysqlConnection.getConnection().prepareStatement("CREATE TABLE IF NOT EXISTS `" + mysqlConnection.getDatabase() + "`.`" + mysqlConnection.getTableArenas() + "` ( `name` VARCHAR(14)  , `server` TEXT NULL DEFAULT NULL , `active` BOOLEAN NULL DEFAULT '0' , `vip` BOOLEAN NULL DEFAULT '0' , `min-players` INT NULL DEFAULT '0' ,  `max-players` INT NULL DEFAULT '0' ,    PRIMARY KEY  (`name`(14))) ENGINE = InnoDB;");
                    statement2.executeUpdate();
                }
                this.pingDatabase(this.plugin.getConfig().getInt("database.ping-period"));
                this.plugin.getLogger().info(ChatColor.GREEN + "Successfully connected to a mysql server!");
                return true;
            }
        }
        catch (SQLException e) {
            this.plugin.getLogger().severe(ChatColor.RED + "Plugin couldn't connect to mysql database using provided login data. Check if they are correct and if mysql server is working properly and then restart the spigot server.");
            e.printStackTrace();
            return false;
        }
    }

    public MysqlConnection mysqlSetup() {
        MysqlConnection mysqlConnection = new MysqlConnection();
        mysqlConnection.setHost(this.plugin.getConfig().getString("database.host"));
        mysqlConnection.setPort(this.plugin.getConfig().getString("database.port"));
        mysqlConnection.setDatabase(this.plugin.getConfig().getString("database.database"));
        mysqlConnection.setUsername(this.plugin.getConfig().getString("database.username"));
        mysqlConnection.setPassword(this.plugin.getConfig().getString("database.password"));
        mysqlConnection.setTableStats(this.plugin.getConfig().getString("database.table-stats"));
        mysqlConnection.setTableArenas(this.plugin.getConfig().getString("database.table-arenas"));
        return mysqlConnection;
    }

    public void pingDatabase(int period) {
        new BukkitRunnable(){

            public void run() {
                try {
                    if (!ConnectionSetup.this.plugin.isEnabled() || ConnectionSetup.this.plugin.getMysqlConnection().getConnection().isClosed()) {
                        this.cancel();
                        return;
                    }
                    MysqlConnection mysqlConnection = ConnectionSetup.this.plugin.getMysqlConnection();
                    Connection connection = mysqlConnection.getConnection();
                    PreparedStatement statement = connection.prepareStatement("/* ping */ SELECT 1");
                    statement.execute();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.cancel();
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, (long)period * 20L);
    }
}

