/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.gameInfo;

import java.io.Serializable;
import java.util.HashMap;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.api.BossBar;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.game.Scoreboards;
import me.cubixor.sheepquest.spigot.game.events.SpecialEventsData;
import me.cubixor.sheepquest.spigot.game.kits.KitType;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.PlayerData;
import me.cubixor.sheepquest.spigot.gameInfo.PlayerGameStats;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import me.cubixor.sheepquest.spigot.gameInfo.TeamRegion;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.scoreboard.Scoreboard;

public class LocalArena
extends Arena
implements Serializable {
    private int timer = -1;
    private int sheepTimer;
    private Inventory teamChooseInv;
    private SpecialEventsData specialEventsData;
    private final HashMap<Player, Team> playerTeam = new HashMap();
    private final HashMap<Player, KitType> playerKit = new HashMap();
    private final HashMap<Team, Integer> points = new HashMap();
    private final HashMap<Entity, BukkitTask> sheep = new HashMap();
    private final HashMap<Player, Integer> respawnTimer = new HashMap();
    private final HashMap<Player, PlayerGameStats> playerStats = new HashMap();
    private final HashMap<Team, BossBar> teamBossBars = new HashMap();
    private final HashMap<Player, PlayerData> playerData = new HashMap();
    private final HashMap<Team, TeamRegion> teamRegions = new HashMap();
    private final HashMap<Player, Scoreboard> playerScoreboards = new HashMap();

    public LocalArena(String name) {
        super(name, SheepQuest.getInstance().getServerName());
        SheepQuest plugin = SheepQuest.getInstance();
        int invSlots = ConfigUtils.getTeamList(name).size() > 9 ? 18 : 9;
        this.setTeamChooseInv(Bukkit.createInventory(null, (int)invSlots, (String)plugin.getMessage("game.team-menu-name")));
        for (Team team : ConfigUtils.getTeamList(name)) {
            this.getTeamBossBars().put(team, new BossBar(plugin.getMessage("game.bossbar-team").replace("%team%", team.getName()), team));
            this.getTeamRegions().put(team, new TeamRegion(name, team));
        }
        this.getTeamBossBars().put(Team.NONE, new BossBar(plugin.getMessage("game.bossbar-team").replace("%team%", Team.NONE.getName()), Team.NONE));
        this.getTeamRegions().put(Team.NONE, new TeamRegion(name, Team.NONE));
    }

    public HashMap<Player, Team> getPlayerTeam() {
        return this.playerTeam;
    }

    public int getTimer() {
        return this.timer;
    }

    public void setTimer(int timer) {
        this.timer = timer;
    }

    public int getSheepTimer() {
        return this.sheepTimer;
    }

    public void setSheepTimer(int sheepTimer) {
        this.sheepTimer = sheepTimer;
    }

    public Inventory getTeamChooseInv() {
        return this.teamChooseInv;
    }

    public void setTeamChooseInv(Inventory teamChooseInv) {
        this.teamChooseInv = teamChooseInv;
    }

    public HashMap<Team, Integer> getPoints() {
        return this.points;
    }

    public HashMap<Entity, BukkitTask> getSheep() {
        return this.sheep;
    }

    public HashMap<Player, Integer> getRespawnTimer() {
        return this.respawnTimer;
    }

    public HashMap<Player, PlayerGameStats> getPlayerStats() {
        return this.playerStats;
    }

    public HashMap<Team, BossBar> getTeamBossBars() {
        return this.teamBossBars;
    }

    public SpecialEventsData getSpecialEventsData() {
        return this.specialEventsData;
    }

    public void setSpecialEventsData(SpecialEventsData specialEventsData) {
        this.specialEventsData = specialEventsData;
    }

    public HashMap<Player, PlayerData> getPlayerData() {
        return this.playerData;
    }

    public HashMap<Player, KitType> getPlayerKit() {
        return this.playerKit;
    }

    public HashMap<Team, TeamRegion> getTeamRegions() {
        return this.teamRegions;
    }

    public HashMap<Player, Scoreboard> getPlayerScoreboards() {
        return this.playerScoreboards;
    }

    public void setState(GameState state) {
        this.setGameState(state);
        new Scoreboards().changeScoreboardSize(this);
    }
}

