/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game.kits;

import java.util.ArrayList;
import java.util.List;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.Particles;
import me.cubixor.sheepquest.spigot.api.Sounds;
import me.cubixor.sheepquest.spigot.api.VersionUtils;
import me.cubixor.sheepquest.spigot.game.Kill;
import me.cubixor.sheepquest.spigot.game.SheepCarrying;
import me.cubixor.sheepquest.spigot.game.events.BonusEntity;
import me.cubixor.sheepquest.spigot.game.kits.Kit;
import me.cubixor.sheepquest.spigot.game.kits.KitType;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import org.bukkit.Bukkit;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;

public class KitAthlete
extends Kit
implements Listener {
    public KitAthlete() {
        super(KitType.ATHLETE);
    }

    @Override
    public void giveKit(Player player) {
        this.giveItems(player);
    }

    @EventHandler
    public void onThrow(PlayerInteractEvent evt) {
        Player player = evt.getPlayer();
        LocalArena localArena = Utils.getLocalArena(player);
        if (!(VersionUtils.is1_8() || evt.getHand() != null && evt.getHand().equals((Object)EquipmentSlot.HAND))) {
            return;
        }
        if (evt.getItem() != null && localArena != null && localArena.getState().equals(GameState.GAME) && localArena.getPlayerKit().get(player).equals((Object)KitType.ATHLETE)) {
            if (this.plugin.getConfig().getBoolean("kits.athlete.throw-sheep") && evt.getItem().equals((Object)this.plugin.getItems().getSheepItem()) && player.getPassenger() != null && player.getPassenger().getType().equals((Object)EntityType.SHEEP) && !BonusEntity.isCarrying((LivingEntity)((Sheep)player.getPassenger()))) {
                List<Entity> sheep = Utils.removeSheep(player);
                this.throwSheep(localArena.getName(), sheep, player);
            } else if (this.plugin.getConfig().getBoolean("kits.athlete.launch-players") && evt.getItem().equals((Object)this.getSecondaryWeapon())) {
                this.launchNearbyPlayers(player, localArena);
            }
        }
    }

    private void throwSheep(final String arena, List<Entity> entityList, final Player player) {
        LocalArena localArena = this.plugin.getLocalArenas().get(arena);
        Entity firstEntity = entityList.get(0);
        final Team team = localArena.getPlayerTeam().get(player);
        Sounds.playSound(localArena, firstEntity.getLocation(), "throw-sheep");
        Particles.spawnParticle(localArena, firstEntity.getLocation().add(0.0, 1.5, 0.0), "throw-sheep");
        for (final Entity e : entityList) {
            e.setVelocity(player.getLocation().getDirection().add(new Vector(0.0, this.plugin.getConfig().getDouble("kits.athlete.throw-sheep-power-y"), 0.0)).multiply(this.plugin.getConfig().getDouble("kits.athlete.throw-sheep-power")));
            new BukkitRunnable(){

                public void run() {
                    LocalArena localArena = KitAthlete.this.plugin.getLocalArenas().get(arena);
                    if (!localArena.getState().equals(GameState.GAME)) {
                        this.cancel();
                        return;
                    }
                    if (e.isOnGround()) {
                        if (Utils.isInRegion(e, localArena, team)) {
                            new SheepCarrying().sheepBring(player, (LivingEntity)e);
                        }
                        KitAthlete.this.damageNearbyEntities(e, KitAthlete.this.plugin.getConfig().getDouble("kits.athlete.throw-sheep-damage"), player, localArena);
                        this.cancel();
                    }
                }
            }.runTaskTimer((Plugin)this.plugin, 0L, 1L);
        }
    }

    private void launchNearbyPlayers(Player player, LocalArena localArena) {
        if (this.plugin.getPlayerInfo().get(player).isAthleteCooldown()) {
            return;
        }
        Team team = localArena.getPlayerTeam().get(player);
        double range = this.plugin.getConfig().getDouble("kits.athlete.launch-players-range");
        double power = this.plugin.getConfig().getDouble("kits.athlete.launch-players-power");
        double powerY = this.plugin.getConfig().getDouble("kits.athlete.launch-players-power-y");
        double damage = this.plugin.getConfig().getDouble("kits.athlete.launch-players-damage");
        double cooldown = this.plugin.getConfig().getDouble("kits.athlete.launch-players-cooldown");
        Sounds.playSound(localArena, player.getLocation(), "launch-players");
        Particles.spawnParticle(localArena, player.getLocation().add(0.0, 1.5, 0.0), "launch-players");
        for (Entity targetEntity : player.getNearbyEntities(range, range, range)) {
            if (!targetEntity.getType().equals((Object)EntityType.PLAYER)) continue;
            Player target = (Player)targetEntity;
            if (localArena.getPlayerTeam().get(target).equals((Object)team)) continue;
            Vector direction = target.getLocation().toVector().subtract(player.getLocation().toVector()).normalize().add(new Vector(0.0, powerY, 0.0)).multiply(power);
            target.setVelocity(direction);
            if (target.getHealth() - damage > 0.0) {
                target.damage(damage);
            }
            new Kill().damagePlayer(target, player, localArena, damage);
        }
        this.addCooldown(player, cooldown);
    }

    private void damageNearbyEntities(Entity entity, double damage, Player damager, LocalArena localArena) {
        ArrayList entities = new ArrayList(entity.getNearbyEntities(1.0, 1.0, 1.0));
        for (Entity e : entities) {
            if (!e.getType().equals((Object)EntityType.PLAYER)) continue;
            Player p = (Player)e;
            if (localArena.getPlayerTeam().get(damager).equals((Object)localArena.getPlayerTeam().get(p))) continue;
            p.damage(damage);
            if (!new Kill().damagePlayer(p, damager, Utils.getLocalArena(damager), damage)) continue;
            p.setHealth(20.0);
        }
    }

    public void addCooldown(Player player, double cooldown) {
        if (this.plugin.getPlayerInfo().get(player).isAthleteCooldown()) {
            return;
        }
        this.plugin.getPlayerInfo().get(player).setAthleteCooldown(true);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            if (this.plugin.getPlayerInfo().get(player) != null) {
                this.plugin.getPlayerInfo().get(player).setAthleteCooldown(false);
            }
        }, Math.round(cooldown * 20.0));
    }
}

