/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game.events;

import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.Particles;
import me.cubixor.sheepquest.spigot.api.PassengerFix;
import me.cubixor.sheepquest.spigot.api.Sounds;
import me.cubixor.sheepquest.spigot.config.ConfigField;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.game.Pathfinding;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import org.bukkit.DyeColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;

public class BonusEntity {
    private final SheepQuest plugin = SheepQuest.getInstance();

    public static boolean isCarrying(LivingEntity entity) {
        SheepQuest plugin = SheepQuest.getInstance();
        if (entity.getType().equals((Object)EntityType.SHEEP)) {
            return ((Sheep)entity).getColor().equals((Object)DyeColor.valueOf((String)plugin.getConfig().getString("special-events.bonus-sheep.color")));
        }
        return entity.getType().toString().equalsIgnoreCase(plugin.getConfig().getString("special-events.bonus-sheep.entity-type"));
    }

    public void spawnEntity(LocalArena localArena) {
        String arenaString = localArena.getName();
        Location loc = ConfigUtils.getLocation(arenaString, ConfigField.SHEEP_SPAWN);
        LivingEntity entity = (LivingEntity)loc.getWorld().spawn(loc, EntityType.valueOf((String)this.plugin.getConfig().getString("special-events.bonus-sheep.entity-type")).getEntityClass());
        if (entity.getType().equals((Object)EntityType.SHEEP)) {
            ((Sheep)entity).setColor(DyeColor.valueOf((String)this.plugin.getConfig().getString("special-events.bonus-sheep.color")));
        }
        entity.setCustomName(this.plugin.getMessage("special-events.bonus-sheep-name").replace("%points%", this.plugin.getConfig().getString("special-events.bonus-sheep.points")));
        entity.setCustomNameVisible(true);
        localArena.getSpecialEventsData().getBonusEntityTeam().put((Entity)entity, Team.NONE);
        Sounds.playSound(localArena, loc, "bonus-sheep-spawn");
        Particles.spawnParticle(localArena, loc.add(0.0, 1.5, 0.0), "bonus-sheep-spawn");
        Pathfinding.walkToLocation(entity, loc, this.plugin.getConfig().getDouble("special-events.bonus-sheep.speed"), localArena, Team.NONE);
        for (Player p : localArena.getPlayerTeam().keySet()) {
            p.sendMessage(this.plugin.getMessage("special-events.bonus-sheep-spawn"));
        }
    }

    public void bringEntity(Player player, LivingEntity entity) {
        LocalArena localArena = Utils.getLocalArena(player);
        Team team = localArena.getPlayerTeam().get(player);
        int points = this.plugin.getConfig().getInt("special-events.bonus-sheep.points");
        player.removePotionEffect(PotionEffectType.SLOW);
        Pathfinding.walkToLocation(entity, Pathfinding.getMiddleArea(localArena.getName(), team), this.plugin.getConfig().getDouble("special-events.bonus-sheep.speed"), localArena, team);
        for (Team t : Utils.getTeams()) {
            if (team.equals((Object)t) || !localArena.getSpecialEventsData().getBonusEntityTeam().get(entity).equals((Object)t)) continue;
            localArena.getPoints().replace(t, localArena.getPoints().get((Object)t) - points);
        }
        localArena.getPoints().replace(team, localArena.getPoints().get((Object)team) + points);
        localArena.getSpecialEventsData().getBonusEntityTeam().put((Entity)entity, team);
        localArena.getPlayerStats().get(player).setBonusSheepTaken(localArena.getPlayerStats().get(player).getBonusSheepTaken() + 1);
        Sounds.playSound(localArena, player.getLocation(), "bonus-sheep-bring");
        Particles.spawnParticle(localArena, player.getLocation().add(0.0, 1.5, 0.0), "bonus-sheep-bring");
    }

    public boolean pickupEntity(Player player, LivingEntity entity) {
        if (BonusEntity.isCarrying(entity)) {
            LocalArena localArena = Utils.getLocalArena(player);
            if (!localArena.getSpecialEventsData().getBonusEntityTeam().get(entity).equals((Object)localArena.getPlayerTeam().get(player)) && player.getPassenger() == null) {
                player.setPassenger((Entity)entity);
                if (player.getPassenger() != null) {
                    Sounds.playSound(player, player.getLocation(), "sheep-pick");
                    if (this.plugin.getConfig().getBoolean("effects.sheep-slowness")) {
                        player.removePotionEffect(PotionEffectType.SLOW);
                        player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 9999999, 2, false, false));
                    }
                    this.carryingParticles(player, entity);
                    PassengerFix.updatePassengers(player);
                }
            }
            return true;
        }
        return false;
    }

    public void carryingParticles(final Player player, final LivingEntity entity) {
        new BukkitRunnable(){

            public void run() {
                if (Utils.getLocalArena(player) == null || player.getPassenger() == null || !player.getPassenger().equals(entity)) {
                    this.cancel();
                    return;
                }
                Particles.spawnParticle(Utils.getLocalArena(player), player.getLocation().add(0.0, 3.5, 0.0), "bonus-sheep-carrying");
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 10L);
    }
}

