/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game;

import com.cryptomorin.xseries.XBlock;
import java.util.ArrayList;
import java.util.List;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.VersionUtils;
import me.cubixor.sheepquest.spigot.commands.PlayCommands;
import me.cubixor.sheepquest.spigot.config.ConfigField;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.game.Cooldown;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockState;
import org.bukkit.block.Sign;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class Signs
implements Listener {
    private final SheepQuest plugin = SheepQuest.getInstance();

    @EventHandler
    public void signCreate(SignChangeEvent evt) {
        Sign sign = (Sign)evt.getBlock().getState();
        if (evt.getLine(0) == null || evt.getLine(1) == null || !evt.getLine(0).equalsIgnoreCase("[sheepquest]") || !evt.getPlayer().hasPermission("sheepquest.setup.signs")) {
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!ConfigUtils.getArenas().contains(evt.getLine(1)) && !evt.getLine(1).equalsIgnoreCase("quickjoin")) {
                return;
            }
            String arena = evt.getLine(1);
            ArrayList<String> signList = new ArrayList<String>(this.getSignList(arena));
            signList.add(ConfigUtils.locationToString(sign.getBlock().getLocation()));
            this.plugin.getArenasConfig().set("signs." + arena, signList);
            this.plugin.saveArenas();
            this.plugin.getSigns().get(arena).add(sign.getLocation());
            evt.setCancelled(true);
            this.updateSign(sign.getLocation(), arena);
        });
    }

    @EventHandler
    public void signBreak(BlockBreakEvent evt) {
        if (!evt.getBlock().getType().toString().contains("SIGN")) {
            return;
        }
        Sign sign = (Sign)evt.getBlock().getState();
        String arena = this.arenaSign(sign);
        if (arena == null) {
            return;
        }
        if (!evt.getPlayer().isSneaking()) {
            evt.setCancelled(true);
            return;
        }
        if (!evt.getPlayer().hasPermission("sheepquest.setup.signs")) {
            evt.getPlayer().sendMessage(this.plugin.getMessage("general.no-permission"));
            evt.setCancelled(true);
            return;
        }
        this.removeSign(arena, sign.getLocation());
    }

    public void removeSigns(String arena) {
        for (Location location : this.plugin.getSigns().get(arena)) {
            this.removeSignBlock(location.getBlock());
        }
        this.plugin.getSigns().remove(arena);
        this.plugin.getArenasConfig().set("signs." + arena, null);
        this.plugin.saveArenas();
    }

    private void removeSign(String arena, Location location) {
        this.plugin.getSigns().get(arena).remove(location);
        ArrayList<String> signList = new ArrayList<String>(this.getSignList(arena));
        signList.remove(ConfigUtils.locationToString(location));
        this.plugin.getArenasConfig().set("signs." + arena, signList);
        this.plugin.saveArenas();
    }

    private void removeSignBlock(Block sign) {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            try {
                Block block = this.getAttachedBlock(sign);
                if (sign.getType().toString().contains("SIGN")) {
                    sign.setType(Material.AIR);
                    if (this.plugin.getConfig().getBoolean("color-signs")) {
                        block.setType(Material.AIR);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
    }

    @EventHandler
    public void signClick(PlayerInteractEvent evt) {
        if (!(VersionUtils.is1_8() || evt.getHand() != null && evt.getHand().equals((Object)EquipmentSlot.HAND))) {
            return;
        }
        if (evt.getClickedBlock() == null) {
            return;
        }
        if (evt.getClickedBlock() == null || evt.getPlayer().isSneaking()) {
            return;
        }
        if (!evt.getClickedBlock().getType().toString().contains("SIGN")) {
            return;
        }
        Sign sign = (Sign)evt.getClickedBlock().getState();
        String arena = this.arenaSign(sign);
        if (arena == null) {
            return;
        }
        if (Cooldown.checkCooldown(evt.getPlayer())) {
            return;
        }
        Cooldown.addCooldown(evt.getPlayer());
        if (!evt.getPlayer().hasPermission("sheepquest.play.signs")) {
            evt.getPlayer().sendMessage(this.plugin.getMessage("general.no-permission"));
            return;
        }
        evt.setCancelled(true);
        if (arena.equals("quickjoin")) {
            new PlayCommands().quickJoin(evt.getPlayer());
        } else {
            new PlayCommands().join(evt.getPlayer(), new String[]{"join", arena});
        }
    }

    public void updateSigns(String arena) {
        if (this.plugin.getSigns().get(arena) != null) {
            ArrayList signList = new ArrayList(this.plugin.getSigns().get(arena));
            for (Location location : signList) {
                this.updateSign(location, arena);
            }
        }
    }

    private void updateSign(Location location, String arenaString) {
        if (arenaString.equals("quickjoin")) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Sign sign;
                try {
                    Block block = location.getBlock();
                    sign = (Sign)block.getState();
                    if (!block.getType().toString().contains("SIGN")) {
                        this.removeSign(arenaString, location);
                        return;
                    }
                }
                catch (Exception e) {
                    this.removeSign(arenaString, location);
                    return;
                }
                sign.setLine(0, this.plugin.getMessage("other.sign-quickjoin-first-line").replace("%count%", Integer.toString(this.plugin.getAllArenas().size())));
                sign.setLine(1, this.plugin.getMessage("other.sign-quickjoin-second-line").replace("%count%", Integer.toString(this.plugin.getAllArenas().size())));
                sign.setLine(2, this.plugin.getMessage("other.sign-quickjoin-third-line").replace("%count%", Integer.toString(this.plugin.getAllArenas().size())));
                sign.setLine(3, this.plugin.getMessage("other.sign-quickjoin-fourth-line").replace("%count%", Integer.toString(this.plugin.getAllArenas().size())));
                sign.update(true);
            });
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            Arena arena = this.plugin.getArena(arenaString);
            String max = Integer.toString(ConfigUtils.getInt(arenaString, ConfigField.MAX_PLAYERS));
            String gameState = Utils.getStringState(arena);
            String vip = ConfigUtils.getBoolean(arenaString, ConfigField.VIP) ? this.plugin.getMessage("general.vip-prefix") : "";
            String count = arena != null ? Integer.toString(arena.getPlayers().size()) : "0";
            ItemStack blockType = Utils.setGlassColor(arena);
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Sign sign;
                Block block;
                try {
                    block = location.getBlock();
                    sign = (Sign)block.getState();
                    if (!block.getType().toString().contains("SIGN")) {
                        this.removeSign(arenaString, location);
                        return;
                    }
                }
                catch (Exception e) {
                    this.removeSign(arenaString, location);
                    return;
                }
                if (this.plugin.getConfig().getBoolean("color-signs")) {
                    Block attachedBlock = this.getAttachedBlock(block);
                    attachedBlock.setType(blockType.getType());
                    BlockState state = attachedBlock.getState();
                    state.setData(blockType.getData());
                    state.update();
                }
                sign.setLine(0, this.plugin.getMessage("other.sign-first-line").replace("%arena%", arenaString).replace("%count%", count).replace("%max%", max).replace("%state%", gameState).replace("%?vip?%", vip));
                sign.setLine(1, this.plugin.getMessage("other.sign-second-line").replace("%arena%", arenaString).replace("%count%", count).replace("%max%", max).replace("%state%", gameState).replace("%?vip?%", vip));
                sign.setLine(2, this.plugin.getMessage("other.sign-third-line").replace("%arena%", arenaString).replace("%count%", count).replace("%max%", max).replace("%state%", gameState).replace("%?vip?%", vip));
                sign.setLine(3, this.plugin.getMessage("other.sign-fourth-line").replace("%arena%", arenaString).replace("%count%", count).replace("%max%", max).replace("%state%", gameState).replace("%?vip?%", vip));
                sign.update(true);
            });
        });
    }

    private Block getAttachedBlock(Block block) {
        Block attachedBlock = block.getType().toString().contains("WALL") ? block.getRelative(XBlock.getDirection(block).getOppositeFace()) : block.getRelative(BlockFace.DOWN);
        return attachedBlock;
    }

    public void loadSigns() {
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
            if (this.plugin.getArenasConfig().getConfigurationSection("signs") == null) {
                return;
            }
            for (String arena : this.plugin.getArenasConfig().getConfigurationSection("signs").getKeys(false)) {
                this.loadArenaSigns(arena);
                this.updateSigns(arena);
            }
        });
    }

    public void loadArenaSigns(String arena) {
        if (this.plugin.getArenasConfig().get("signs." + arena) == null) {
            return;
        }
        for (String locStr : this.plugin.getArenasConfig().getStringList("signs." + arena)) {
            Location loc = ConfigUtils.stringToLocation(locStr);
            try {
                loc.getBlock().getState();
                this.plugin.getSigns().get(arena).add(loc);
            }
            catch (Exception ex) {
                ArrayList<String> signList = new ArrayList<String>(this.getSignList(arena));
                signList.remove(locStr);
                this.plugin.getArenasConfig().set("signs." + arena, signList);
                this.plugin.saveArenas();
            }
        }
    }

    private String arenaSign(Sign sign) {
        for (String arena : this.plugin.getSigns().keySet()) {
            if (!this.plugin.getSigns().get(arena).contains(sign.getLocation())) continue;
            return arena;
        }
        return null;
    }

    private List<String> getSignList(String arena) {
        ArrayList<String> signList = new ArrayList<String>();
        if (this.plugin.getArenasConfig().getList("signs." + arena) != null) {
            signList.addAll(this.plugin.getArenasConfig().getStringList("signs." + arena));
        }
        return signList;
    }
}

