/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game;

import com.cryptomorin.xseries.XSound;
import com.cryptomorin.xseries.messages.Titles;
import java.util.ArrayList;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.Particles;
import me.cubixor.sheepquest.spigot.api.Sounds;
import me.cubixor.sheepquest.spigot.api.VersionUtils;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.game.kits.KitType;
import me.cubixor.sheepquest.spigot.game.kits.Kits;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.PlayerItemDamageEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.material.MaterialData;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.scheduler.BukkitRunnable;
import org.inventivetalent.particle.ParticleEffect;

public class Kill
implements Listener {
    private final SheepQuest plugin = SheepQuest.getInstance();

    @EventHandler
    public void onItemDamage(PlayerItemDamageEvent evt) {
        if (Utils.getLocalArena(evt.getPlayer()) != null) {
            evt.setCancelled(true);
            evt.getPlayer().updateInventory();
        }
    }

    @EventHandler
    public void onDamage(EntityDamageByEntityEvent evt) {
        Player attacker;
        if (!evt.getEntity().getType().equals((Object)EntityType.PLAYER)) {
            return;
        }
        if (!(evt.getDamager().getType().equals((Object)EntityType.PLAYER) || evt.getDamager() instanceof Projectile && ((Projectile)evt.getDamager()).getShooter() instanceof Player)) {
            return;
        }
        Player player = (Player)evt.getEntity();
        LocalArena localArena = Utils.getLocalArena(player);
        if (evt.getDamager() instanceof Player) {
            attacker = (Player)evt.getDamager();
        } else {
            Projectile projectile = (Projectile)evt.getDamager();
            attacker = (Player)projectile.getShooter();
        }
        if (localArena == null) {
            return;
        }
        if (!localArena.getState().equals(GameState.GAME) || localArena.getRespawnTimer().containsKey(player) || localArena.getRespawnTimer().containsKey(attacker)) {
            evt.setCancelled(true);
            return;
        }
        if (!(attacker.getInventory().getItemInHand().equals((Object)Kits.getPlayerKit(attacker).getPrimaryWeapon()) || !localArena.getPlayerKit().get(attacker).equals((Object)KitType.ATHLETE) && attacker.getInventory().getItemInHand().equals((Object)Kits.getPlayerKit(attacker).getSecondaryWeapon()))) {
            evt.setCancelled(true);
            return;
        }
        if (localArena.getPlayerTeam().get(attacker).equals((Object)localArena.getPlayerTeam().get(player))) {
            evt.setCancelled(true);
            return;
        }
        if (this.damagePlayer(player, attacker, localArena, evt.getFinalDamage())) {
            evt.setDamage(0.0);
        }
    }

    public boolean damagePlayer(Player player, Player attacker, LocalArena localArena, double damage) {
        this.sheepCooldown(player);
        Utils.removeSheep(player);
        Location loc = player.getLocation();
        loc.setY(loc.getY() + 1.0);
        if (this.plugin.getConfig().getBoolean("particles.enable-blood")) {
            if (VersionUtils.is1_8()) {
                ParticleEffect.BLOCK_CRACK.sendData(localArena.getPlayerTeam().keySet(), loc.getX(), loc.getY(), loc.getZ(), 0.1, 0.1, 0.1, 0.1, 50, new ItemStack(Material.REDSTONE_BLOCK));
            } else {
                try {
                    BlockData blockData = Bukkit.createBlockData((Material)Material.REDSTONE_BLOCK);
                    attacker.getWorld().spawnParticle(Particle.BLOCK_CRACK, loc, 50, (Object)blockData);
                }
                catch (Error | Exception e) {
                    attacker.getWorld().spawnParticle(Particle.BLOCK_CRACK, loc, 50, (Object)new MaterialData(Material.REDSTONE_BLOCK));
                }
            }
        }
        if (player.getHealth() - damage <= 0.0) {
            player.setHealth(player.getMaxHealth());
            player.setAllowFlight(true);
            for (Player p : localArena.getPlayerTeam().keySet()) {
                p.playSound(player.getLocation(), XSound.ENTITY_PLAYER_DEATH.parseSound(), 1.0f, 1.0f);
            }
            Sounds.playSound(attacker, attacker.getLocation(), "kill");
            Sounds.playSound(player, player.getLocation(), "death");
            Particles.spawnParticle(localArena, player.getLocation().add(0.0, 1.5, 0.0), "death");
            Titles.sendTitle(attacker, 5, 40, 5, " ", this.plugin.getMessage("game.kill-subtitle").replace("%team-color%", localArena.getPlayerTeam().get(player).getChatColor() + "").replace("%player%", player.getName()));
            String killerColor = localArena.getPlayerTeam().get(attacker).getChatColor() + "";
            String playerColor = localArena.getPlayerTeam().get(player).getChatColor() + "";
            for (Player p : localArena.getPlayerTeam().keySet()) {
                p.hidePlayer(player);
                p.sendMessage(this.plugin.getMessage("game.kill").replace("%killer%", attacker.getName()).replace("%player%", player.getName()).replace("%killerTeam%", killerColor).replace("%playerTeam%", playerColor));
            }
            player.getInventory().setItem(0, new ItemStack(Material.AIR));
            player.getInventory().setItem(1, new ItemStack(Material.AIR));
            player.getInventory().setItem(2, new ItemStack(Material.AIR));
            player.getInventory().setItem(7, new ItemStack(Material.AIR));
            player.setFlying(true);
            Location killLoc = player.getLocation();
            killLoc.setY(killLoc.getY() + 3.0);
            player.teleport(killLoc);
            if (this.plugin.getConfig().getBoolean("effects.kill-blindness")) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.BLINDNESS, 60, 2, false, false));
            }
            if (this.plugin.getConfig().getBoolean("effects.kill-slowness")) {
                player.addPotionEffect(new PotionEffect(PotionEffectType.SLOW, 40, 3, false, false));
            }
            localArena.getPlayerStats().get(player).setDeaths(localArena.getPlayerStats().get(player).getDeaths() + 1);
            localArena.getPlayerStats().get(attacker).setKills(localArena.getPlayerStats().get(attacker).getKills() + 1);
            localArena.getRespawnTimer().put(player, this.plugin.getConfig().getInt("respawn-time"));
            this.respawnTimer(player, attacker);
            return true;
        }
        return false;
    }

    private void respawnTimer(final Player player, Player killer) {
        final String killerName = killer.getName();
        final String killerColor = Utils.getLocalArena(player).getPlayerTeam().get(killer).getChatColor() + "";
        new BukkitRunnable(){

            public void run() {
                LocalArena localArena = Utils.getLocalArena(player);
                if (localArena != null && localArena.getRespawnTimer().get(player) != null) {
                    int time = localArena.getRespawnTimer().get(player);
                    if (time > 0 && localArena.getState().equals(GameState.GAME)) {
                        Titles.sendTitle(player, 0, 30, 0, Kill.this.plugin.getMessage("game.respawn-in-title").replace("%team-color%", killerColor).replace("%player%", killerName), Kill.this.plugin.getMessage("game.respawn-in-subtitle").replace("%time%", Integer.toString(time)));
                        ArrayList<Integer> timeStamps = new ArrayList<Integer>(){
                            {
                                this.add(5);
                                this.add(4);
                                this.add(3);
                                this.add(2);
                                this.add(1);
                            }
                        };
                        if (timeStamps.contains(time)) {
                            Sounds.playSound(player, player.getLocation(), "respawn-countdown");
                        }
                        localArena.getRespawnTimer().replace(player, time - 1);
                    } else {
                        Kill.this.respawn(localArena, player);
                        this.cancel();
                    }
                } else {
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void respawn(LocalArena localArena, Player player) {
        player.teleport(ConfigUtils.getSpawn(localArena.getName(), localArena.getPlayerTeam().get(player)));
        player.setAllowFlight(false);
        player.setFlying(false);
        Kits.getPlayerKit(player).giveKit(player);
        for (PotionEffect potionEffect : player.getActivePotionEffects()) {
            player.removePotionEffect(potionEffect.getType());
        }
        for (Player p : localArena.getPlayerTeam().keySet()) {
            p.showPlayer(player);
        }
        Titles.sendTitle(player, 0, 40, 10, this.plugin.getMessage("game.respawned-title"), this.plugin.getMessage("game.respawned-subtitle"));
        Sounds.playSound(localArena, player.getLocation(), "respawn");
        Particles.spawnParticle(localArena, player.getLocation().add(0.0, 1.5, 0.0), "respawn");
        localArena.getRespawnTimer().remove(player);
    }

    private void sheepCooldown(final Player player) {
        final LocalArena localArena = Utils.getLocalArena(player);
        if (localArena.getPlayerStats().get(player).getSheepCooldown() != null) {
            localArena.getPlayerStats().get(player).getSheepCooldown().cancel();
            localArena.getPlayerStats().get(player).setSheepCooldown(null);
        }
        localArena.getPlayerStats().get(player).setSheepCooldown(new BukkitRunnable(){
            int cooldown = 1;

            public void run() {
                if (this.cooldown > 0) {
                    --this.cooldown;
                } else {
                    this.cancel();
                    localArena.getPlayerStats().get(player).setSheepCooldown(null);
                }
            }
        }.runTaskTimerAsynchronously((Plugin)this.plugin, 0L, 20L));
    }
}

