/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.game;

import com.cryptomorin.xseries.messages.ActionBar;
import com.cryptomorin.xseries.messages.Titles;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.Map;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.Particles;
import me.cubixor.sheepquest.spigot.api.Sounds;
import me.cubixor.sheepquest.spigot.commands.PlayCommands;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.config.StatsField;
import me.cubixor.sheepquest.spigot.config.StatsUtils;
import me.cubixor.sheepquest.spigot.game.Kill;
import me.cubixor.sheepquest.spigot.game.Scoreboards;
import me.cubixor.sheepquest.spigot.game.Signs;
import me.cubixor.sheepquest.spigot.game.events.SpecialEvents;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.spigot.gameInfo.GameState;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.gameInfo.PlayerGameStats;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import me.cubixor.sheepquest.spigot.socket.SocketClientSender;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.FireworkEffect;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.Player;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class End {
    private final SheepQuest plugin = SheepQuest.getInstance();
    private Team winnerTeam;

    public void gameEnd(LocalArena localArena) {
        localArena.setState(GameState.ENDING);
        localArena.setTimer(this.plugin.getConfig().getInt("ending-time"));
        LinkedHashMap<Team, Integer> winner = new LinkedHashMap<Team, Integer>();
        for (Team team : localArena.getPoints().keySet()) {
            if (!localArena.getPlayerTeam().containsValue((Object)team)) continue;
            winner.put(team, localArena.getPoints().get((Object)team));
        }
        boolean noWin = this.checkNoWin(winner);
        LinkedHashMap winnerSorted = new LinkedHashMap();
        winner.entrySet().stream().sorted(Map.Entry.comparingByValue(Comparator.reverseOrder())).forEachOrdered(x -> {
            Integer cfr_ignored_0 = (Integer)winnerSorted.put(x.getKey(), x.getValue());
        });
        ArrayList teamsSorted = new ArrayList(winnerSorted.keySet());
        this.winnerTeam = noWin ? Team.NONE : (Team)((Object)new ArrayList(winnerSorted.keySet()).get(0));
        String winnerTeamString = this.winnerTeam.getCode();
        int stay = 20 * this.plugin.getConfig().getInt("ending-time");
        StringBuilder teamPoints = new StringBuilder();
        for (Team team : ConfigUtils.getTeamList(localArena.getName())) {
            teamPoints.append(this.plugin.getMessage("game.summary-points").replace("%team%", team.getName()).replace("%points%", Integer.toString(localArena.getPoints().get((Object)team))));
        }
        for (Player p : localArena.getPlayerTeam().keySet()) {
            boolean won;
            if (localArena.getRespawnTimer().containsKey(p)) {
                new Kill().respawn(localArena, p);
            }
            p.setFlying(false);
            p.setAllowFlight(false);
            ActionBar.clearActionBar(p);
            Utils.removeSheep(p);
            String playerName = p.getName();
            PlayerGameStats playerStats = localArena.getPlayerStats().get(p);
            StatsUtils.addStats(playerName, StatsField.GAMES_PLAYED, 1);
            if (localArena.getPlayerTeam().get(p).equals((Object)this.winnerTeam)) {
                StatsUtils.addStats(playerName, StatsField.WINS, 1);
            } else {
                StatsUtils.addStats(playerName, StatsField.LOOSES, 1);
            }
            StatsUtils.addStats(playerName, StatsField.KILLS, playerStats.getKills());
            StatsUtils.addStats(playerName, StatsField.DEATHS, playerStats.getDeaths());
            StatsUtils.addStats(playerName, StatsField.SHEEP_TAKEN, playerStats.getSheepTaken());
            StatsUtils.addStats(playerName, StatsField.BONUS_SHEEP_TAKEN, playerStats.getBonusSheepTaken());
            boolean bl = won = !noWin && localArena.getPlayerTeam().get(p).equals((Object)this.winnerTeam);
            if (won) {
                Sounds.playSound(p, p.getLocation(), "win");
            } else {
                Sounds.playSound(p, p.getLocation(), "defeat");
            }
            Titles.sendTitle(p, 10, stay - 20, 20, this.plugin.getMessage("game." + (won ? "win" : "defeat") + "-title"), this.plugin.getMessage("game." + (noWin ? "no-win" : "win-defeat") + "-subtitle").replace("%team%", this.plugin.getMessage("general.team-" + winnerTeamString)));
            for (String s : this.plugin.getMessageList("game.summary")) {
                s = s.replace("%teams%", teamPoints.toString()).replace("%kills%", Integer.toString(playerStats.getKills())).replace("%deaths%", Integer.toString(playerStats.getDeaths())).replace("%sheep%", Integer.toString(playerStats.getSheepTaken()));
                p.sendMessage(s);
            }
            Team playerTeam = localArena.getPlayerTeam().get(p);
            if (!this.plugin.getConfig().getBoolean("win-rewards") || noWin) continue;
            String place = Integer.toString(teamsSorted.indexOf((Object)playerTeam) + 1);
            if (this.plugin.getConfig().getStringList("rewards." + place).isEmpty()) continue;
            for (String s : this.plugin.getConfig().getStringList("rewards." + place)) {
                Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)s.replace("%player%", p.getName()));
            }
        }
        this.plugin.savePlayers();
        new Signs().updateSigns(localArena.getName());
        if (this.plugin.isBungee()) {
            Arena arena = new Arena(localArena.getName(), localArena.getServer(), localArena.getState(), localArena.getPlayers());
            new SocketClientSender().sendUpdateArenaPacket(arena);
        }
        this.ending(localArena.getName());
    }

    private void ending(final String arenaString) {
        new BukkitRunnable(){

            public void run() {
                LocalArena localArena = End.this.plugin.getLocalArenas().get(arenaString);
                if (localArena == null) {
                    this.cancel();
                    return;
                }
                if (!localArena.getState().equals(GameState.ENDING)) {
                    this.cancel();
                    return;
                }
                if (localArena.getTimer() > 0) {
                    for (Player p : localArena.getPlayerTeam().keySet()) {
                        p.setScoreboard(new Scoreboards().getEndingScoreboard(localArena, p));
                        if (!localArena.getPlayerTeam().get(p).equals((Object)End.this.winnerTeam)) continue;
                        Firework firework = (Firework)p.getWorld().spawnEntity(p.getLocation(), EntityType.FIREWORK);
                        FireworkMeta fwm = firework.getFireworkMeta();
                        FireworkEffect.Type type = FireworkEffect.Type.BALL;
                        Color color = End.this.winnerTeam.getColor();
                        FireworkEffect fwe = FireworkEffect.builder().flicker(true).withColor(color).with(type).withTrail().build();
                        fwm.addEffect(fwe);
                        fwm.setPower(1);
                        firework.setFireworkMeta(fwm);
                        Particles.spawnParticle(localArena, p.getLocation().add(0.0, 3.0, 0.0), "win");
                    }
                    localArena.setTimer(localArena.getTimer() - 1);
                } else {
                    End.this.resetArena(localArena, true);
                    this.cancel();
                }
            }
        }.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void resetArena(LocalArena localArena, boolean end) {
        PlayCommands playCommands = new PlayCommands();
        String arenaString = localArena.getName();
        this.plugin.getLocalArenas().replace(arenaString, new LocalArena(arenaString));
        for (Entity entity : localArena.getSheep().keySet()) {
            localArena.getSheep().get(entity).cancel();
            entity.remove();
        }
        new SpecialEvents().reset(localArena);
        ArrayList<Player> players = new ArrayList<Player>(localArena.getPlayerTeam().keySet());
        for (Player p : players) {
            if (!end) {
                playCommands.kickFromLocalArena(p, localArena, true, false);
            } else {
                playCommands.kickFromLocalArenaSynchronized(p, localArena, true, true);
            }
            Utils.removeTeamBossBars(p, localArena);
            if (localArena.getPlayerStats().get(p) == null || localArena.getPlayerStats().get(p).getSheepCooldown() == null) continue;
            localArena.getPlayerStats().get(p).getSheepCooldown().cancel();
        }
        new Signs().updateSigns(arenaString);
        if (this.plugin.isBungee()) {
            LocalArena localArena2 = this.plugin.getLocalArenas().get(localArena.getName());
            Arena arena = new Arena(localArena2.getName(), localArena2.getServer(), localArena2.getState(), localArena2.getPlayers());
            new SocketClientSender().sendUpdateArenaPacket(arena);
        }
        if (end && this.plugin.getConfig().getBoolean("auto-join-on-end")) {
            for (Player p : players) {
                playCommands.putInRandomArena(p, false);
            }
        }
    }

    private boolean checkNoWin(LinkedHashMap<Team, Integer> winner) {
        if (winner.size() == 1) {
            return winner.values().toArray()[0].equals(0);
        }
        for (Team team : winner.keySet()) {
            if (winner.get((Object)team).equals(winner.values().toArray()[0])) continue;
            return false;
        }
        return true;
    }
}

