/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.config;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.config.StatsField;
import me.cubixor.sheepquest.spigot.mysql.MysqlConnection;
import org.bukkit.Bukkit;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.plugin.Plugin;

public class StatsUtils {
    private final SheepQuest plugin = SheepQuest.getInstance();
    private final MysqlConnection mysqlConnection = this.plugin.getMysqlConnection();

    public static boolean mysqlEnabled() {
        return SheepQuest.getInstance().getConfig().getBoolean("database.enabled-stats");
    }

    public static int getStats(String player, StatsField statsField) {
        SheepQuest plugin = SheepQuest.getInstance();
        if (plugin.getPlayerInfo().get(Bukkit.getPlayerExact((String)player)) != null) {
            return plugin.getPlayerInfo().get(Bukkit.getPlayerExact((String)player)).getStats().get((Object)statsField);
        }
        return 0;
    }

    public static int getSavedStats(String player, StatsField statsField) {
        SheepQuest plugin = SheepQuest.getInstance();
        if (StatsUtils.mysqlEnabled()) {
            return new StatsUtils().getSqlStats(player, statsField);
        }
        return plugin.getStats().getInt("players." + player + "." + statsField.getCode());
    }

    public static void addStats(String player, StatsField statsField, int count) {
        SheepQuest plugin = SheepQuest.getInstance();
        int statsCount = plugin.getStats().getInt("players." + player + "." + statsField.getCode()) + count;
        if (StatsUtils.mysqlEnabled()) {
            new StatsUtils().updateSqlStats(player, statsField, count);
        } else {
            plugin.getStats().set("players." + player + "." + statsField.getCode(), (Object)statsCount);
        }
        if (plugin.getPlayerInfo().get(Bukkit.getPlayerExact((String)player)) != null) {
            plugin.getPlayerInfo().get(Bukkit.getPlayerExact((String)player)).getStats().replace(statsField, statsCount);
        }
    }

    public static List<String> getPlayers() {
        SheepQuest plugin = SheepQuest.getInstance();
        if (StatsUtils.mysqlEnabled()) {
            return new StatsUtils().getSqlPlayers();
        }
        ConfigurationSection configurationSection = plugin.getStats().getConfigurationSection("players");
        if (configurationSection != null) {
            return new ArrayList<String>(configurationSection.getKeys(false));
        }
        return new ArrayList<String>();
    }

    private List<String> getSqlPlayers() {
        try {
            Connection connection = this.mysqlConnection.getConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT player FROM " + this.mysqlConnection.getDatabase() + "." + this.mysqlConnection.getTableStats());
            ResultSet results = statement.executeQuery();
            ArrayList<String> players = new ArrayList<String>();
            while (results.next()) {
                players.add(results.getString("player"));
            }
            if (Bukkit.isPrimaryThread()) {
                try {
                    throw new Exception("Synchronized database access");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return players;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateSqlStats(String player, StatsField statsField, int count) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                Connection connection = this.mysqlConnection.getConnection();
                PreparedStatement statement = connection.prepareStatement("INSERT INTO " + this.mysqlConnection.getDatabase() + "." + this.mysqlConnection.getTableStats() + " (player, `" + statsField.getCode() + "`) VALUES('" + player + "', " + count + ") ON DUPLICATE KEY UPDATE `" + statsField.getCode() + "`=`" + statsField.getCode() + "`+" + count);
                statement.executeUpdate();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        });
    }

    private int getSqlStats(String player, StatsField statsField) {
        try {
            Connection connection = this.mysqlConnection.getConnection();
            PreparedStatement statement = connection.prepareStatement("SELECT `" + statsField.getCode() + "` FROM " + this.mysqlConnection.getDatabase() + "." + this.mysqlConnection.getTableStats() + " WHERE player='" + player + "'");
            ResultSet results = statement.executeQuery();
            if (Bukkit.isPrimaryThread()) {
                try {
                    throw new Exception("Synchronized database access");
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (results.next()) {
                return results.getInt(statsField.getCode());
            }
            return 0;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public String convertPlaytime(int playtime) {
        String timeString;
        String h = this.plugin.getMessage("other.stats-playtime-hours");
        String min = this.plugin.getMessage("other.stats-playtime-minutes");
        String sec = this.plugin.getMessage("other.stats-playtime-seconds");
        if (playtime < 60) {
            int seconds = playtime;
            timeString = seconds + sec;
        } else if (playtime < 3600) {
            int minutes = playtime / 60;
            int seconds = playtime % 60;
            timeString = minutes + min + " " + seconds + sec;
        } else {
            int hours = playtime / 3600;
            int minutes = playtime % 3600 / 60;
            int seconds = playtime % 60;
            timeString = hours + h + " " + minutes + min + " " + seconds + sec;
        }
        return timeString;
    }
}

