/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.Utils;
import me.cubixor.sheepquest.spigot.api.BossBar;
import me.cubixor.sheepquest.spigot.config.ConfigField;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.game.JoinSheep;
import me.cubixor.sheepquest.spigot.game.Signs;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.spigot.gameInfo.ArenaInventories;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import me.cubixor.sheepquest.spigot.gameInfo.TeamRegion;
import me.cubixor.sheepquest.spigot.socket.SocketClientSender;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Sheep;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class SetupCommands {
    public final SheepQuest plugin = SheepQuest.getInstance();

    public void createArena(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!player.hasPermission("sheepquest.setup.create")) {
                player.sendMessage(this.plugin.getMessage("general.no-permission"));
                return;
            }
            if (args.length != 2) {
                player.sendMessage(this.plugin.getMessage("arena-setup.create-usage"));
                return;
            }
            String arena = args[1];
            if (ConfigUtils.getArenas().contains(arena)) {
                player.sendMessage(this.plugin.getMessage("arena-setup.create-already-exists").replace("%arena%", arena));
                return;
            }
            ConfigUtils.insertArena(arena);
            LocalArena localArena = new LocalArena(arena);
            this.plugin.getLocalArenas().put(args[1], localArena);
            this.plugin.getSigns().put(arena, new ArrayList());
            this.plugin.getInventories().put(player, new ArenaInventories(args[1]));
            if (this.plugin.isBungee()) {
                Arena arenaObj = new Arena(localArena.getName(), localArena.getServer(), localArena.getState(), localArena.getPlayers());
                Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> new SocketClientSender().sendUpdateArenaPacket(arenaObj));
            }
            new Signs().updateSigns("quickjoin");
            player.sendMessage(this.plugin.getMessage("arena-setup.create-success").replace("%arena%", args[1]));
        });
    }

    public void deleteArena(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.delete", "arena-setup.delete", 2, true)) {
                return;
            }
            if (!this.setupCheckActive(player, args[1])) {
                return;
            }
            this.plugin.getPlayerInfo().get(player).setDelete(args[1]);
            this.confirmScheduler(player);
            player.sendMessage(this.plugin.getMessage("arena-setup.delete-confirm").replace("%arena%", args[1]));
        });
    }

    public void deleteConfirm(Player player) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (this.plugin.getPlayerInfo().get(player).getDelete() != null) {
                String arena = this.plugin.getPlayerInfo().get(player).getDelete();
                if (!this.setupCheckActive(player, arena)) {
                    return;
                }
                new Signs().removeSigns(arena);
                this.plugin.getLocalArenas().remove(arena);
                ConfigUtils.removeArena(arena);
                if (this.plugin.isBungee()) {
                    Arena arenaObj = new Arena(arena, this.plugin.getServerName());
                    new SocketClientSender().sendRemoveArenaPacket(arenaObj);
                }
                this.plugin.getPlayerInfo().get(player).setDelete(null);
                new Signs().updateSigns("quickjoin");
                player.sendMessage(this.plugin.getMessage("arena-setup.delete-success").replace("%arena%", arena));
            } else {
                player.sendMessage(this.plugin.getMessage("arena-setup.delete-confirm-none"));
            }
        });
    }

    public void createJoinSheep(Player player) {
        if (!player.hasPermission("sheepquest.setup.joinsheep")) {
            player.sendMessage(this.plugin.getMessage("general.no-permission"));
            return;
        }
        new JoinSheep().spawnSheep(player);
    }

    public void removeJoinSheep(Player player) {
        if (!player.hasPermission("sheepquest.setup.joinsheep")) {
            player.sendMessage(this.plugin.getMessage("general.no-permission"));
            return;
        }
        ArrayList entities = new ArrayList(player.getWorld().getNearbyEntities(player.getLocation(), 1.0, 1.0, 1.0));
        for (Entity entity : entities) {
            if (!entity.getType().equals((Object)EntityType.SHEEP)) continue;
            Sheep sheep = (Sheep)entity;
            ArrayList signList = new ArrayList(this.plugin.getArenasConfig().getStringList("join-sheep"));
            signList.remove(ConfigUtils.locationToString(sheep.getLocation()));
            this.plugin.getArenasConfig().set("join-sheep", signList);
            this.plugin.saveArenas();
            sheep.remove();
            player.sendMessage(this.plugin.getMessage("arena-setup.remove-join-sheep-success"));
            return;
        }
        player.sendMessage(this.plugin.getMessage("arena-setup.remove-join-sheep-no-sheep"));
    }

    public void setLocation(Player player, String[] args, String messagesPath, ConfigField configField, String permission) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, permission, messagesPath, 2, true)) {
                return;
            }
            if (!this.setupCheckActive(player, args[1])) {
                return;
            }
            ConfigUtils.updateField(args[1], configField, ConfigUtils.locationToString(player.getLocation()));
            player.sendMessage(this.plugin.getMessage(messagesPath + "-success").replace("%arena%", args[1]));
        });
    }

    public void addTeam(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.changeteams", "arena-setup.add-team", 3, true)) {
                return;
            }
            if (!this.setupCheckActive(player, args[1])) {
                return;
            }
            Team team = Team.NONE;
            for (Team t : Utils.getTeams()) {
                if (!args[2].equalsIgnoreCase(t.getCode())) continue;
                team = t;
                break;
            }
            if (team.equals((Object)Team.NONE)) {
                player.sendMessage(this.plugin.getMessage("arena-setup.add-team-invalid-team"));
                return;
            }
            ArrayList<Team> teams = new ArrayList<Team>(ConfigUtils.getTeamList(args[1]));
            if (teams.contains((Object)team)) {
                player.sendMessage(this.plugin.getMessage("arena-setup.add-team-already-added"));
                return;
            }
            teams.add(team);
            ArrayList<String> teamsString = new ArrayList<String>();
            for (Team t : teams) {
                teamsString.add(t.getCode());
            }
            ConfigUtils.updateField(args[1], ConfigField.TEAMS, teamsString);
            this.plugin.getLocalArenas().get(args[1]).getTeamBossBars().put(team, new BossBar(this.plugin.getMessage("game.bossbar-team").replace("%team%", team.getName()), team));
            if (ConfigUtils.getArea(args[1], team) != null) {
                this.plugin.getLocalArenas().get(args[1]).getTeamRegions().put(team, new TeamRegion(args[1], team));
            }
            player.sendMessage(this.plugin.getMessage("arena-setup.add-team-success").replace("%arena%", args[1]));
        });
    }

    public void removeTeam(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.changeteams", "arena-setup.remove-team", 3, true)) {
                return;
            }
            if (!this.setupCheckActive(player, args[1])) {
                return;
            }
            Team team = Team.NONE;
            for (Team t : Utils.getTeams()) {
                if (!args[2].equalsIgnoreCase(t.getCode())) continue;
                team = t;
                break;
            }
            if (team.equals((Object)Team.NONE)) {
                player.sendMessage(this.plugin.getMessage("arena-setup.remove-team-invalid-team"));
                return;
            }
            ArrayList<Team> teams = new ArrayList<Team>(ConfigUtils.getTeamList(args[1]));
            if (!teams.contains((Object)team)) {
                player.sendMessage(this.plugin.getMessage("arena-setup.remove-team-not-added"));
                return;
            }
            teams.remove((Object)team);
            ArrayList<String> teamsString = new ArrayList<String>();
            for (Team t : teams) {
                teamsString.add(t.getCode());
            }
            ConfigUtils.updateField(args[1], ConfigField.TEAMS, teamsString);
            ConfigUtils.updateField(args[1], ConfigField.SPAWN, team, null);
            ConfigUtils.updateField(args[1], ConfigField.AREA, team, null);
            player.sendMessage(this.plugin.getMessage("arena-setup.remove-team-success").replace("%arena%", args[1]));
        });
    }

    public void listTeams(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.listteams", "arena-setup.list-teams", 2, true)) {
                return;
            }
            ArrayList<Team> teams = new ArrayList<Team>(ConfigUtils.getTeamList(args[1]));
            StringBuilder addedTeams = new StringBuilder();
            StringBuilder otherTeams = new StringBuilder();
            for (Team team : Utils.getTeams()) {
                if (teams.contains((Object)team)) {
                    addedTeams.append(team.getName()).append(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f, "));
                    continue;
                }
                otherTeams.append(team.getName()).append(ChatColor.translateAlternateColorCodes((char)'&', (String)"&f, "));
            }
            player.sendMessage(this.plugin.getMessage("arena-setup.list-teams-success").replace("%arena%", args[1]).replace("%teams%", addedTeams));
            player.sendMessage(this.plugin.getMessage("arena-setup.list-teams-success2").replace("%arena%", args[1]).replace("%teams%", otherTeams));
        });
    }

    public void setMaxPlayers(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.setmaxplayers", "arena-setup.set-max-players", 3, true)) {
                return;
            }
            if (!this.setupCheckActive(player, args[1])) {
                return;
            }
            try {
                int max = Integer.parseInt(args[2]);
                ConfigUtils.updateField(args[1], ConfigField.MAX_PLAYERS, max);
                player.sendMessage(this.plugin.getMessage("arena-setup.set-max-players-success").replace("%arena%", args[1]));
            }
            catch (NumberFormatException ex) {
                player.sendMessage(this.plugin.getMessage("arena-setup.set-max-players-invalid-count"));
            }
        });
    }

    public void setMinPlayers(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.setminplayers", "arena-setup.set-min-players", 3, true)) {
                return;
            }
            if (!this.setupCheckActive(player, args[1])) {
                return;
            }
            try {
                int min = Integer.parseInt(args[2]);
                if (min >= 2) {
                    ConfigUtils.updateField(args[1], ConfigField.MIN_PLAYERS, min);
                    player.sendMessage(this.plugin.getMessage("arena-setup.set-min-players-success").replace("%arena%", args[1]));
                } else {
                    player.sendMessage(this.plugin.getMessage("arena-setup.set-min-players-too-small"));
                }
            }
            catch (NumberFormatException ex) {
                player.sendMessage(this.plugin.getMessage("arena-setup.set-min-players-invalid-count"));
            }
        });
    }

    public void setTeamSpawn(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.setspawn", "arena-setup.set-spawn", 3, true)) {
                return;
            }
            if (!this.setupCheckActive(player, args[1])) {
                return;
            }
            String teamStr = args[2];
            Team team = this.getTeam(teamStr);
            if (this.getTeam(teamStr) == null) {
                player.sendMessage(this.plugin.getMessage("arena-setup.invalid-team"));
                return;
            }
            ConfigUtils.updateField(args[1], ConfigField.SPAWN, team, (Object)ConfigUtils.locationToString(player.getLocation()));
            player.sendMessage(this.plugin.getMessage("arena-setup.set-spawn-success").replace("%arena%", args[1]).replace("%team%", this.plugin.getMessage("general.team-" + team.getCode())));
        });
    }

    public void setTeamArea(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.setteamarea", "arena-setup.set-teams-area", 3, true)) {
                return;
            }
            if (!this.setupCheckActive(player, args[1])) {
                return;
            }
            String teamStr = args[2];
            Team team = this.getTeam(teamStr);
            if (team == null) {
                player.sendMessage(this.plugin.getMessage("arena-setup.invalid-team"));
                return;
            }
            if (this.plugin.getPlayerInfo().get(player).getSelMin() == null || this.plugin.getPlayerInfo().get(player).getSelMax() == null) {
                player.sendMessage(this.plugin.getMessage("arena-setup.selection-empty"));
                return;
            }
            Location loc1 = this.plugin.getPlayerInfo().get(player).getSelMin().getLocation();
            Location loc2 = this.plugin.getPlayerInfo().get(player).getSelMax().getLocation();
            ConfigUtils.updateField(args[1], ConfigField.AREA, team, (Object)ConfigUtils.joinLocations(loc1, loc2));
            player.sendMessage(this.plugin.getMessage("arena-setup.set-teams-area-success").replace("%arena%", args[1]).replace("%team%", this.plugin.getMessage("general.team-" + team.getCode())));
        });
    }

    public void giveWand(Player player) {
        if (!player.hasPermission("sheepquest.setup.wand")) {
            player.sendMessage(this.plugin.getMessage("general.no-permission"));
            return;
        }
        player.getInventory().addItem(new ItemStack[]{this.plugin.getItems().getSetupWandItem()});
        player.sendMessage(this.plugin.getMessage("arena-setup.wand-item-recive"));
    }

    public void setVip(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.setvip", "arena-setup.set-vip", 3, true)) {
                return;
            }
            if (!args[2].equalsIgnoreCase("true") && !args[2].equalsIgnoreCase("false")) {
                player.sendMessage(this.plugin.getMessage("arena-setup.set-vip-usage"));
                return;
            }
            if (!this.setupCheckActive(player, args[1])) {
                return;
            }
            boolean cmdActive = Boolean.parseBoolean(args[2]);
            boolean active = ConfigUtils.getBoolean(args[1], ConfigField.VIP);
            if (cmdActive && active) {
                player.sendMessage(this.plugin.getMessage("arena-setup.set-vip-arena-vip").replace("%arena%", args[1]));
            } else if (!cmdActive && !active) {
                player.sendMessage(this.plugin.getMessage("arena-setup.set-vip-arena-not-vip").replace("%arena%", args[1]));
            } else {
                ConfigUtils.updateField(args[1], ConfigField.VIP, cmdActive);
                new Signs().updateSigns(args[1]);
                if (cmdActive) {
                    player.sendMessage(this.plugin.getMessage("arena-setup.set-vip-success-vip").replace("%arena%", args[1]));
                } else {
                    player.sendMessage(this.plugin.getMessage("arena-setup.set-vip-success-not-vip").replace("%arena%", args[1]));
                }
            }
        });
    }

    public void reload(Player player) {
        if (!player.hasPermission("sheepquest.setup.reload")) {
            player.sendMessage(this.plugin.getMessage("general.no-permission"));
            return;
        }
        this.plugin.onDisable();
        this.plugin.getInventories().clear();
        this.plugin.getSigns().clear();
        this.plugin.getLocalArenas().clear();
        this.plugin.getArenas().clear();
        this.plugin.loadConfigs();
        player.sendMessage(this.plugin.getMessage("general.reload-success"));
    }

    public void checkArena(Player player, String[] args) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            if (!Utils.checkIfValid(player, args, "sheepquest.setup.check", "arena-setup.check", 2, true)) {
                return;
            }
            String set = this.plugin.getMessage("arena-setup.check-set");
            String notSet = this.plugin.getMessage("arena-setup.check-notset");
            List<String> checkPage = this.plugin.getMessageList("arena-setup.check-page-new");
            LinkedHashMap<ConfigField, Boolean> checkReady = new LinkedHashMap<ConfigField, Boolean>(Utils.checkIfReady(args[1]));
            boolean ready = true;
            boolean active = ConfigUtils.getBoolean(args[1], ConfigField.ACTIVE);
            for (ConfigField configField : checkReady.keySet()) {
                boolean isSet = checkReady.get((Object)configField);
                String toReplace = "%" + configField.getCode().replace(".", "") + "%";
                for (String line : checkPage) {
                    Collections.replaceAll(checkPage, line, line.replace(toReplace, isSet ? set : notSet));
                }
                if (isSet) continue;
                ready = false;
            }
            for (String line : checkPage) {
                Collections.replaceAll(checkPage, line, line.replace("%active%", active ? this.plugin.getMessage("arena-setup.check-active") : this.plugin.getMessage("arena-setup.check-not-active")));
                Collections.replaceAll(checkPage, line, line.replace("%ready%", ready ? this.plugin.getMessage("arena-setup.check-ready") : this.plugin.getMessage("arena-setup.check-not-ready")));
                Collections.replaceAll(checkPage, line, line.replace("%arena%", args[1]));
                Collections.replaceAll(checkPage, line, line.replace("%team%", Integer.toString(ConfigUtils.getTeamList(args[1]).size())));
            }
            for (String s : checkPage) {
                player.sendMessage(s);
            }
        });
    }

    public void confirmScheduler(final Player player) {
        new BukkitRunnable(){

            public void run() {
                if (SetupCommands.this.plugin.getPlayerInfo().get(player) == null) {
                    return;
                }
                SetupCommands.this.plugin.getPlayerInfo().get(player).setDelete(null);
            }
        }.runTaskLater((Plugin)this.plugin, 400L);
    }

    public Team getTeam(String teamString) {
        for (Team team : Team.values()) {
            if (!teamString.equalsIgnoreCase(team.getCode())) continue;
            return team;
        }
        return null;
    }

    private boolean setupCheckActive(Player player, String arena) {
        if (ConfigUtils.getBoolean(arena, ConfigField.ACTIVE)) {
            player.sendMessage(this.plugin.getMessage("arena-setup.active-block").replace("%arena%", arena));
            return false;
        }
        return true;
    }
}

