/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.api;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Scanner;
import java.util.function.Consumer;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class Updater {
    private final Plugin plugin;
    private final int resourceId;

    public Updater(Plugin plugin, int resourceId) {
        this.plugin = plugin;
        this.resourceId = resourceId;
    }

    public void runUpdaterTask() {
        Bukkit.getScheduler().runTaskTimer(this.plugin, this::runUpdater, 0L, 1728000L);
    }

    public void runUpdater() {
        this.getVersion(version -> {
            if (!this.plugin.getDescription().getVersion().equals(version)) {
                this.plugin.getLogger().warning("There is a new update of SheepQuest available!");
                this.plugin.getLogger().warning("Your version: " + this.plugin.getDescription().getVersion());
                this.plugin.getLogger().warning("New version: " + version);
                this.plugin.getLogger().warning("Go to https://www.spigotmc.org/resources/83005/ and download it!");
            }
        });
    }

    public void getVersion(Consumer<String> consumer) {
        Bukkit.getScheduler().runTaskAsynchronously(this.plugin, () -> {
            try (InputStream inputStream = new URL("https://api.spigotmc.org/legacy/update.php?resource=" + this.resourceId).openStream();
                 Scanner scanner = new Scanner(inputStream);){
                if (scanner.hasNext()) {
                    consumer.accept(scanner.next());
                }
            }
            catch (IOException exception) {
                this.plugin.getLogger().info("Cannot look for updates: " + exception.getMessage());
            }
        });
    }
}

