/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot.api;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.cubixor.sheepquest.spigot.SheepQuest;
import me.cubixor.sheepquest.spigot.config.ConfigField;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.gameInfo.Team;
import org.bukkit.Location;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigUpdater {
    public final SheepQuest plugin = SheepQuest.getInstance();

    public void updateConfigs() {
        if (!this.plugin.getConfig().getString("config-version").equals("1.8")) {
            if ((double)Float.parseFloat(this.plugin.getConfig().getString("config-version")) < 1.4) {
                this.plugin.getArenasConfig().set("Signs", null);
            }
            if ((double)Float.parseFloat(this.plugin.getConfig().getString("config-version")) < 1.6) {
                Path path = this.plugin.getArenasFile().toPath();
                File oldArenasFile = new File(this.plugin.getDataFolder(), "arenasOLD.yml");
                Path pathOld = oldArenasFile.toPath();
                try {
                    Files.copy(path, pathOld, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                YamlConfiguration oldArenasConfig = YamlConfiguration.loadConfiguration((File)oldArenasFile);
                this.plugin.saveResource("arenas.yml", true);
                this.plugin.setArenasConfig((FileConfiguration)YamlConfiguration.loadConfiguration((File)this.plugin.getArenasFile()));
                ArrayList<OldArena> oldArenas = new ArrayList<OldArena>();
                for (String arena : oldArenasConfig.getConfigurationSection("Arenas").getKeys(false)) {
                    OldArena oldArena = new OldArena(arena);
                    oldArena.setActive(oldArenasConfig.getBoolean("Arenas." + arena + ".active"));
                    oldArena.setMinPlayers(oldArenasConfig.getInt("Arenas." + arena + ".min-players"));
                    oldArena.setMaxPlayers(oldArenasConfig.getInt("Arenas." + arena + ".max-players"));
                    oldArena.setWaitingLobby((Location)oldArenasConfig.get("Arenas." + arena + ".waiting-lobby"));
                    oldArena.setMainLobby((Location)oldArenasConfig.get("Arenas." + arena + ".main-lobby"));
                    oldArena.setSheepSpawn((Location)oldArenasConfig.get("Arenas." + arena + ".sheep-spawn"));
                    oldArena.setRedSpawn((Location)oldArenasConfig.get("Arenas." + arena + ".teams.red-spawn"));
                    oldArena.setGreenSpawn((Location)oldArenasConfig.get("Arenas." + arena + ".teams.green-spawn"));
                    oldArena.setBlueSpawn((Location)oldArenasConfig.get("Arenas." + arena + ".teams.blue-spawn"));
                    oldArena.setYellowSpawn((Location)oldArenasConfig.get("Arenas." + arena + ".teams.yellow-spawn"));
                    oldArena.setRedAreaMin((Location)oldArenasConfig.get("Arenas." + arena + ".teams-area.red.min-point"));
                    oldArena.setRedAreaMax((Location)oldArenasConfig.get("Arenas." + arena + ".teams-area.red.max-point"));
                    oldArena.setGreenAreaMin((Location)oldArenasConfig.get("Arenas." + arena + ".teams-area.green.min-point"));
                    oldArena.setGreenAreaMax((Location)oldArenasConfig.get("Arenas." + arena + ".teams-area.green.max-point"));
                    oldArena.setBlueAreaMin((Location)oldArenasConfig.get("Arenas." + arena + ".teams-area.blue.min-point"));
                    oldArena.setBlueAreaMax((Location)oldArenasConfig.get("Arenas." + arena + ".teams-area.blue.max-point"));
                    oldArena.setYellowAreaMin((Location)oldArenasConfig.get("Arenas." + arena + ".teams-area.yellow.min-point"));
                    oldArena.setYellowAreaMax((Location)oldArenasConfig.get("Arenas." + arena + ".teams-area.yellow.max-point"));
                    oldArenas.add(oldArena);
                }
                HashMap signs = new HashMap();
                for (String arena : oldArenasConfig.getConfigurationSection("Signs").getKeys(false)) {
                    ArrayList arenaSigns = new ArrayList(oldArenasConfig.getList("Signs." + arena));
                    signs.put(arena, arenaSigns);
                }
                for (OldArena oldArena : oldArenas) {
                    String name = oldArena.getName();
                    ConfigUtils.insertArena(name);
                    ConfigUtils.updateField(name, ConfigField.ACTIVE, oldArena.isActive());
                    ConfigUtils.updateField(name, ConfigField.MIN_PLAYERS, oldArena.getMinPlayers());
                    ConfigUtils.updateField(name, ConfigField.MAX_PLAYERS, oldArena.getMaxPlayers());
                    if (oldArena.getWaitingLobby() != null) {
                        ConfigUtils.updateField(name, ConfigField.WAITING_LOBBY, ConfigUtils.locationToString(oldArena.getWaitingLobby()));
                    }
                    if (oldArena.getMainLobby() != null) {
                        ConfigUtils.updateField(name, ConfigField.MAIN_LOBBY, ConfigUtils.locationToString(oldArena.getMainLobby()));
                    }
                    if (oldArena.getSheepSpawn() != null) {
                        ConfigUtils.updateField(name, ConfigField.SHEEP_SPAWN, ConfigUtils.locationToString(oldArena.getSheepSpawn()));
                    }
                    if (oldArena.getRedSpawn() != null) {
                        ConfigUtils.updateField(name, ConfigField.SPAWN, Team.RED, (Object)ConfigUtils.locationToString(oldArena.getRedSpawn()));
                    }
                    if (oldArena.getGreenSpawn() != null) {
                        ConfigUtils.updateField(name, ConfigField.SPAWN, Team.GREEN, (Object)ConfigUtils.locationToString(oldArena.getGreenSpawn()));
                    }
                    if (oldArena.getBlueSpawn() != null) {
                        ConfigUtils.updateField(name, ConfigField.SPAWN, Team.BLUE, (Object)ConfigUtils.locationToString(oldArena.getBlueSpawn()));
                    }
                    if (oldArena.getYellowSpawn() != null) {
                        ConfigUtils.updateField(name, ConfigField.SPAWN, Team.YELLOW, (Object)ConfigUtils.locationToString(oldArena.getYellowSpawn()));
                    }
                    if (oldArena.getRedAreaMin() != null) {
                        ConfigUtils.updateField(name, ConfigField.AREA, Team.RED, (Object)ConfigUtils.joinLocations(oldArena.getRedAreaMin(), oldArena.getRedAreaMax()));
                    }
                    if (oldArena.getGreenAreaMin() != null) {
                        ConfigUtils.updateField(name, ConfigField.AREA, Team.GREEN, (Object)ConfigUtils.joinLocations(oldArena.getGreenAreaMin(), oldArena.getGreenAreaMax()));
                    }
                    if (oldArena.getBlueAreaMin() != null) {
                        ConfigUtils.updateField(name, ConfigField.AREA, Team.BLUE, (Object)ConfigUtils.joinLocations(oldArena.getBlueAreaMin(), oldArena.getBlueAreaMax()));
                    }
                    if (oldArena.getYellowAreaMin() == null) continue;
                    ConfigUtils.updateField(name, ConfigField.AREA, Team.YELLOW, (Object)ConfigUtils.joinLocations(oldArena.getYellowAreaMin(), oldArena.getYellowAreaMax()));
                }
                for (String arena : signs.keySet()) {
                    ArrayList<String> signList = new ArrayList<String>();
                    for (Location loc : (List)signs.get(arena)) {
                        signList.add(ConfigUtils.locationToString(loc));
                    }
                    this.plugin.getArenasConfig().set("signs." + arena, signList);
                }
                this.plugin.saveArenas();
            }
            if ((double)Float.parseFloat(this.plugin.getConfig().getString("config-version")) < 1.7) {
                for (String arena : this.plugin.getArenasConfig().getConfigurationSection("arenas").getKeys(false)) {
                    ArrayList<String> classicTeams = new ArrayList<String>(){
                        {
                            this.add("red");
                            this.add("green");
                            this.add("blue");
                            this.add("yellow");
                        }
                    };
                    this.plugin.getArenasConfig().set("arenas." + arena + ".teams", (Object)classicTeams);
                    for (String t : classicTeams) {
                        this.plugin.getArenasConfig().set("arenas." + arena + ".spawn." + t, (Object)this.plugin.getArenasConfig().getString("arenas." + arena + "." + t + "-spawn"));
                        this.plugin.getArenasConfig().set("arenas." + arena + "." + t + "-spawn", null);
                        this.plugin.getArenasConfig().set("arenas." + arena + ".area." + t, (Object)this.plugin.getArenasConfig().getString("arenas." + arena + "." + t + "-area"));
                        this.plugin.getArenasConfig().set("arenas." + arena + "." + t + "-area", null);
                    }
                }
                this.plugin.saveArenas();
                this.plugin.getConfig().set("special-events.bonus-sheep.color", (Object)"MAGENTA");
                this.plugin.getConfig().set("sounds", (Object)this.plugin.getConfig().getDefaults().getConfigurationSection("sounds"));
                this.plugin.getConfig().set("particles", (Object)this.plugin.getConfig().getDefaults().getConfigurationSection("particles"));
            }
            if ((double)Float.parseFloat(this.plugin.getConfig().getString("config-version")) < 1.8) {
                this.plugin.getConfig().set("database.ping-peroid", null);
                this.plugin.getConfig().set("sheep-speed", (Object)2.0);
                this.plugin.getConfig().set("special-events.bonus-sheep.speed", (Object)3.0);
                this.plugin.getConfig().set("send-stats", null);
            }
            this.plugin.getConfig().set("config-version", (Object)1.8);
            this.plugin.saveConfig();
        }
    }

    private static class OldArena {
        private final String name;
        private boolean active;
        private int minPlayers;
        private int maxPlayers;
        private Location waitingLobby;
        private Location mainLobby;
        private Location sheepSpawn;
        private Location redSpawn;
        private Location greenSpawn;
        private Location blueSpawn;
        private Location yellowSpawn;
        private Location redAreaMin;
        private Location redAreaMax;
        private Location greenAreaMin;
        private Location greenAreaMax;
        private Location blueAreaMin;
        private Location blueAreaMax;
        private Location yellowAreaMin;
        private Location yellowAreaMax;

        public OldArena(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public int getMinPlayers() {
            return this.minPlayers;
        }

        public void setMinPlayers(int minPlayers) {
            this.minPlayers = minPlayers;
        }

        public int getMaxPlayers() {
            return this.maxPlayers;
        }

        public void setMaxPlayers(int maxPlayers) {
            this.maxPlayers = maxPlayers;
        }

        public Location getWaitingLobby() {
            return this.waitingLobby;
        }

        public void setWaitingLobby(Location waitingLobby) {
            this.waitingLobby = waitingLobby;
        }

        public Location getMainLobby() {
            return this.mainLobby;
        }

        public void setMainLobby(Location mainLobby) {
            this.mainLobby = mainLobby;
        }

        public Location getSheepSpawn() {
            return this.sheepSpawn;
        }

        public void setSheepSpawn(Location sheepSpawn) {
            this.sheepSpawn = sheepSpawn;
        }

        public Location getRedSpawn() {
            return this.redSpawn;
        }

        public void setRedSpawn(Location redSpawn) {
            this.redSpawn = redSpawn;
        }

        public Location getGreenSpawn() {
            return this.greenSpawn;
        }

        public void setGreenSpawn(Location greenSpawn) {
            this.greenSpawn = greenSpawn;
        }

        public Location getBlueSpawn() {
            return this.blueSpawn;
        }

        public void setBlueSpawn(Location blueSpawn) {
            this.blueSpawn = blueSpawn;
        }

        public Location getYellowSpawn() {
            return this.yellowSpawn;
        }

        public void setYellowSpawn(Location yellowSpawn) {
            this.yellowSpawn = yellowSpawn;
        }

        public Location getRedAreaMin() {
            return this.redAreaMin;
        }

        public void setRedAreaMin(Location redAreaMin) {
            this.redAreaMin = redAreaMin;
        }

        public Location getRedAreaMax() {
            return this.redAreaMax;
        }

        public void setRedAreaMax(Location redAreaMax) {
            this.redAreaMax = redAreaMax;
        }

        public Location getGreenAreaMin() {
            return this.greenAreaMin;
        }

        public void setGreenAreaMin(Location greenAreaMin) {
            this.greenAreaMin = greenAreaMin;
        }

        public Location getGreenAreaMax() {
            return this.greenAreaMax;
        }

        public void setGreenAreaMax(Location greenAreaMax) {
            this.greenAreaMax = greenAreaMax;
        }

        public Location getBlueAreaMin() {
            return this.blueAreaMin;
        }

        public void setBlueAreaMin(Location blueAreaMin) {
            this.blueAreaMin = blueAreaMin;
        }

        public Location getBlueAreaMax() {
            return this.blueAreaMax;
        }

        public void setBlueAreaMax(Location blueAreaMax) {
            this.blueAreaMax = blueAreaMax;
        }

        public Location getYellowAreaMin() {
            return this.yellowAreaMin;
        }

        public void setYellowAreaMin(Location yellowAreaMin) {
            this.yellowAreaMin = yellowAreaMin;
        }

        public Location getYellowAreaMax() {
            return this.yellowAreaMax;
        }

        public void setYellowAreaMax(Location yellowAreaMax) {
            this.yellowAreaMax = yellowAreaMax;
        }
    }
}

