/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.spigot;

import com.cryptomorin.xseries.XMaterial;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import me.cubixor.sheepquest.bukkit.Metrics;
import me.cubixor.sheepquest.charts.SimplePie;
import me.cubixor.sheepquest.charts.SingleLineChart;
import me.cubixor.sheepquest.spigot.api.ConfigUpdater;
import me.cubixor.sheepquest.spigot.api.PassengerFix;
import me.cubixor.sheepquest.spigot.api.PlaceholderExpansion;
import me.cubixor.sheepquest.spigot.api.Updater;
import me.cubixor.sheepquest.spigot.api.VersionUtils;
import me.cubixor.sheepquest.spigot.commands.Command;
import me.cubixor.sheepquest.spigot.commands.PlayCommands;
import me.cubixor.sheepquest.spigot.commands.SetupWand;
import me.cubixor.sheepquest.spigot.commands.TabCompleter;
import me.cubixor.sheepquest.spigot.config.ConfigField;
import me.cubixor.sheepquest.spigot.config.ConfigUtils;
import me.cubixor.sheepquest.spigot.game.ArenaProtection;
import me.cubixor.sheepquest.spigot.game.Chat;
import me.cubixor.sheepquest.spigot.game.JoinSheep;
import me.cubixor.sheepquest.spigot.game.Kill;
import me.cubixor.sheepquest.spigot.game.SheepCarrying;
import me.cubixor.sheepquest.spigot.game.Signs;
import me.cubixor.sheepquest.spigot.game.Teams;
import me.cubixor.sheepquest.spigot.game.WaitingTips;
import me.cubixor.sheepquest.spigot.game.kits.Kit;
import me.cubixor.sheepquest.spigot.game.kits.KitArcher;
import me.cubixor.sheepquest.spigot.game.kits.KitAthlete;
import me.cubixor.sheepquest.spigot.game.kits.KitMenu;
import me.cubixor.sheepquest.spigot.game.kits.KitStandard;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.spigot.gameInfo.ArenaInventories;
import me.cubixor.sheepquest.spigot.gameInfo.Items;
import me.cubixor.sheepquest.spigot.gameInfo.Language;
import me.cubixor.sheepquest.spigot.gameInfo.LocalArena;
import me.cubixor.sheepquest.spigot.gameInfo.PlayerInfo;
import me.cubixor.sheepquest.spigot.menu.ArenasMenu;
import me.cubixor.sheepquest.spigot.menu.MenuUtils;
import me.cubixor.sheepquest.spigot.menu.SetupMenu;
import me.cubixor.sheepquest.spigot.menu.StaffMenu;
import me.cubixor.sheepquest.spigot.menu.StatsMenu;
import me.cubixor.sheepquest.spigot.mysql.ConnectionSetup;
import me.cubixor.sheepquest.spigot.mysql.MysqlConnection;
import me.cubixor.sheepquest.spigot.socket.SocketClient;
import me.cubixor.sheepquest.utils.SocketConnection;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.inventivetalent.apihelper.APIManager;
import org.inventivetalent.bossbar.BossBarAPI;

public final class SheepQuest
extends JavaPlugin {
    private final File arenasFile = new File(this.getDataFolder(), "arenas.yml");
    private final File playersFile = new File(this.getDataFolder(), "players.yml");
    private FileConfiguration messagesConfig;
    private FileConfiguration arenasConfig;
    private FileConfiguration playersConfig;
    private final HashMap<String, List<Location>> signs = new HashMap();
    private final HashMap<Player, PlayerInfo> playerInfo = new HashMap();
    private final HashMap<Player, ArenaInventories> inventories = new HashMap();
    private final HashMap<String, LocalArena> localArenas = new HashMap();
    private FileConfiguration connectionConfig;
    private HashMap<String, Arena> arenas = new HashMap();
    private Items items;
    private final List<Kit> kits = new ArrayList<Kit>();
    private boolean enabled = false;
    private boolean passengerFix = false;
    private BukkitTask tipTask;
    private MysqlConnection mysqlConnection;
    private boolean bungee;
    private String serverName;
    private SocketConnection bungeeSocket;
    private static SheepQuest instance;
    public static final String CONFIG_VERSION = "1.8";

    public static SheepQuest getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        VersionUtils.initialize();
        if (VersionUtils.is1_8()) {
            APIManager.require(BossBarAPI.class, (Plugin)this);
            APIManager.initAPI(BossBarAPI.class);
        }
        XMaterial.matchXMaterial("BLACK_STAINED_GLASS").get().parseItem().getData();
        PassengerFix.setupPassengerFix();
        this.kits.add(new KitStandard());
        this.kits.add(new KitArcher());
        this.kits.add(new KitAthlete());
        this.loadConfigs();
        if (!this.getServer().getPluginManager().isPluginEnabled((Plugin)this)) {
            return;
        }
        this.getCommand("sheepquest").setExecutor((CommandExecutor)new Command());
        this.getCommand("t").setExecutor((CommandExecutor)new Command());
        this.getCommand("sheepquest").setTabCompleter((org.bukkit.command.TabCompleter)new TabCompleter());
        this.getServer().getPluginManager().registerEvents((Listener)new Chat(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ArenaProtection(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Kill(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SheepCarrying(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Signs(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SetupWand(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new Teams(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SetupMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new StaffMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new ArenasMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new StatsMenu(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new MenuUtils(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new JoinSheep(), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new KitMenu(), (Plugin)this);
        for (Kit kit : this.kits) {
            this.getServer().getPluginManager().registerEvents((Listener)kit, (Plugin)this);
        }
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            new PlaceholderExpansion().register();
        }
        new Updater((Plugin)this, 83005).runUpdaterTask();
        Metrics metrics = new Metrics(this, 9022);
        metrics.addCustomChart(new SimplePie("used_language", () -> this.getConfig().getString("language", "en")));
        metrics.addCustomChart(new SingleLineChart("games", () -> this.getAllArenas().size()));
        metrics.addCustomChart(new SimplePie("bungee", () -> Boolean.toString(this.getConfig().getBoolean("bungee.bungee-mode", false))));
    }

    public void onDisable() {
        for (String arena : this.getLocalArenas().keySet()) {
            ArrayList<Player> players = new ArrayList<Player>(this.getLocalArenas().get(arena).getPlayerTeam().keySet());
            for (Player p : players) {
                new PlayCommands().kickFromLocalArenaSynchronized(p, this.localArenas.get(arena), false, false);
            }
        }
        if (this.getBungeeSocket() != null) {
            try {
                this.getBungeeSocket().getSocket().close();
                this.getBungeeSocket().getInputStream().close();
                this.getBungeeSocket().getOutputStream().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.getMysqlConnection() != null) {
            try {
                this.getMysqlConnection().getConnection().close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        for (BukkitTask bukkitTask : Bukkit.getScheduler().getPendingTasks()) {
            bukkitTask.cancel();
        }
    }

    public void saveArenas() {
        try {
            this.arenasConfig.save(this.arenasFile);
            this.arenasConfig = YamlConfiguration.loadConfiguration((File)this.arenasFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void savePlayers() {
        try {
            this.playersConfig.save(this.playersFile);
            this.playersConfig = YamlConfiguration.loadConfiguration((File)this.playersFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadConfigs() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this, () -> {
            ConnectionSetup connectionSetup;
            this.getConfig().options().copyDefaults(true);
            this.saveDefaultConfig();
            if (!this.getConfig().getString("config-version").equals(CONFIG_VERSION)) {
                this.saveConfig();
            }
            this.reloadConfig();
            File connectionFile = new File(this.getDataFolder(), "connection.yml");
            for (Language language : Language.values()) {
                String fileName = "messages-" + language.getLanguageCode() + ".yml";
                File messagesFile = new File(this.getDataFolder(), fileName);
                if (!messagesFile.exists()) {
                    this.saveResource(fileName, false);
                }
                YamlConfiguration msgConf = YamlConfiguration.loadConfiguration((File)messagesFile);
                if (!this.getConfig().getString("config-version").equals(CONFIG_VERSION)) {
                    InputStream defConfigStream = this.getResource(fileName);
                    if (defConfigStream != null) {
                        msgConf.setDefaults((Configuration)YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defConfigStream, StandardCharsets.UTF_8)));
                    }
                    msgConf.options().copyDefaults(true);
                    try {
                        msgConf.save(messagesFile);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                if (!this.getConfig().getString("language").equals(language.getLanguageCode())) continue;
                this.messagesConfig = msgConf;
            }
            if (!this.playersFile.exists()) {
                this.saveResource("players.yml", false);
            }
            if (!this.arenasFile.exists()) {
                this.saveResource("arenas.yml", false);
            }
            if (!connectionFile.exists()) {
                this.saveResource("connection.yml", false);
            }
            this.arenasConfig = YamlConfiguration.loadConfiguration((File)this.arenasFile);
            this.playersConfig = YamlConfiguration.loadConfiguration((File)this.playersFile);
            this.connectionConfig = YamlConfiguration.loadConfiguration((File)connectionFile);
            if ((this.getConfig().getBoolean("database.enabled-stats") || this.getConfig().getBoolean("database.enabled-arenas")) && !(connectionSetup = new ConnectionSetup()).connectToDatabase(connectionSetup.mysqlSetup())) {
                Bukkit.getScheduler().runTask((Plugin)this, () -> this.getServer().getPluginManager().disablePlugin((Plugin)this));
                return;
            }
            this.setServerName(this.getConnectionConfig().getString("server-name"));
            new ConfigUpdater().updateConfigs();
            for (String arena : ConfigUtils.getArenas()) {
                this.getSigns().put(arena, new ArrayList());
                if (!ConfigUtils.getString(arena, ConfigField.SERVER).equals(this.getServerName())) continue;
                this.getLocalArenas().put(arena, new LocalArena(arena));
            }
            this.getSigns().put("quickjoin", new ArrayList());
            for (Player p : Bukkit.getOnlinePlayers()) {
                this.getPlayerInfo().replace(p, new PlayerInfo(p.getName()));
            }
            if (this.getConfig().getBoolean("bungee.bungee-mode")) {
                this.setBungee(true);
                new SocketClient().clientSetup(this.getConnectionConfig().getString("host"), this.getConnectionConfig().getInt("port"), this.getConnectionConfig().getString("server-name"));
            }
            for (Kit kit : this.kits) {
                kit.loadItems();
            }
            new WaitingTips().runTipTask();
            this.setItems(new Items());
            new Signs().loadSigns();
            this.enabled = true;
        });
    }

    public void putInventories(Player player, String arena) {
        if (!this.getInventories().containsKey(player)) {
            this.getInventories().put(player, new ArenaInventories(arena));
        } else {
            if (this.getInventories().get(player).getArena() == null) {
                this.getInventories().get(player).setArena(arena);
            }
            if (this.getInventories().get(player).getArena() != null && !this.getInventories().get(player).getArena().equals(arena)) {
                this.getInventories().put(player, new ArenaInventories(arena));
            }
        }
    }

    public String getMessage(String path) {
        String prefix = ChatColor.translateAlternateColorCodes((char)'&', (String)this.messagesConfig.getString("prefix"));
        String message = this.messagesConfig.getString(path).replace("%prefix%", prefix);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public List<String> getMessageList(String path) {
        ArrayList message = new ArrayList(this.messagesConfig.getStringList(path));
        ArrayList<String> finalMessage = new ArrayList<String>();
        for (String s : message) {
            finalMessage.add(ChatColor.translateAlternateColorCodes((char)'&', (String)s));
        }
        return finalMessage;
    }

    public Arena getArena(String name) {
        if (this.getLocalArenas().containsKey(name)) {
            return this.getLocalArenas().get(name);
        }
        if (this.getArenas().containsKey(name)) {
            return this.getArenas().get(name);
        }
        return null;
    }

    public List<Arena> getAllArenas() {
        ArrayList<Arena> arenas = new ArrayList<Arena>();
        arenas.addAll(this.getLocalArenas().values());
        arenas.addAll(this.getArenas().values());
        return arenas;
    }

    public HashMap<String, LocalArena> getLocalArenas() {
        return this.localArenas;
    }

    public HashMap<String, Arena> getArenas() {
        return this.arenas;
    }

    public void setArenas(HashMap<String, Arena> arenas) {
        this.arenas = arenas;
    }

    public File getArenasFile() {
        return this.arenasFile;
    }

    public void setArenasConfig(FileConfiguration arenasConfig) {
        this.arenasConfig = arenasConfig;
    }

    public HashMap<String, List<Location>> getSigns() {
        return this.signs;
    }

    public HashMap<Player, PlayerInfo> getPlayerInfo() {
        return this.playerInfo;
    }

    public HashMap<Player, ArenaInventories> getInventories() {
        return this.inventories;
    }

    public Items getItems() {
        return this.items;
    }

    public void setItems(Items items) {
        this.items = items;
    }

    public FileConfiguration getArenasConfig() {
        return this.arenasConfig;
    }

    public FileConfiguration getStats() {
        return this.playersConfig;
    }

    public MysqlConnection getMysqlConnection() {
        return this.mysqlConnection;
    }

    public void setMysqlConnection(MysqlConnection mysqlConnection) {
        this.mysqlConnection = mysqlConnection;
    }

    public boolean isBungee() {
        return this.bungee;
    }

    public void setBungee(boolean bungee) {
        this.bungee = bungee;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public FileConfiguration getConnectionConfig() {
        return this.connectionConfig;
    }

    public SocketConnection getBungeeSocket() {
        return this.bungeeSocket;
    }

    public void setBungeeSocket(SocketConnection bungeeSocket) {
        this.bungeeSocket = bungeeSocket;
    }

    public List<Kit> getKits() {
        return this.kits;
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public boolean isPassengerFix() {
        return this.passengerFix;
    }

    public void setPassengerFix(boolean passengerFix) {
        this.passengerFix = passengerFix;
    }

    public BukkitTask getTipTask() {
        return this.tipTask;
    }

    public void setTipTask(BukkitTask tipTask) {
        this.tipTask = tipTask;
    }
}

