/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.bungee.socket;

import java.io.IOException;
import java.io.ObjectInputStream;
import me.cubixor.sheepquest.bungee.SheepQuestBungee;
import me.cubixor.sheepquest.bungee.socket.SocketServerSender;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.utils.packets.Packet;
import me.cubixor.sheepquest.utils.packets.classes.ArenaPacket;
import me.cubixor.sheepquest.utils.packets.classes.ArenaPlayerPacket;
import me.cubixor.sheepquest.utils.packets.classes.BackToServerPacket;
import me.cubixor.sheepquest.utils.packets.classes.JoinPacket;
import me.cubixor.sheepquest.utils.packets.classes.KickPacket;
import me.cubixor.sheepquest.utils.packets.classes.ServerArenasPacket;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;

public class SocketServerReceiver {
    private final SheepQuestBungee plugin = SheepQuestBungee.getInstance();

    public void serverMessageReader(ObjectInputStream in) throws IOException, ClassNotFoundException {
        block11: while (true) {
            Object object = in.readObject();
            Packet packet = (Packet)object;
            switch (packet.getPacketType()) {
                case ARENA_UPDATE: {
                    ArenaPacket arenaPacket = (ArenaPacket)object;
                    this.plugin.getArenas().put(arenaPacket.getArena().getName(), arenaPacket.getArena());
                    new SocketServerSender().sendArena(arenaPacket);
                    break;
                }
                case ARENA_REMOVE: {
                    ArenaPacket arenaPacket = (ArenaPacket)object;
                    this.plugin.getArenas().remove(arenaPacket.getArena().getName());
                    new SocketServerSender().removeArena(arenaPacket);
                    break;
                }
                case SERVER_ARENAS_ADD: {
                    ServerArenasPacket serverArenasPacket = (ServerArenasPacket)object;
                    for (Arena arena : serverArenasPacket.getArenas()) {
                        this.plugin.getArenas().put(arena.getName(), arena);
                    }
                    new SocketServerSender().sendServerArenas(serverArenasPacket);
                    break;
                }
                case ARENA_JOIN: {
                    JoinPacket joinPacket = (JoinPacket)object;
                    ProxiedPlayer proxiedPlayer = this.plugin.getProxy().getPlayer(joinPacket.getPlayer());
                    if (proxiedPlayer == null) continue block11;
                    if (joinPacket.isFirstJoin()) {
                        this.plugin.getPlayerServers().put(joinPacket.getPlayer(), proxiedPlayer.getServer().getInfo().getName());
                    }
                    if (joinPacket.isLocalJoin()) break;
                    new SocketServerSender().joinArena(joinPacket);
                    break;
                }
                case ARENA_LEAVE: {
                    ArenaPlayerPacket arenaPlayerPacket = (ArenaPlayerPacket)object;
                    new SocketServerSender().leaveArena(arenaPlayerPacket);
                    break;
                }
                case FORCE_START: {
                    ArenaPlayerPacket arenaPlayerPacket = (ArenaPlayerPacket)object;
                    new SocketServerSender().forceStart(arenaPlayerPacket);
                    break;
                }
                case FORCE_STOP: {
                    ArenaPlayerPacket arenaPlayerPacket = (ArenaPlayerPacket)object;
                    new SocketServerSender().forceStop(arenaPlayerPacket);
                    break;
                }
                case KICK: {
                    KickPacket kickPacket = (KickPacket)object;
                    new SocketServerSender().kick(kickPacket);
                    break;
                }
                case BACK_TO_SERVER: {
                    BackToServerPacket backToServerPacket = (BackToServerPacket)object;
                    ProxiedPlayer proxiedPlayer = this.plugin.getProxy().getPlayer(backToServerPacket.getPlayer());
                    if (proxiedPlayer == null) continue block11;
                    if (backToServerPacket.getServerPriority().equals((Object)BackToServerPacket.ServerPriority.PREVIOUS)) {
                        if (!this.connectToServer(backToServerPacket.getPlayer(), this.plugin.getPlayerServers().get(proxiedPlayer.getName()))) {
                            this.connectToServer(backToServerPacket.getPlayer(), backToServerPacket.getLobby());
                        }
                    } else if (backToServerPacket.getServerPriority().equals((Object)BackToServerPacket.ServerPriority.LOBBY) && !this.connectToServer(backToServerPacket.getPlayer(), backToServerPacket.getLobby())) {
                        this.connectToServer(backToServerPacket.getPlayer(), this.plugin.getPlayerServers().get(proxiedPlayer.getName()));
                    }
                    this.plugin.getPlayerServers().remove(backToServerPacket.getPlayer());
                    break;
                }
            }
        }
    }

    private boolean connectToServer(String player, String serverString) {
        ServerInfo targetServer;
        ProxiedPlayer proxiedPlayer = this.plugin.getProxy().getPlayer(player);
        if (serverString != null && (targetServer = this.plugin.getProxy().getServerInfo(serverString)) != null) {
            if (proxiedPlayer.getServer().getInfo().equals(targetServer)) {
                return true;
            }
            if (this.plugin.getSpigotSocket().containsKey(serverString)) {
                proxiedPlayer.connect(targetServer);
                return true;
            }
        }
        return false;
    }
}

