/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.bungee.socket;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import me.cubixor.sheepquest.bungee.SheepQuestBungee;
import me.cubixor.sheepquest.bungee.socket.SocketServerReceiver;
import me.cubixor.sheepquest.bungee.socket.SocketServerSender;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.utils.SocketConnection;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.plugin.Plugin;

public class SocketServer {
    private final SheepQuestBungee plugin = SheepQuestBungee.getInstance();

    public void serverSetup(int port) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try {
                this.plugin.setServerSocket(new ServerSocket(port));
                this.plugin.getProxy().getLogger().info("[SheepQuest]" + ChatColor.GREEN + " Successfully started a socket server!");
                while (true) {
                    Socket socket = this.plugin.getServerSocket().accept();
                    ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
                    ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
                    String server = objectInputStream.readUTF();
                    SocketConnection socketConnection = new SocketConnection(socket, objectInputStream, objectOutputStream);
                    this.plugin.getSpigotSocket().put(server, socketConnection);
                    this.plugin.getProxy().getLogger().info("[SheepQuest]" + ChatColor.GREEN + " Successfully connected to " + server + " server!");
                    new SocketServerSender().sendAllArenas(server, new ArrayList<Arena>(this.plugin.getArenas().values()));
                    this.serverReceive(server);
                }
            }
            catch (SocketException socket) {
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private void serverReceive(String server) {
        this.plugin.getProxy().getScheduler().runAsync((Plugin)this.plugin, () -> {
            try {
                new SocketServerReceiver().serverMessageReader(this.plugin.getSpigotSocket().get(server).getInputStream());
            }
            catch (IOException e) {
                if (!this.plugin.isDisabling()) {
                    this.plugin.getProxy().getLogger().warning("[SheepQuest] Disconnected from " + server + " server!");
                    new SocketServerSender().removeServerArenas(server);
                    this.plugin.getSpigotSocket().remove(server);
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        });
    }
}

