/*
 * Decompiled with CFR 0.152.
 */
package me.cubixor.sheepquest.bungee;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.ServerSocket;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import me.cubixor.sheepquest.bungee.socket.SocketServer;
import me.cubixor.sheepquest.spigot.gameInfo.Arena;
import me.cubixor.sheepquest.utils.SocketConnection;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.config.Configuration;
import net.md_5.bungee.config.ConfigurationProvider;
import net.md_5.bungee.config.YamlConfiguration;

public class SheepQuestBungee
extends Plugin {
    private static SheepQuestBungee instance;
    private final HashMap<String, Arena> arenas = new HashMap();
    private final HashMap<String, String> playerServers = new HashMap();
    private final HashMap<String, SocketConnection> spigotSocket = new HashMap();
    private ServerSocket serverSocket;
    private Configuration bungeeConfig;
    private boolean disabling;

    public static SheepQuestBungee getInstance() {
        return instance;
    }

    public static void setInstance(SheepQuestBungee instance) {
        SheepQuestBungee.instance = instance;
    }

    public void onEnable() {
        SheepQuestBungee.setInstance(this);
        this.loadConfigs();
        new SocketServer().serverSetup(this.getBungeeConfig().getInt("socket-port"));
    }

    public void onDisable() {
        this.setDisabling(true);
        try {
            this.getServerSocket().close();
            for (SocketConnection socketConnection : this.spigotSocket.values()) {
                socketConnection.getSocket().close();
                socketConnection.getOutputStream().close();
                socketConnection.getInputStream().close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.getProxy().getScheduler().cancel((Plugin)this);
    }

    public void loadConfigs() {
        File file;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdir();
        }
        if (!(file = new File(this.getDataFolder(), "bungee-config.yml")).exists()) {
            try (InputStream in = this.getResourceAsStream("bungee-config.yml");){
                Files.copy(in, file.toPath(), new CopyOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            this.setBungeeConfig(ConfigurationProvider.getProvider(YamlConfiguration.class).load(new File(this.getDataFolder(), "bungee-config.yml")));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HashMap<String, Arena> getArenas() {
        return this.arenas;
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void setServerSocket(ServerSocket serverSocket) {
        this.serverSocket = serverSocket;
    }

    public HashMap<String, SocketConnection> getSpigotSocket() {
        return this.spigotSocket;
    }

    public Configuration getBungeeConfig() {
        return this.bungeeConfig;
    }

    public void setBungeeConfig(Configuration bungeeConfig) {
        this.bungeeConfig = bungeeConfig;
    }

    public HashMap<String, String> getPlayerServers() {
        return this.playerServers;
    }

    public boolean isDisabling() {
        return this.disabling;
    }

    public void setDisabling(boolean disabling) {
        this.disabling = disabling;
    }
}

