/*
 * Decompiled with CFR 0.152.
 */
package me.kilrobot.qrgen.save;

import java.util.ArrayList;
import me.kilrobot.qrgen.qr.QR;
import me.kilrobot.qrgen.save.QRSave;

public class QRSaveManager {
    private static QRSaveManager instance = new QRSaveManager();

    public static QRSaveManager getInstance() {
        return instance;
    }

    public QR getConfig(int id) {
        try {
            String url = (String)QRSave.get().get("maps." + id + ".url");
            Object mapId = QRSave.get().get("maps." + id + ".mapId");
            String path = (String)QRSave.get().get("maps." + id + ".path");
            QR newQr = new QR(url, id, Short.parseShort(String.valueOf(mapId)));
            newQr.setPath(path);
            return newQr;
        }
        catch (Exception exc) {
            return null;
        }
    }

    public void setConfig(QR code) {
        QRSave.get().set("maps." + code.getId() + ".url", (Object)code.getUrl());
        QRSave.get().set("maps." + code.getId() + ".mapId", (Object)code.getMapId());
        QRSave.get().set("maps." + code.getId() + ".path", (Object)code.getPath());
        QRSave.save();
        QRSave.reload();
    }

    public ArrayList<String> listConfig() {
        ArrayList values = null;
        try {
            values = new ArrayList(QRSave.get().getConfigurationSection("maps").getKeys(false));
        }
        catch (Exception exc) {
            values = null;
        }
        return values;
    }

    public void removeConfig(int id) {
        QRSave.get().set("maps." + id, null);
        QRSave.save();
        QRSave.reload();
    }
}

