/*
 * Decompiled with CFR 0.152.
 */
package me.kilrobot.qrgen.qr;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;
import me.kilrobot.qrgen.Qrgen;
import me.kilrobot.qrgen.generator.CodeGenerator;
import me.kilrobot.qrgen.qr.QR;
import me.kilrobot.qrgen.renderer.QrRenderer;
import me.kilrobot.qrgen.save.QRSaveManager;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.map.MapRenderer;
import org.bukkit.map.MapView;

public class QrCodeManager {
    private Qrgen plugin = (Qrgen)Qrgen.getPlugin(Qrgen.class);
    private ArrayList<QR> codeList = new ArrayList();
    private static QrCodeManager instance = new QrCodeManager();

    public static QrCodeManager getInstance() {
        return instance;
    }

    public QR createCode(String url, Player p) {
        QR code = new QR(url, this.codeList.size() + 1);
        try {
            code.setMapId(Bukkit.createMap((World)p.getWorld()).getId());
            this.Initialize(code);
            this.codeList.add(code);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        return code;
    }

    public void loadCodes() throws IOException {
        if (QRSaveManager.getInstance().listConfig() != null) {
            for (String st : QRSaveManager.getInstance().listConfig()) {
                QR code = QRSaveManager.getInstance().getConfig(Integer.parseInt(st));
                this.codeList.add(code);
                MapView map = Bukkit.getMap((short)code.getMapId());
                for (MapRenderer mr : map.getRenderers()) {
                    map.removeRenderer(mr);
                }
                map.addRenderer((MapRenderer)new QrRenderer(ImageIO.read(new File(code.getPath()))));
            }
        }
    }

    public void Initialize(QR code) {
        code.setPath(new File(this.plugin.getDataFolder(), code.getId() + ".png").getAbsolutePath());
        try {
            CodeGenerator.generateQRCodeImage(code, 128, 128);
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        MapView map = Bukkit.getMap((short)code.getMapId());
        for (MapRenderer mr : map.getRenderers()) {
            map.removeRenderer(mr);
        }
        try {
            map.addRenderer((MapRenderer)new QrRenderer(ImageIO.read(new File(code.getPath()))));
        }
        catch (Exception exc) {
            exc.printStackTrace();
        }
        QRSaveManager.getInstance().setConfig(code);
    }
}

