/*
 * Decompiled with CFR 0.152.
 */
package me.kilrobot.qrgen.generator;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.HashMap;
import me.kilrobot.qrgen.qr.QR;

public class CodeGenerator {
    public static void generateQRCodeImage(QR code, int width, int height) throws WriterException, IOException {
        HashMap<EncodeHintType, Integer> hintMap = new HashMap<EncodeHintType, Integer>();
        hintMap.put(EncodeHintType.MARGIN, 1);
        BitMatrix bitMatrix = new QRCodeWriter().encode(code.getUrl(), BarcodeFormat.QR_CODE, width, height, hintMap);
        File f = new File(code.getPath());
        if (!f.getParentFile().exists()) {
            f.mkdirs();
        }
        Path path = FileSystems.getDefault().getPath(code.getPath(), new String[0]);
        MatrixToImageWriter.writeToPath(bitMatrix, "PNG", path);
    }
}

