/*
 * Decompiled with CFR 0.152.
 */
package de.daniel.playerinfo.utils;

import de.daniel.playerinfo.utils.InformationType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;

public class GeolocationRequest {
    private String ipAdress;
    private String country;
    private String region;
    private String city;
    private String timeZone;
    private String internetServiceProvider;

    public GeolocationRequest(String ipAdress) {
        this.ipAdress = ipAdress;
        this.country = this.getGeolocationInfo(InformationType.COUNTRY);
        this.region = this.getGeolocationInfo(InformationType.REGION);
        this.city = this.getGeolocationInfo(InformationType.CITY);
        this.timeZone = this.getGeolocationInfo(InformationType.TIMEZONE);
        this.internetServiceProvider = this.getGeolocationInfo(InformationType.ISP);
    }

    public String getIpAdress() {
        return this.ipAdress;
    }

    public String getCountry() {
        return this.country;
    }

    public String getRegion() {
        return this.region;
    }

    public String getCity() {
        return this.city;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public String getInternetServiceProvider() {
        return this.internetServiceProvider;
    }

    private String getGeolocationInfo(InformationType informationType) {
        String result;
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(new URL("http://ip-api.com/line/" + this.ipAdress).openStream()));
            StringBuilder sb = new StringBuilder();
            while ((line = br.readLine()) != null) {
                sb.append(line).append(System.lineSeparator());
            }
            br.close();
            result = sb.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            result = null;
        }
        if (result != null && result.startsWith("success")) {
            String[] resultLines = result.split("\n");
            switch (informationType) {
                case IP: {
                    return resultLines[13];
                }
                case COUNTRY: {
                    return resultLines[1];
                }
                case REGION: {
                    return resultLines[4];
                }
                case CITY: {
                    return resultLines[5];
                }
                case TIMEZONE: {
                    return resultLines[9];
                }
                case ISP: {
                    return resultLines[10];
                }
            }
            return "Error";
        }
        return "Error";
    }
}

