/*
 * Decompiled with CFR 0.152.
 */
package de.daniel.playerinfo.main;

import de.daniel.playerinfo.commands.PlayerInfoCommand;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class Main
extends JavaPlugin {
    private static Main instance;
    private FileConfiguration configuration;
    private String prefix;

    public static Main getInstance() {
        return instance;
    }

    public FileConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void onEnable() {
        this.createDefaultConfigs();
        this.init();
        this.registerCommands();
        Bukkit.getServer().getConsoleSender().sendMessage(this.getPrefix() + this.getConfiguration().getString("messages.onenablemessage"));
    }

    public void onDisable() {
        Bukkit.getServer().getConsoleSender().sendMessage(this.getPrefix() + this.getConfiguration().getString("messages.ondisablemessage"));
    }

    private void init() {
        instance = this;
        this.prefix = this.getConfiguration().getString("messages.prefix");
    }

    private void registerCommands() {
        Objects.requireNonNull(this.getCommand("playerinfo")).setExecutor((CommandExecutor)new PlayerInfoCommand());
    }

    private void createDefaultConfigs() {
        File configYml = new File(this.getDataFolder(), "config.yml");
        if (!configYml.exists()) {
            configYml.getParentFile().mkdirs();
            this.saveResource("config.yml", true);
        }
        this.configuration = new YamlConfiguration();
        try {
            this.configuration.load(configYml);
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
    }
}

