/*
 * Decompiled with CFR 0.152.
 */
package de.daniel.playerinfo.commands;

import de.daniel.playerinfo.main.Main;
import de.daniel.playerinfo.utils.GeolocationRequest;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Player;

public class PlayerInfoCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (sender instanceof Player || sender instanceof ConsoleCommandSender) {
            if (sender.hasPermission(Objects.requireNonNull(Main.getInstance().getConfiguration().getString("permissions.commands.playerinfo")))) {
                if (args.length == 1) {
                    Player target = Bukkit.getServer().getPlayer(args[0]);
                    if (target != null) {
                        String targetIp = Objects.requireNonNull(target.getAddress()).getAddress().getHostAddress();
                        GeolocationRequest geolocationRequest = new GeolocationRequest(targetIp);
                        sender.sendMessage(Main.getInstance().getPrefix() + "Information about " + target.getName() + ":");
                        sender.sendMessage(Main.getInstance().getPrefix() + "Name: " + target.getName());
                        sender.sendMessage(Main.getInstance().getPrefix() + "IP: " + geolocationRequest.getIpAdress());
                        sender.sendMessage(Main.getInstance().getPrefix() + "Country: " + geolocationRequest.getCountry());
                        sender.sendMessage(Main.getInstance().getPrefix() + "Region: " + geolocationRequest.getRegion());
                        sender.sendMessage(Main.getInstance().getPrefix() + "City: " + geolocationRequest.getCity());
                        sender.sendMessage(Main.getInstance().getPrefix() + "Timezone: " + geolocationRequest.getTimeZone());
                        sender.sendMessage(Main.getInstance().getPrefix() + "ISP: " + geolocationRequest.getInternetServiceProvider());
                    } else {
                        String noValidPlayer = Objects.requireNonNull(Main.getInstance().getConfiguration().getString("messages.novalidplayer")).replace("%player%", args[0]);
                        sender.sendMessage(Main.getInstance().getPrefix() + noValidPlayer);
                    }
                } else {
                    String wrongUse = Objects.requireNonNull(Main.getInstance().getConfiguration().getString("messages.wronguse")).replace("%command%", "/playerinfo <player>");
                    sender.sendMessage(Main.getInstance().getPrefix() + wrongUse);
                }
            } else {
                sender.sendMessage(Main.getInstance().getPrefix() + Main.getInstance().getConfiguration().getString("messages.noperms"));
            }
        } else {
            sender.sendMessage(Main.getInstance().getPrefix() + Main.getInstance().getConfiguration().getString("messages.novalidsender"));
        }
        return false;
    }
}

