/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.teleport;

import java.util.Dictionary;
import java.util.Hashtable;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.teleport.CancelCause;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public enum TeleportCore implements Listener
{
    INSTANCE;

    private static final Dictionary<String, CancelCause> cancelCause;
    private static final Dictionary<String, Boolean> playersInCooldown;
    private static final Dictionary<String, BukkitTask> playerTeleport;
    private static final Dictionary<String, Object[]> invulnerablePlayers;

    public void start(BkPlugin plugin) {
        plugin.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)plugin);
        INSTANCE.getPlayersInCooldown().put("Core-Started", true);
    }

    public static Dictionary<String, CancelCause> getCancelCause() {
        return cancelCause;
    }

    public static Dictionary<String, Boolean> getPlayersInCooldown() {
        return playersInCooldown;
    }

    public static Dictionary<String, BukkitTask> getPlayerTeleport() {
        return playerTeleport;
    }

    public static Dictionary<String, Object[]> getInvulnerablePlayers() {
        return invulnerablePlayers;
    }

    private boolean checkInvulnerable(EntityDamageByEntityEvent event, Player damagerPlayer, int key, String name) {
        Object[] values = INSTANCE.getInvulnerablePlayers().get(name);
        if (values != null) {
            int length = (Integer)values[0];
            float count = ((Float)values[1]).floatValue();
            String[] messages = (String[])values[3];
            float remaining = (float)length - count;
            if (remaining > 0.0f) {
                int tempInt = (int)remaining > 0 ? (int)remaining : 1;
                damagerPlayer.sendMessage(messages[key].replace("{seconds}", String.valueOf(tempInt)));
                event.setCancelled(true);
                return true;
            }
        }
        return false;
    }

    @EventHandler
    public void onPlayerTakeDamage(EntityDamageEvent event) {
        if (event.getEntityType().equals((Object)EntityType.PLAYER)) {
            Player damagedPlayer = (Player)event.getEntity();
            if (INSTANCE.getInvulnerablePlayers().get(damagedPlayer.getName()) != null) {
                float count;
                Object[] values = INSTANCE.getInvulnerablePlayers().get(damagedPlayer.getName());
                int length = (Integer)values[0];
                float remaining = (float)length - (count = ((Float)values[1]).floatValue());
                if (remaining > 0.0f) {
                    event.setCancelled(true);
                    return;
                }
            }
            if (INSTANCE.getPlayersInCooldown().get(damagedPlayer.getName()) != null) {
                INSTANCE.getPlayersInCooldown().put(damagedPlayer.getName(), false);
                INSTANCE.getCancelCause().put(damagedPlayer.getName(), CancelCause.DealtDamage);
            }
        }
    }

    @EventHandler
    public void onPlayerDealDamage(EntityDamageByEntityEvent event) {
        if (event.getDamager().getType().equals((Object)EntityType.PLAYER)) {
            Player damagerPlayer = (Player)event.getDamager();
            if (INSTANCE.getInvulnerablePlayers().get(damagerPlayer.getName()) != null ? this.checkInvulnerable(event, damagerPlayer, 0, damagerPlayer.getName()) : INSTANCE.getInvulnerablePlayers().get(event.getEntity().getName()) != null && this.checkInvulnerable(event, damagerPlayer, 1, event.getEntity().getName())) {
                return;
            }
            if (INSTANCE.getPlayersInCooldown().get(damagerPlayer.getName()) != null) {
                INSTANCE.getPlayersInCooldown().put(damagerPlayer.getName(), false);
                INSTANCE.getCancelCause().put(damagerPlayer.getName(), CancelCause.TookDamage);
            }
        }
    }

    static {
        cancelCause = new Hashtable<String, CancelCause>();
        playersInCooldown = new Hashtable<String, Boolean>();
        playerTeleport = new Hashtable<String, BukkitTask>();
        invulnerablePlayers = new Hashtable<String, Object[]>();
    }
}

