/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.commands.warp;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import me.bkrmt.bkteleport.BkTeleport;
import me.bkrmt.bkteleport.PluginUtils;
import me.bkrmt.bkteleport.UserType;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.command.Executor;
import me.bkrmt.bkteleport.bkcore.teleport.Teleport;
import me.bkrmt.bkteleport.bkcore.teleport.TeleportType;
import me.bkrmt.teleport.TeleportCore;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.inventory.Inventory;

public class WarpCmd
extends Executor {
    public WarpCmd(BkPlugin plugin, String langKey, String permission) {
        super(plugin, langKey, permission);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission(sender)) {
            sender.sendMessage(this.getPlugin().getLangFile().get("error.no-permission"));
        } else if (!(sender instanceof Player)) {
            if (args.length == 2) {
                this.sendOtherToWarp(sender, args);
            } else {
                this.getPlugin().getLogger().log(Level.INFO, ChatColor.RED + "Use: /warp <warp-name> <player>");
            }
        } else if (args.length == 0) {
            this.sendWarps((Player)sender);
        } else if (args.length == 1) {
            this.sendToWarp(sender, args, true);
        } else if (args.length == 2) {
            if (sender.hasPermission("bkteleport.warp.others")) {
                this.sendOtherToWarp(sender, args);
            } else {
                sender.sendMessage(this.getPlugin().getLangFile().get("error.no-permission"));
            }
        } else {
            this.sendUsage(sender);
        }
        return true;
    }

    private void sendOtherToWarp(CommandSender sender, String[] args) {
        Player target = Utils.getPlayer(args[1]);
        if (target != null) {
            this.sendToWarp((CommandSender)target, args, false);
        } else {
            sender.sendMessage(this.getPlugin().getLangFile().get("error.player-not-found").replace("{player}", args[1]));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void sendToWarp(CommandSender sender, String[] args, boolean checkPermission) {
        if (!this.getPlugin().getFile("warps", args[0].toLowerCase() + ".yml").exists()) {
            sender.sendMessage(this.getPlugin().getLangFile().get("error.unknown-warp").replace("{warp-name}", args[0]));
            return;
        }
        if (checkPermission && !sender.hasPermission("bkteleport.warp." + args[0].toLowerCase()) && !sender.hasPermission("bkteleport.warp.*")) {
            sender.sendMessage(this.getPlugin().getLangFile().get("error.no-permission"));
            return;
        }
        if (TeleportCore.INSTANCE.getPlayersInCooldown().get(sender.getName()) == null) {
            new Teleport(this.getPlugin(), sender, args[0], TeleportType.Warp);
            return;
        }
        sender.sendMessage(this.getPlugin().getLangFile().get("error.already-waiting"));
    }

    private void sendWarps(Player sender) {
        if (BkTeleport.plugin.getConfigManager().getConfig().getBoolean("custom-warps-list-command.enabled")) {
            BkTeleport.plugin.getServer().getPluginManager().callEvent((Event)new PlayerCommandPreprocessEvent(sender, BkTeleport.plugin.getConfigManager().getConfig().getString("custom-warps-list-command.command")));
        } else {
            File warpsFolder = BkTeleport.plugin.getFile("warps", "");
            if (warpsFolder.listFiles().length > 0) {
                File[] warps = warpsFolder.listFiles();
                ArrayList<String[]> tempList = new ArrayList<String[]>();
                for (File warp : warps) {
                    String[] temp = this.getPlugin().getConfigManager().getConfig("warps", warp.getName()).getString("name");
                    if (!sender.hasPermission("bkteleport.warp." + (String)temp) && !sender.hasPermission("bkteleport.warp.*")) continue;
                    tempList.add(temp);
                }
                String[] keys = tempList.toArray(new String[0]);
                int warpAmount = keys.length;
                if (warpAmount > 0) {
                    if (this.getPlugin().getConfigManager().getConfig().getBoolean("warp-gui")) {
                        Inventory warpsMenu = this.getPlugin().getServer().createInventory(null, (int)Math.ceil((double)warpAmount / 9.0) * 9, this.getPlugin().getLangFile().get("info.warp-list-title"));
                        for (int c = 0; c < warpAmount; ++c) {
                            warpsMenu.setItem(c, Utils.createItem(this.getPlugin(), ChatColor.translateAlternateColorCodes((char)'&', (String)("&7&l&o" + keys[c])), this.getPlugin().getHandler().getItemManager().getSign(), ChatColor.translateAlternateColorCodes((char)'&', (String)("&7&o/warp " + keys[c]))));
                        }
                        sender.openInventory(warpsMenu);
                    } else {
                        TextComponent line = new TextComponent(Utils.translateColor(BkTeleport.plugin.getLangFile().get("info.warp-list.start")));
                        String commandString = BkTeleport.plugin.getLangFile().get("commands.warp.command");
                        ArrayList<String> allowedWarps = new ArrayList<String>();
                        for (String warpName : keys) {
                            if (!sender.hasPermission("bkteleport.warp." + warpName)) continue;
                            allowedWarps.add(warpName);
                        }
                        Iterator it = allowedWarps.iterator();
                        while (it.hasNext()) {
                            String warpName = (String)it.next();
                            line.addExtra((BaseComponent)PluginUtils.getTextComponent(commandString, warpName, UserType.User, TeleportType.Warp));
                            if (!it.hasNext()) continue;
                            line.addExtra(Utils.translateColor(BkTeleport.plugin.getLangFile().get("info.home-list.separator")));
                        }
                        line.addExtra(Utils.translateColor(BkTeleport.plugin.getLangFile().get("info.home-list.end")));
                        sender.spigot().sendMessage((BaseComponent)line);
                    }
                } else {
                    sender.sendMessage(this.getPlugin().getLangFile().get("error.no-warps"));
                }
            } else {
                sender.sendMessage(this.getPlugin().getLangFile().get("error.no-warps"));
            }
        }
    }
}

