/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.commands.tp;

import me.bkrmt.bkteleport.RequestType;
import me.bkrmt.bkteleport.TeleportRequest;
import me.bkrmt.bkteleport.TpaUtils;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.command.Executor;
import me.bkrmt.bkteleport.events.PlayerBkTeleportSendEvent;
import me.bkrmt.teleport.TeleportCore;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;

public class TpaCmd
extends Executor {
    public TpaCmd(BkPlugin plugin, String langKey, String permission) {
        super(plugin, langKey, permission);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission(sender)) {
            sender.sendMessage(this.getPlugin().getLangFile().get("error.no-permission"));
        } else if (args.length == 1) {
            if (this.getPlugin().getServer().getPlayer(args[0]) != null) {
                if (TeleportCore.INSTANCE.getPlayersInCooldown().get(sender.getName()) == null) {
                    Player senderPlayer = (Player)sender;
                    Player targetPlayer = this.getPlugin().getServer().getPlayer(args[0]);
                    if (!senderPlayer.equals(targetPlayer)) {
                        RequestType type = TpaUtils.isExpiring(senderPlayer.getName().toLowerCase(), targetPlayer.getName().toLowerCase());
                        if (type == null) {
                            new TeleportRequest(senderPlayer, targetPlayer, RequestType.Tpa).sendMessage();
                            targetPlayer.playSound(targetPlayer.getLocation(), this.getPlugin().getHandler().getSoundManager().getPling(), 15.0f, 1.0f);
                            senderPlayer.sendMessage(this.getPlugin().getLangFile().get("info.sent-invite").replace("{player}", targetPlayer.getName()));
                            TpaUtils.checkExpired((Player)sender, targetPlayer, RequestType.Tpa);
                            PlayerBkTeleportSendEvent reqSendEvent = new PlayerBkTeleportSendEvent((Player)sender, targetPlayer);
                            this.getPlugin().getServer().getPluginManager().callEvent((Event)reqSendEvent);
                            if (reqSendEvent.isCancelled()) {
                                type = TpaUtils.isExpiring(senderPlayer.getName().toLowerCase(), targetPlayer.getName().toLowerCase());
                                TpaUtils.playerExpiredChecker.get(senderPlayer.getName().toLowerCase() + "-" + targetPlayer.getName().toLowerCase() + "-" + type.toString()).cancel();
                                TpaUtils.playerExpiredChecker.remove(senderPlayer.getName().toLowerCase() + "-" + targetPlayer.getName().toLowerCase() + "-" + type.toString());
                            }
                        } else {
                            sender.sendMessage(this.getPlugin().getLangFile().get("error.cant-invite-again"));
                        }
                    } else {
                        sender.sendMessage(this.getPlugin().getLangFile().get("error.cant-invite-self"));
                    }
                } else {
                    sender.sendMessage(this.getPlugin().getLangFile().get("error.already-waiting"));
                }
            } else {
                sender.sendMessage(this.getPlugin().getLangFile().get("error.player-not-found").replace("{player}", args[0]));
            }
        } else {
            this.sendUsage(sender);
        }
        return true;
    }
}

