/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.commands.home;

import java.io.File;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.command.Executor;
import me.bkrmt.bkteleport.bkcore.config.ConfigType;
import me.bkrmt.bkteleport.bkcore.config.Configuration;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SetHomeCmd
extends Executor {
    public SetHomeCmd(BkPlugin plugin, String langKey, String permission) {
        super(plugin, langKey, permission);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission(sender)) {
            sender.sendMessage(this.getPlugin().getLangFile().get("error.no-permission"));
        } else {
            int homeSize;
            Configuration configFile;
            int maxHomes = this.getMaxHomes(sender, "bkteleport.maxhomes");
            File homesFile = this.getPlugin().getFile("userdata", ((Player)sender).getUniqueId().toString() + ".yml");
            if (homesFile.exists()) {
                configFile = this.getPlugin().getConfigManager().getConfig("userdata", ((Player)sender).getUniqueId().toString() + ".yml");
            } else {
                configFile = new Configuration(this.getPlugin(), homesFile, ConfigType.Player_Data);
                configFile.saveToFile();
                this.getPlugin().getConfigManager().addConfig(configFile);
            }
            int n = homeSize = configFile == null || configFile.get("homes") == null ? 0 : configFile.getConfigurationSection("homes").getKeys(false).size();
            if (homeSize < maxHomes) {
                if (args.length == 0) {
                    String homeCmd = this.getPlugin().getLangFile().get("commands.home.command");
                    this.setHomeValues(homeCmd, sender);
                    this.getPlugin().sendTitle((Player)sender, 5, 40, 10, this.getPlugin().getLangFile().get("info.home-set").replace("{home-name}", homeCmd), "");
                } else if (args.length == 1) {
                    this.setHomeValues(args[0], sender);
                    this.getPlugin().sendTitle((Player)sender, 5, 40, 10, this.getPlugin().getLangFile().get("info.home-set").replace("{home-name}", args[0]), "");
                } else {
                    this.sendUsage(sender);
                }
            } else {
                sender.sendMessage(this.getPlugin().getLangFile().get("error.home-limit").replace("{max-homes}", String.valueOf(maxHomes)));
            }
        }
        return true;
    }

    private int getMaxHomes(CommandSender cmdSender, String permission) {
        int returnValue = 5;
        for (int c = 99; c > 0; --c) {
            if (!cmdSender.hasPermission(permission + "." + c)) continue;
            returnValue = c;
            break;
        }
        return returnValue;
    }

    private void setHomeValues(String homeName, CommandSender sender) {
        Configuration configFile = this.getPlugin().getConfigManager().getConfig("userdata", ((Player)sender).getUniqueId().toString() + ".yml");
        configFile.set("player", sender.getName());
        configFile.setLocation("homes." + homeName, ((Player)sender).getLocation());
        configFile.saveToFile();
    }
}

