/*
 * Decompiled with CFR 0.152.
 */
package me.bkrmt.bkteleport.commands.home;

import java.io.File;
import me.bkrmt.bkteleport.HomeType;
import me.bkrmt.bkteleport.PluginUtils;
import me.bkrmt.bkteleport.UserType;
import me.bkrmt.bkteleport.bkcore.BkPlugin;
import me.bkrmt.bkteleport.bkcore.Utils;
import me.bkrmt.bkteleport.bkcore.command.Executor;
import me.bkrmt.bkteleport.bkcore.config.Configuration;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;

public class DelHomeCmd
extends Executor {
    public DelHomeCmd(BkPlugin plugin, String langKey, String permission) {
        super(plugin, langKey, permission);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!this.hasPermission(sender)) {
            sender.sendMessage(this.getPlugin().getLangFile().get("error.no-permission"));
        } else if (args.length == 1 && args[0].contains(":")) {
            if (sender.hasPermission("bkteleport.spy.delhome")) {
                String[] spy = args[0].split(":");
                Player spied = Utils.getPlayer(spy[0]);
                String spiedFile = null;
                if (spied == null) {
                    for (File homesFile : new File(this.getPlugin().getDataFolder().getPath() + File.separator + "userdata").listFiles()) {
                        YamlConfiguration tempConfig = YamlConfiguration.loadConfiguration((File)homesFile);
                        if (tempConfig.getString("player") == null || !tempConfig.getString("player").equalsIgnoreCase(spy[0])) continue;
                        spiedFile = homesFile.getName();
                        break;
                    }
                }
                if (spiedFile == null && spied != null) {
                    spiedFile = spied.getUniqueId().toString() + ".yml";
                } else if (spiedFile == null) {
                    sender.sendMessage(this.getPlugin().getLangFile().get("error.homes-not-found").replace("{player}", spy[0]));
                    return true;
                }
                if (spy.length == 2) {
                    if (this.getPlugin().getFile("userdata", spiedFile).exists()) {
                        Configuration spyConfigFile = this.getPlugin().getConfigManager().getConfig("userdata", spiedFile);
                        if (spyConfigFile.get("homes." + spy[1]) != null) {
                            DelHomeCmd.deleteHome(this.getPlugin(), sender, spyConfigFile, spy[1]);
                        } else {
                            sender.sendMessage(this.getPlugin().getLangFile().get("error.unknown-home").replace("{home-name}", spy[1]));
                        }
                    } else {
                        sender.sendMessage(this.getPlugin().getLangFile().get("error.unknown-home-spy").replace("{player}", spy[0]).replace("{home-name}", spy[1]));
                    }
                } else if (spy.length == 1) {
                    PluginUtils.sendHomes(UserType.Spy, HomeType.DelHome, this.getPlugin().getFile("userdata", spiedFile), sender);
                } else {
                    sender.sendMessage(this.getPlugin().getLangFile().get("error.wrong-spy-format"));
                }
            } else {
                sender.sendMessage(this.getPlugin().getLangFile().get("error.no-permission"));
            }
        } else if (args.length == 1) {
            if (this.getPlugin().getFile("userdata", ((Player)sender).getUniqueId().toString() + ".yml").exists()) {
                Configuration configFile = this.getPlugin().getConfigManager().getConfig("userdata", ((Player)sender).getUniqueId().toString() + ".yml");
                if (configFile.get("homes." + args[0]) == null) {
                    sender.sendMessage(this.getPlugin().getLangFile().get("error.unknown-home").replace("{home-name}", args[0]));
                } else {
                    sender.sendMessage(this.getPlugin().getLangFile().get("info.home-deleted"));
                    configFile.set("player", sender.getName());
                    configFile.set("homes." + args[0], null);
                    configFile.saveToFile();
                }
            } else {
                sender.sendMessage(this.getPlugin().getLangFile().get("error.unknown-home").replace("{home-name}", args[0]));
            }
        } else {
            this.sendUsage(sender);
        }
        return true;
    }

    public static void deleteHome(BkPlugin plugin, CommandSender sender, Configuration spyConfigFile, String home) {
        sender.sendMessage(plugin.getLangFile().get("info.home-deleted"));
        spyConfigFile.set("homes." + home, null);
        spyConfigFile.saveToFile();
    }
}

